package jp.agentec.abook.abv.ui.viewer.view;

import android.content.Context;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.webkit.WebView;

/**
 * WebViewのキーボード検知するクラス
 */
public class CheckFormWebview extends WebView {

    private Context mContext;
    private KeyActionCallback mKeyActionCallback;

    public interface KeyActionCallback {
        void keyActionCallback(int editorInfoAction);
    }

    public CheckFormWebview(Context context, KeyActionCallback callback) {
        super(context);
        mContext = context;
        mKeyActionCallback = callback;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo ei) {
        InputConnection input = super.onCreateInputConnection(ei);
        if(input == null) {
            return null;
        }
        return new MyConnection(input);
    }

    private class MyConnection extends InputConnectionWrapper {
        public MyConnection(InputConnection wrapped) {
            super(wrapped, false);
        }

        // WebView上でIMEキーボードのアクションがあった場合のハンドリングを行う
        @Override
        public boolean performEditorAction(int action) {
            if(mKeyActionCallback != null) {
                mKeyActionCallback.keyActionCallback(action);
            }
            return true;
        }
    }
}
