/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oz.lottie.FontAssetDelegate;
import oz.lottie.ImageAssetDelegate;
import oz.lottie.L;
import oz.lottie.LottieAnimationView$1;
import oz.lottie.LottieAnimationView$2;
import oz.lottie.LottieAnimationView$3;
import oz.lottie.LottieAnimationView$4;
import oz.lottie.LottieAnimationView$SavedState;
import oz.lottie.LottieComposition;
import oz.lottie.LottieCompositionFactory;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieListener;
import oz.lottie.LottieOnCompositionLoadedListener;
import oz.lottie.LottieTask;
import oz.lottie.PerformanceTracker;
import oz.lottie.RenderMode;
import oz.lottie.TextDelegate;
import oz.lottie.model.KeyPath;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;
import oz.lottie.value.SimpleLottieValueCallback;

public class LottieAnimationView
extends ImageView {
    private static final String TAG = LottieAnimationView.class.getSimpleName();
    private static final LottieListener DEFAULT_FAILURE_LISTENER = new LottieAnimationView$1();
    private final LottieListener loadedListener = new LottieAnimationView$2(this);
    private final LottieListener wrappedFailureListener = new LottieAnimationView$3(this);
    private LottieListener failureListener;
    private int fallbackResource = 0;
    private final LottieDrawable lottieDrawable = new LottieDrawable();
    private boolean isInitialized;
    private String animationName;
    private int animationResId;
    private boolean wasAnimatingWhenNotShown = false;
    private boolean wasAnimatingWhenDetached = false;
    private boolean autoPlay = false;
    private boolean cacheComposition = true;
    private RenderMode renderMode = RenderMode.AUTOMATIC;
    private Set lottieOnCompositionLoadedListeners = new HashSet();
    private int buildDrawingCacheDepth = 0;
    private LottieTask compositionTask;
    private LottieComposition composition;

    public LottieAnimationView(Context context) {
        super(context);
        this.init(null);
    }

    public LottieAnimationView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet);
    }

    public LottieAnimationView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet);
    }

    private void init(AttributeSet attributeSet) {
        this.setImageAssetsFolder(null);
        this.setProgress(0.0f);
        this.enableMergePathsForKitKatAndAbove(false);
        if (this.getScaleType() != null) {
            this.lottieDrawable.setScaleType(this.getScaleType());
        }
        this.lottieDrawable.setSystemAnimationsAreEnabled(Utils.getAnimationScale(this.getContext()) != 0.0f);
        this.enableOrDisableHardwareLayer();
        this.isInitialized = true;
    }

    public void setImageResource(int n) {
        this.cancelLoaderTask();
        super.setImageResource(n);
    }

    public void setImageDrawable(Drawable drawable2) {
        this.cancelLoaderTask();
        super.setImageDrawable(drawable2);
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.cancelLoaderTask();
        super.setImageBitmap(bitmap);
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (this.getDrawable() == this.lottieDrawable) {
            super.invalidateDrawable((Drawable)this.lottieDrawable);
        } else {
            super.invalidateDrawable(drawable2);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        LottieAnimationView$SavedState lottieAnimationView$SavedState = new LottieAnimationView$SavedState(parcelable);
        lottieAnimationView$SavedState.animationName = this.animationName;
        lottieAnimationView$SavedState.animationResId = this.animationResId;
        lottieAnimationView$SavedState.progress = this.lottieDrawable.getProgress();
        lottieAnimationView$SavedState.isAnimating = this.lottieDrawable.isAnimating() || !LottieAnimationView.isAttachedToWindow((View)this) && this.wasAnimatingWhenDetached;
        lottieAnimationView$SavedState.imageAssetsFolder = this.lottieDrawable.getImageAssetsFolder();
        lottieAnimationView$SavedState.repeatMode = this.lottieDrawable.getRepeatMode();
        lottieAnimationView$SavedState.repeatCount = this.lottieDrawable.getRepeatCount();
        return lottieAnimationView$SavedState;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof LottieAnimationView$SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        LottieAnimationView$SavedState lottieAnimationView$SavedState = (LottieAnimationView$SavedState)parcelable;
        super.onRestoreInstanceState(lottieAnimationView$SavedState.getSuperState());
        this.animationName = lottieAnimationView$SavedState.animationName;
        if (!TextUtils.isEmpty((CharSequence)this.animationName)) {
            this.setAnimation(this.animationName);
        }
        this.animationResId = lottieAnimationView$SavedState.animationResId;
        if (this.animationResId != 0) {
            this.setAnimation(this.animationResId);
        }
        this.setProgress(lottieAnimationView$SavedState.progress);
        if (lottieAnimationView$SavedState.isAnimating) {
            this.playAnimation();
        }
        this.lottieDrawable.setImagesAssetsFolder(lottieAnimationView$SavedState.imageAssetsFolder);
        this.setRepeatMode(lottieAnimationView$SavedState.repeatMode);
        this.setRepeatCount(lottieAnimationView$SavedState.repeatCount);
    }

    protected void onVisibilityChanged(View view, int n) {
        if (!this.isInitialized) {
            return;
        }
        if (this.isShown()) {
            if (this.wasAnimatingWhenNotShown) {
                this.resumeAnimation();
                this.wasAnimatingWhenNotShown = false;
            }
        } else if (this.isAnimating()) {
            this.pauseAnimation();
            this.wasAnimatingWhenNotShown = true;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autoPlay || this.wasAnimatingWhenDetached) {
            this.playAnimation();
            this.autoPlay = false;
            this.wasAnimatingWhenDetached = false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            this.onVisibilityChanged((View)this, this.getVisibility());
        }
    }

    protected void onDetachedFromWindow() {
        if (this.isAnimating()) {
            this.cancelAnimation();
            this.wasAnimatingWhenDetached = true;
        }
        super.onDetachedFromWindow();
    }

    public void enableMergePathsForKitKatAndAbove(boolean bl) {
        this.lottieDrawable.enableMergePathsForKitKatAndAbove(bl);
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.lottieDrawable.isMergePathsEnabledForKitKatAndAbove();
    }

    public void setCacheComposition(boolean bl) {
        this.cacheComposition = bl;
    }

    public void setAnimation(int n) {
        this.animationResId = n;
        this.animationName = null;
        LottieTask lottieTask = this.cacheComposition ? LottieCompositionFactory.fromRawRes(this.getContext(), n) : LottieCompositionFactory.fromRawRes(this.getContext(), n, null);
        this.setCompositionTask(lottieTask);
    }

    public void setAnimation(String string) {
        this.animationName = string;
        this.animationResId = 0;
        LottieTask lottieTask = this.cacheComposition ? LottieCompositionFactory.fromAsset(this.getContext(), string) : LottieCompositionFactory.fromAsset(this.getContext(), string, null);
        this.setCompositionTask(lottieTask);
    }

    public void setAnimationFromJson(String string) {
        this.setAnimationFromJson(string, null);
    }

    public void setAnimationFromJson(String string, String string2) {
        this.setAnimation(new ByteArrayInputStream(string.getBytes()), string2);
    }

    public void setAnimation(InputStream inputStream, String string) {
        this.setCompositionTask(LottieCompositionFactory.fromJsonInputStream(inputStream, string));
    }

    public void setAnimationFromUrl(String string) {
        LottieTask lottieTask = this.cacheComposition ? LottieCompositionFactory.fromUrl(this.getContext(), string) : LottieCompositionFactory.fromUrl(this.getContext(), string, null);
        this.setCompositionTask(lottieTask);
    }

    public void setFailureListener(LottieListener lottieListener) {
        this.failureListener = lottieListener;
    }

    public void setFallbackResource(int n) {
        this.fallbackResource = n;
    }

    private void setCompositionTask(LottieTask lottieTask) {
        this.clearComposition();
        this.cancelLoaderTask();
        this.compositionTask = lottieTask.addListener(this.loadedListener).addFailureListener(this.wrappedFailureListener);
    }

    private void cancelLoaderTask() {
        if (this.compositionTask != null) {
            this.compositionTask.removeListener(this.loadedListener);
            this.compositionTask.removeFailureListener(this.wrappedFailureListener);
        }
    }

    public void setComposition(LottieComposition lottieComposition) {
        if (L.DBG) {
            Log.v((String)TAG, (String)("Set Composition \n" + lottieComposition));
        }
        this.lottieDrawable.setCallback((Drawable.Callback)this);
        this.composition = lottieComposition;
        boolean bl = this.lottieDrawable.setComposition(lottieComposition);
        this.enableOrDisableHardwareLayer();
        if (this.getDrawable() == this.lottieDrawable && !bl) {
            return;
        }
        this.setImageDrawable(null);
        this.setImageDrawable(this.lottieDrawable);
        this.onVisibilityChanged((View)this, this.getVisibility());
        this.requestLayout();
        for (LottieOnCompositionLoadedListener lottieOnCompositionLoadedListener : this.lottieOnCompositionLoadedListeners) {
            lottieOnCompositionLoadedListener.onCompositionLoaded(lottieComposition);
        }
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    public boolean hasMasks() {
        return this.lottieDrawable.hasMasks();
    }

    public boolean hasMatte() {
        return this.lottieDrawable.hasMatte();
    }

    public void playAnimation() {
        if (this.isShown()) {
            this.lottieDrawable.playAnimation();
            this.enableOrDisableHardwareLayer();
        } else {
            this.wasAnimatingWhenNotShown = true;
        }
    }

    public void resumeAnimation() {
        if (this.isShown()) {
            this.lottieDrawable.resumeAnimation();
            this.enableOrDisableHardwareLayer();
        } else {
            this.wasAnimatingWhenNotShown = true;
        }
    }

    public void setMinFrame(int n) {
        this.lottieDrawable.setMinFrame(n);
    }

    public float getMinFrame() {
        return this.lottieDrawable.getMinFrame();
    }

    public void setMinProgress(float f2) {
        this.lottieDrawable.setMinProgress(f2);
    }

    public void setMaxFrame(int n) {
        this.lottieDrawable.setMaxFrame(n);
    }

    public float getMaxFrame() {
        return this.lottieDrawable.getMaxFrame();
    }

    public void setMaxProgress(float f2) {
        this.lottieDrawable.setMaxProgress(f2);
    }

    public void setMinFrame(String string) {
        this.lottieDrawable.setMinFrame(string);
    }

    public void setMaxFrame(String string) {
        this.lottieDrawable.setMaxFrame(string);
    }

    public void setMinAndMaxFrame(String string) {
        this.lottieDrawable.setMinAndMaxFrame(string);
    }

    public void setMinAndMaxFrame(String string, String string2, boolean bl) {
        this.lottieDrawable.setMinAndMaxFrame(string, string2, bl);
    }

    public void setMinAndMaxFrame(int n, int n2) {
        this.lottieDrawable.setMinAndMaxFrame(n, n2);
    }

    public void setMinAndMaxProgress(float f2, float f3) {
        this.lottieDrawable.setMinAndMaxProgress(f2, f3);
    }

    public void reverseAnimationSpeed() {
        this.lottieDrawable.reverseAnimationSpeed();
    }

    public void setSpeed(float f2) {
        this.lottieDrawable.setSpeed(f2);
    }

    public float getSpeed() {
        return this.lottieDrawable.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        this.lottieDrawable.addAnimatorUpdateListener(animatorUpdateListener);
    }

    public void removeUpdateListener(ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        this.lottieDrawable.removeAnimatorUpdateListener(animatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        this.lottieDrawable.removeAllUpdateListeners();
    }

    public void addAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.lottieDrawable.addAnimatorListener(animatorListener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.lottieDrawable.removeAnimatorListener(animatorListener);
    }

    public void removeAllAnimatorListeners() {
        this.lottieDrawable.removeAllAnimatorListeners();
    }

    public void loop(boolean bl) {
        this.lottieDrawable.setRepeatCount(bl ? -1 : 0);
    }

    public void setRepeatMode(int n) {
        this.lottieDrawable.setRepeatMode(n);
    }

    public int getRepeatMode() {
        return this.lottieDrawable.getRepeatMode();
    }

    public void setRepeatCount(int n) {
        this.lottieDrawable.setRepeatCount(n);
    }

    public int getRepeatCount() {
        return this.lottieDrawable.getRepeatCount();
    }

    public boolean isAnimating() {
        return this.lottieDrawable.isAnimating();
    }

    public void setImageAssetsFolder(String string) {
        this.lottieDrawable.setImagesAssetsFolder(string);
    }

    public String getImageAssetsFolder() {
        return this.lottieDrawable.getImageAssetsFolder();
    }

    public Bitmap updateBitmap(String string, Bitmap bitmap) {
        return this.lottieDrawable.updateBitmap(string, bitmap);
    }

    public void setImageAssetDelegate(ImageAssetDelegate imageAssetDelegate) {
        this.lottieDrawable.setImageAssetDelegate(imageAssetDelegate);
    }

    public void setFontAssetDelegate(FontAssetDelegate fontAssetDelegate) {
        this.lottieDrawable.setFontAssetDelegate(fontAssetDelegate);
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.lottieDrawable.setTextDelegate(textDelegate);
    }

    public List resolveKeyPath(KeyPath keyPath) {
        return this.lottieDrawable.resolveKeyPath(keyPath);
    }

    public void addValueCallback(KeyPath keyPath, Object object, LottieValueCallback lottieValueCallback) {
        this.lottieDrawable.addValueCallback(keyPath, object, lottieValueCallback);
    }

    public void addValueCallback(KeyPath keyPath, Object object, SimpleLottieValueCallback simpleLottieValueCallback) {
        this.lottieDrawable.addValueCallback(keyPath, object, new LottieAnimationView$4(this, simpleLottieValueCallback));
    }

    public void setScale(float f2) {
        this.lottieDrawable.setScale(f2);
        if (this.getDrawable() == this.lottieDrawable) {
            this.setImageDrawable(null);
            this.setImageDrawable(this.lottieDrawable);
        }
    }

    public float getScale() {
        return this.lottieDrawable.getScale();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
        if (this.lottieDrawable != null) {
            this.lottieDrawable.setScaleType(scaleType);
        }
    }

    public void cancelAnimation() {
        this.wasAnimatingWhenNotShown = false;
        this.lottieDrawable.cancelAnimation();
        this.enableOrDisableHardwareLayer();
    }

    public void pauseAnimation() {
        this.autoPlay = false;
        this.wasAnimatingWhenDetached = false;
        this.wasAnimatingWhenNotShown = false;
        this.lottieDrawable.pauseAnimation();
        this.enableOrDisableHardwareLayer();
    }

    public void setFrame(int n) {
        this.lottieDrawable.setFrame(n);
    }

    public int getFrame() {
        return this.lottieDrawable.getFrame();
    }

    public void setProgress(float f2) {
        this.lottieDrawable.setProgress(f2);
    }

    public float getProgress() {
        return this.lottieDrawable.getProgress();
    }

    public long getDuration() {
        return this.composition != null ? (long)this.composition.getDuration() : 0L;
    }

    public void setPerformanceTrackingEnabled(boolean bl) {
        this.lottieDrawable.setPerformanceTrackingEnabled(bl);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.lottieDrawable.getPerformanceTracker();
    }

    private void clearComposition() {
        this.composition = null;
        this.lottieDrawable.clearComposition();
    }

    public void setSafeMode(boolean bl) {
        this.lottieDrawable.setSafeMode(bl);
    }

    public void buildDrawingCache(boolean bl) {
        L.beginSection("buildDrawingCache");
        ++this.buildDrawingCacheDepth;
        super.buildDrawingCache(bl);
        if (this.buildDrawingCacheDepth == 1 && this.getWidth() > 0 && this.getHeight() > 0 && this.getLayerType() == 1 && this.getDrawingCache(bl) == null) {
            this.setRenderMode(RenderMode.HARDWARE);
        }
        --this.buildDrawingCacheDepth;
        L.endSection("buildDrawingCache");
    }

    public void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
        this.enableOrDisableHardwareLayer();
    }

    public void setApplyingOpacityToLayersEnabled(boolean bl) {
        this.lottieDrawable.setApplyingOpacityToLayersEnabled(bl);
    }

    public void disableExtraScaleModeInFitXY() {
        this.lottieDrawable.disableExtraScaleModeInFitXY();
    }

    private void enableOrDisableHardwareLayer() {
        int n = 1;
        switch (this.renderMode) {
            case HARDWARE: {
                n = 2;
                break;
            }
            case SOFTWARE: {
                n = 1;
                break;
            }
            case AUTOMATIC: {
                boolean bl = true;
                if (this.composition != null && this.composition.hasDashPattern() && Build.VERSION.SDK_INT < 28) {
                    bl = false;
                } else if (this.composition != null && this.composition.getMaskAndMatteCount() > 4) {
                    bl = false;
                } else if (Build.VERSION.SDK_INT < 21) {
                    bl = false;
                }
                int n2 = n = bl ? 2 : 1;
            }
        }
        if (n != this.getLayerType()) {
            this.setLayerType(n, null);
        }
    }

    public boolean addLottieOnCompositionLoadedListener(LottieOnCompositionLoadedListener lottieOnCompositionLoadedListener) {
        LottieComposition lottieComposition = this.composition;
        if (lottieComposition != null) {
            lottieOnCompositionLoadedListener.onCompositionLoaded(lottieComposition);
        }
        return this.lottieOnCompositionLoadedListeners.add(lottieOnCompositionLoadedListener);
    }

    public boolean removeLottieOnCompositionLoadedListener(LottieOnCompositionLoadedListener lottieOnCompositionLoadedListener) {
        return this.lottieOnCompositionLoadedListeners.remove(lottieOnCompositionLoadedListener);
    }

    public void removeAllLottieOnCompositionLoadedListener() {
        this.lottieOnCompositionLoadedListeners.clear();
    }

    public static boolean isAttachedToWindow(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            return view.isAttachedToWindow();
        }
        return view.getWindowToken() != null;
    }

    static /* synthetic */ int access$0(LottieAnimationView lottieAnimationView) {
        return lottieAnimationView.fallbackResource;
    }

    static /* synthetic */ LottieListener access$1(LottieAnimationView lottieAnimationView) {
        return lottieAnimationView.failureListener;
    }

    static /* synthetic */ LottieListener access$2() {
        return DEFAULT_FAILURE_LISTENER;
    }
}

