/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.L;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.content.BaseStrokeContent$PathGroup;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.DrawingContent;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.content.TrimPathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.FloatKeyframeAnimation;
import oz.lottie.animation.keyframe.IntegerKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatableIntegerValue;
import oz.lottie.model.content.ShapeTrimPath$Type;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;

public abstract class BaseStrokeContent
implements DrawingContent,
KeyPathElementContent,
BaseKeyframeAnimation$AnimationListener {
    private final PathMeasure pm = new PathMeasure();
    private final Path path = new Path();
    private final Path trimPathPath = new Path();
    private final RectF rect = new RectF();
    private final LottieDrawable lottieDrawable;
    protected final BaseLayer layer;
    private final List pathGroups = new ArrayList();
    private final float[] dashPatternValues;
    final Paint paint = new LPaint(1);
    private final BaseKeyframeAnimation widthAnimation;
    private final BaseKeyframeAnimation opacityAnimation;
    private final List dashPatternAnimations;
    private final BaseKeyframeAnimation dashPatternOffsetAnimation;
    private BaseKeyframeAnimation colorFilterAnimation;

    BaseStrokeContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, Paint.Cap cap, Paint.Join join, float f2, AnimatableIntegerValue animatableIntegerValue, AnimatableFloatValue animatableFloatValue, List list, AnimatableFloatValue animatableFloatValue2) {
        this.lottieDrawable = lottieDrawable;
        this.layer = baseLayer;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(cap);
        this.paint.setStrokeJoin(join);
        this.paint.setStrokeMiter(f2);
        this.opacityAnimation = animatableIntegerValue.createAnimation();
        this.widthAnimation = animatableFloatValue.createAnimation();
        this.dashPatternOffsetAnimation = animatableFloatValue2 == null ? null : animatableFloatValue2.createAnimation();
        this.dashPatternAnimations = new ArrayList(list.size());
        this.dashPatternValues = new float[list.size()];
        int n = 0;
        while (n < list.size()) {
            this.dashPatternAnimations.add(((AnimatableFloatValue)list.get(n)).createAnimation());
            ++n;
        }
        baseLayer.addAnimation(this.opacityAnimation);
        baseLayer.addAnimation(this.widthAnimation);
        n = 0;
        while (n < this.dashPatternAnimations.size()) {
            baseLayer.addAnimation((BaseKeyframeAnimation)this.dashPatternAnimations.get(n));
            ++n;
        }
        if (this.dashPatternOffsetAnimation != null) {
            baseLayer.addAnimation(this.dashPatternOffsetAnimation);
        }
        this.opacityAnimation.addUpdateListener(this);
        this.widthAnimation.addUpdateListener(this);
        n = 0;
        while (n < list.size()) {
            ((BaseKeyframeAnimation)this.dashPatternAnimations.get(n)).addUpdateListener(this);
            ++n;
        }
        if (this.dashPatternOffsetAnimation != null) {
            this.dashPatternOffsetAnimation.addUpdateListener(this);
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        TrimPathContent trimPathContent = null;
        int n = list.size() - 1;
        while (n >= 0) {
            Content content = (Content)list.get(n);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath$Type.INDIVIDUALLY) {
                trimPathContent = (TrimPathContent)content;
            }
            --n;
        }
        if (trimPathContent != null) {
            trimPathContent.addListener(this);
        }
        BaseStrokeContent$PathGroup baseStrokeContent$PathGroup = null;
        int n2 = list2.size() - 1;
        while (n2 >= 0) {
            Content content = (Content)list2.get(n2);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath$Type.INDIVIDUALLY) {
                if (baseStrokeContent$PathGroup != null) {
                    this.pathGroups.add(baseStrokeContent$PathGroup);
                }
                baseStrokeContent$PathGroup = new BaseStrokeContent$PathGroup((TrimPathContent)content, null);
                ((TrimPathContent)content).addListener(this);
            } else if (content instanceof PathContent) {
                if (baseStrokeContent$PathGroup == null) {
                    baseStrokeContent$PathGroup = new BaseStrokeContent$PathGroup(trimPathContent, null);
                }
                BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).add((PathContent)content);
            }
            --n2;
        }
        if (baseStrokeContent$PathGroup != null) {
            this.pathGroups.add(baseStrokeContent$PathGroup);
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        L.beginSection("StrokeContent#draw");
        if (Utils.hasZeroScaleAxis(matrix)) {
            L.endSection("StrokeContent#draw");
            return;
        }
        int n2 = (int)((float)n / 255.0f * (float)((IntegerKeyframeAnimation)this.opacityAnimation).getIntValue() / 100.0f * 255.0f);
        this.paint.setAlpha(MiscUtils.clamp(n2, 0, 255));
        this.paint.setStrokeWidth(((FloatKeyframeAnimation)this.widthAnimation).getFloatValue() * Utils.getScale(matrix));
        if (this.paint.getStrokeWidth() <= 0.0f) {
            L.endSection("StrokeContent#draw");
            return;
        }
        this.applyDashPatternIfNeeded(matrix);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter((ColorFilter)this.colorFilterAnimation.getValue());
        }
        int n3 = 0;
        while (n3 < this.pathGroups.size()) {
            BaseStrokeContent$PathGroup baseStrokeContent$PathGroup = (BaseStrokeContent$PathGroup)this.pathGroups.get(n3);
            if (BaseStrokeContent$PathGroup.access$2(baseStrokeContent$PathGroup) != null) {
                this.applyTrimPath(canvas, baseStrokeContent$PathGroup, matrix);
            } else {
                L.beginSection("StrokeContent#buildPath");
                this.path.reset();
                int n4 = BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).size() - 1;
                while (n4 >= 0) {
                    this.path.addPath(((PathContent)BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).get(n4)).getPath(), matrix);
                    --n4;
                }
                L.endSection("StrokeContent#buildPath");
                L.beginSection("StrokeContent#drawPath");
                canvas.drawPath(this.path, this.paint);
                L.endSection("StrokeContent#drawPath");
            }
            ++n3;
        }
        L.endSection("StrokeContent#draw");
    }

    private void applyTrimPath(Canvas canvas, BaseStrokeContent$PathGroup baseStrokeContent$PathGroup, Matrix matrix) {
        L.beginSection("StrokeContent#applyTrimPath");
        if (BaseStrokeContent$PathGroup.access$2(baseStrokeContent$PathGroup) == null) {
            L.endSection("StrokeContent#applyTrimPath");
            return;
        }
        this.path.reset();
        int n = BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).size() - 1;
        while (n >= 0) {
            this.path.addPath(((PathContent)BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).get(n)).getPath(), matrix);
            --n;
        }
        this.pm.setPath(this.path, false);
        float f2 = this.pm.getLength();
        while (this.pm.nextContour()) {
            f2 += this.pm.getLength();
        }
        float f3 = f2 * ((Float)BaseStrokeContent$PathGroup.access$2(baseStrokeContent$PathGroup).getOffset().getValue()).floatValue() / 360.0f;
        float f4 = f2 * ((Float)BaseStrokeContent$PathGroup.access$2(baseStrokeContent$PathGroup).getStart().getValue()).floatValue() / 100.0f + f3;
        float f5 = f2 * ((Float)BaseStrokeContent$PathGroup.access$2(baseStrokeContent$PathGroup).getEnd().getValue()).floatValue() / 100.0f + f3;
        float f6 = 0.0f;
        int n2 = BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).size() - 1;
        while (n2 >= 0) {
            float f7;
            float f8;
            this.trimPathPath.set(((PathContent)BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).get(n2)).getPath());
            this.trimPathPath.transform(matrix);
            this.pm.setPath(this.trimPathPath, false);
            float f9 = this.pm.getLength();
            if (f5 > f2 && f5 - f2 < f6 + f9 && f6 < f5 - f2) {
                f8 = f4 > f2 ? (f4 - f2) / f9 : 0.0f;
                f7 = Math.min((f5 - f2) / f9, 1.0f);
                Utils.applyTrimPathIfNeeded(this.trimPathPath, f8, f7, 0.0f);
                canvas.drawPath(this.trimPathPath, this.paint);
            } else if (!(f6 + f9 < f4) && !(f6 > f5)) {
                if (f6 + f9 <= f5 && f4 < f6) {
                    canvas.drawPath(this.trimPathPath, this.paint);
                } else {
                    f8 = f4 < f6 ? 0.0f : (f4 - f6) / f9;
                    f7 = f5 > f6 + f9 ? 1.0f : (f5 - f6) / f9;
                    Utils.applyTrimPathIfNeeded(this.trimPathPath, f8, f7, 0.0f);
                    canvas.drawPath(this.trimPathPath, this.paint);
                }
            }
            f6 += f9;
            --n2;
        }
        L.endSection("StrokeContent#applyTrimPath");
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        L.beginSection("StrokeContent#getBounds");
        this.path.reset();
        int n = 0;
        while (n < this.pathGroups.size()) {
            BaseStrokeContent$PathGroup baseStrokeContent$PathGroup = (BaseStrokeContent$PathGroup)this.pathGroups.get(n);
            int n2 = 0;
            while (n2 < BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).size()) {
                this.path.addPath(((PathContent)BaseStrokeContent$PathGroup.access$1(baseStrokeContent$PathGroup).get(n2)).getPath(), matrix);
                ++n2;
            }
            ++n;
        }
        this.path.computeBounds(this.rect, false);
        float f2 = ((FloatKeyframeAnimation)this.widthAnimation).getFloatValue();
        this.rect.set(this.rect.left - f2 / 2.0f, this.rect.top - f2 / 2.0f, this.rect.right + f2 / 2.0f, this.rect.bottom + f2 / 2.0f);
        rectF.set(this.rect);
        rectF.set(rectF.left - 1.0f, rectF.top - 1.0f, rectF.right + 1.0f, rectF.bottom + 1.0f);
        L.endSection("StrokeContent#getBounds");
    }

    private void applyDashPatternIfNeeded(Matrix matrix) {
        L.beginSection("StrokeContent#applyDashPattern");
        if (this.dashPatternAnimations.isEmpty()) {
            L.endSection("StrokeContent#applyDashPattern");
            return;
        }
        float f2 = Utils.getScale(matrix);
        int n = 0;
        while (n < this.dashPatternAnimations.size()) {
            this.dashPatternValues[n] = ((Float)((BaseKeyframeAnimation)this.dashPatternAnimations.get(n)).getValue()).floatValue();
            if (n % 2 == 0) {
                if (this.dashPatternValues[n] < 1.0f) {
                    this.dashPatternValues[n] = 1.0f;
                }
            } else if (this.dashPatternValues[n] < 0.1f) {
                this.dashPatternValues[n] = 0.1f;
            }
            int n2 = n++;
            this.dashPatternValues[n2] = this.dashPatternValues[n2] * f2;
        }
        float f3 = this.dashPatternOffsetAnimation == null ? 0.0f : ((Float)this.dashPatternOffsetAnimation.getValue()).floatValue() * f2;
        this.paint.setPathEffect((PathEffect)new DashPathEffect(this.dashPatternValues, f3));
        L.endSection("StrokeContent#applyDashPattern");
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.OPACITY) {
            this.opacityAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.STROKE_WIDTH) {
            this.widthAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.COLOR_FILTER) {
            if (lottieValueCallback == null) {
                this.colorFilterAnimation = null;
            } else {
                this.colorFilterAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.colorFilterAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorFilterAnimation);
            }
        }
    }
}

