/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.content;

import oz.lottie.utils.GammaEvaluator;
import oz.lottie.utils.MiscUtils;

public class GradientColor {
    private final float[] positions;
    private final int[] colors;

    public GradientColor(float[] fArray, int[] nArray) {
        this.positions = fArray;
        this.colors = nArray;
    }

    public float[] getPositions() {
        return this.positions;
    }

    public int[] getColors() {
        return this.colors;
    }

    public int getSize() {
        return this.colors.length;
    }

    public void lerp(GradientColor gradientColor, GradientColor gradientColor2, float f2) {
        if (gradientColor.colors.length != gradientColor2.colors.length) {
            throw new IllegalArgumentException("Cannot interpolate between gradients. Lengths vary (" + gradientColor.colors.length + " vs " + gradientColor2.colors.length + ")");
        }
        int n = 0;
        while (n < gradientColor.colors.length) {
            this.positions[n] = MiscUtils.lerp(gradientColor.positions[n], gradientColor2.positions[n], f2);
            this.colors[n] = GammaEvaluator.evaluate(f2, gradientColor.colors[n], gradientColor2.colors[n]);
            ++n;
        }
    }
}

