/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import java.util.ArrayList;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatablePathValue;
import oz.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import oz.lottie.model.animatable.AnimatableValue;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.JsonUtils;
import oz.lottie.parser.KeyframesParser;
import oz.lottie.parser.PathKeyframeParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.parser.moshi.JsonReader$Token;
import oz.lottie.utils.Utils;
import oz.lottie.value.Keyframe;

public class AnimatablePathValueParser {
    private static JsonReader$Options NAMES = JsonReader$Options.of("k", "x", "y");

    private AnimatablePathValueParser() {
    }

    public static AnimatablePathValue parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        ArrayList<Keyframe> arrayList = new ArrayList<Keyframe>();
        if (jsonReader.peek() == JsonReader$Token.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                arrayList.add(PathKeyframeParser.parse(jsonReader, lottieComposition));
            }
            jsonReader.endArray();
            KeyframesParser.setEndFrames(arrayList);
        } else {
            arrayList.add(new Keyframe(JsonUtils.jsonToPoint(jsonReader, Utils.dpScale())));
        }
        return new AnimatablePathValue(arrayList);
    }

    static AnimatableValue parseSplitPath(JsonReader jsonReader, LottieComposition lottieComposition) {
        AnimatablePathValue animatablePathValue = null;
        AnimatableFloatValue animatableFloatValue = null;
        AnimatableFloatValue animatableFloatValue2 = null;
        boolean bl = false;
        jsonReader.beginObject();
        while (jsonReader.peek() != JsonReader$Token.END_OBJECT) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    animatablePathValue = AnimatablePathValueParser.parse(jsonReader, lottieComposition);
                    break;
                }
                case 1: {
                    if (jsonReader.peek() == JsonReader$Token.STRING) {
                        bl = true;
                        jsonReader.skipValue();
                        break;
                    }
                    animatableFloatValue = AnimatableValueParser.parseFloat(jsonReader, lottieComposition);
                    break;
                }
                case 2: {
                    if (jsonReader.peek() == JsonReader$Token.STRING) {
                        bl = true;
                        jsonReader.skipValue();
                        break;
                    }
                    animatableFloatValue2 = AnimatableValueParser.parseFloat(jsonReader, lottieComposition);
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        jsonReader.endObject();
        if (bl) {
            lottieComposition.addWarning("Lottie doesn't support expressions.");
        }
        if (animatablePathValue != null) {
            return animatablePathValue;
        }
        return new AnimatableSplitDimensionPathValue(animatableFloatValue, animatableFloatValue2);
    }
}

