/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import oz.util.barcode.client.result.ParsedResult;
import oz.util.barcode.client.result.ParsedResultType;

public final class SMSParsedResult
extends ParsedResult {
    private final String[] numbers;
    private final String[] vias;
    private final String subject;
    private final String body;

    public SMSParsedResult(String string, String string2, String string3, String string4) {
        super(ParsedResultType.SMS);
        this.numbers = new String[]{string};
        this.vias = new String[]{string2};
        this.subject = string3;
        this.body = string4;
    }

    public SMSParsedResult(String[] stringArray, String[] stringArray2, String string, String string2) {
        super(ParsedResultType.SMS);
        this.numbers = stringArray;
        this.vias = stringArray2;
        this.subject = string;
        this.body = string2;
    }

    public String getSMSURI() {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sms:");
        boolean bl2 = true;
        int n = 0;
        while (n < this.numbers.length) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.numbers[n]);
            if (this.vias != null && this.vias[n] != null) {
                stringBuilder.append(";via=");
                stringBuilder.append(this.vias[n]);
            }
            ++n;
        }
        n = this.body != null ? 1 : 0;
        boolean bl3 = bl = this.subject != null;
        if (n != 0 || bl) {
            stringBuilder.append('?');
            if (n != 0) {
                stringBuilder.append("body=");
                stringBuilder.append(this.body);
            }
            if (bl) {
                if (n != 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("subject=");
                stringBuilder.append(this.subject);
            }
        }
        return stringBuilder.toString();
    }

    public String[] getNumbers() {
        return this.numbers;
    }

    public String[] getVias() {
        return this.vias;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(100);
        SMSParsedResult.maybeAppend(this.numbers, stringBuilder);
        SMSParsedResult.maybeAppend(this.subject, stringBuilder);
        SMSParsedResult.maybeAppend(this.body, stringBuilder);
        return stringBuilder.toString();
    }
}

