/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.util.List;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.CalendarParsedResult;
import oz.util.barcode.client.result.ResultParser;
import oz.util.barcode.client.result.VCardResultParser;

public final class VEventResultParser
extends ResultParser {
    @Override
    public CalendarParsedResult parse(Result result) {
        double d2;
        double d3;
        String string = VEventResultParser.getMassagedText(result);
        int n = string.indexOf("BEGIN:VEVENT");
        if (n < 0) {
            return null;
        }
        String string2 = VEventResultParser.matchSingleVCardPrefixedField("SUMMARY", string, true);
        String string3 = VEventResultParser.matchSingleVCardPrefixedField("DTSTART", string, true);
        if (string3 == null) {
            return null;
        }
        String string4 = VEventResultParser.matchSingleVCardPrefixedField("DTEND", string, true);
        String string5 = VEventResultParser.matchSingleVCardPrefixedField("DURATION", string, true);
        String string6 = VEventResultParser.matchSingleVCardPrefixedField("LOCATION", string, true);
        String string7 = VEventResultParser.stripMailto(VEventResultParser.matchSingleVCardPrefixedField("ORGANIZER", string, true));
        String[] stringArray = VEventResultParser.matchVCardPrefixedField("ATTENDEE", string, true);
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = VEventResultParser.stripMailto(stringArray[n2]);
                ++n2;
            }
        }
        String string8 = VEventResultParser.matchSingleVCardPrefixedField("DESCRIPTION", string, true);
        String string9 = VEventResultParser.matchSingleVCardPrefixedField("GEO", string, true);
        if (string9 == null) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        } else {
            int n3 = string9.indexOf(59);
            try {
                d3 = Double.parseDouble(string9.substring(0, n3));
                d2 = Double.parseDouble(string9.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            return new CalendarParsedResult(string2, string3, string4, string5, string6, string7, stringArray, string8, d3, d2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static String matchSingleVCardPrefixedField(CharSequence charSequence, String string, boolean bl) {
        List list = VCardResultParser.matchSingleVCardPrefixedField(charSequence, string, bl, false);
        return list == null || list.isEmpty() ? null : (String)list.get(0);
    }

    private static String[] matchVCardPrefixedField(CharSequence charSequence, String string, boolean bl) {
        List list = VCardResultParser.matchVCardPrefixedField(charSequence, string, bl, false);
        if (list == null || list.isEmpty()) {
            return null;
        }
        int n = list.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)((List)list.get(n2)).get(0);
            ++n2;
        }
        return stringArray;
    }

    private static String stripMailto(String string) {
        if (string != null && (string.startsWith("mailto:") || string.startsWith("MAILTO:"))) {
            string = string.substring(7);
        }
        return string;
    }
}

