/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Arrays;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.EANManufacturerOrgSupport;
import oz.util.barcode.oned.OneDReader;
import oz.util.barcode.oned.UPCEANExtensionSupport;

public abstract class UPCEANReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 122;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    static final int[] START_END_PATTERN = new int[]{1, 1, 1};
    static final int[] MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
    static final int[][] L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    static final int[][] L_AND_G_PATTERNS = new int[20][];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder(20);
    private final UPCEANExtensionSupport extensionReader = new UPCEANExtensionSupport();
    private final EANManufacturerOrgSupport eanManSupport = new EANManufacturerOrgSupport();

    static {
        System.arraycopy(L_PATTERNS, 0, L_AND_G_PATTERNS, 0, 10);
        int n = 10;
        while (n < 20) {
            int[] nArray = L_PATTERNS[n - 10];
            int[] nArray2 = new int[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray2[n2] = nArray[nArray.length - n2 - 1];
                ++n2;
            }
            UPCEANReader.L_AND_G_PATTERNS[n] = nArray2;
            ++n;
        }
    }

    protected UPCEANReader() {
    }

    static int[] findStartGuardPattern(BitArray bitArray) {
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        int[] nArray2 = new int[START_END_PATTERN.length];
        while (!bl) {
            Arrays.fill(nArray2, 0, START_END_PATTERN.length, 0);
            nArray = UPCEANReader.findGuardPattern(bitArray, n, false, START_END_PATTERN, nArray2);
            int n2 = nArray[0];
            n = nArray[1];
            int n3 = n2 - (n - n2);
            if (n3 < 0) continue;
            bl = bitArray.isRange(n3, n2, false);
        }
        return nArray;
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        return this.decodeRow(n, bitArray, UPCEANReader.findStartGuardPattern(bitArray), map);
    }

    public Result decodeRow(int n, BitArray bitArray, int[] nArray, Map map) {
        Object object;
        int n2;
        int n3;
        ResultPointCallback resultPointCallback;
        ResultPointCallback resultPointCallback2 = resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n));
        }
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n4 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(n4, n));
        }
        int[] nArray2 = this.decodeEnd(bitArray, n4);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray2[0] + nArray2[1]) / 2.0f, n));
        }
        if ((n3 = (n2 = nArray2[1]) + (n2 - nArray2[0])) >= bitArray.getSize() || !bitArray.isRange(n2, n3, false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string = stringBuilder.toString();
        if (string.length() < 8) {
            throw FormatException.getFormatInstance();
        }
        if (!this.checkChecksum(string)) {
            throw ChecksumException.getChecksumInstance();
        }
        float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f3 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        BarcodeFormat barcodeFormat = this.getBarcodeFormat();
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint(f2, n), new ResultPoint(f3, n)}, barcodeFormat);
        try {
            object = this.extensionReader.decodeRow(n, bitArray, nArray2[1]);
            result.putMetadata(ResultMetadataType.UPC_EAN_EXTENSION, ((Result)object).getText());
            result.putAllMetadata(((Result)object).getResultMetadata());
            result.addResultPoints(((Result)object).getResultPoints());
        }
        catch (ReaderException readerException) {
            // empty catch block
        }
        if ((barcodeFormat == BarcodeFormat.EAN_13 || barcodeFormat == BarcodeFormat.UPC_A) && (object = this.eanManSupport.lookupCountryIdentifier(string)) != null) {
            result.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, object);
        }
        return result;
    }

    boolean checkChecksum(String string) {
        return UPCEANReader.checkStandardUPCEANChecksum(string);
    }

    static boolean checkStandardUPCEANChecksum(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        int n4 = n2 - 2;
        while (n4 >= 0) {
            n = charSequence.charAt(n4) - 48;
            if (n < 0 || n > 9) {
                throw FormatException.getFormatInstance();
            }
            n3 += n;
            n4 -= 2;
        }
        n3 *= 3;
        n4 = n2 - 1;
        while (n4 >= 0) {
            n = charSequence.charAt(n4) - 48;
            if (n < 0 || n > 9) {
                throw FormatException.getFormatInstance();
            }
            n3 += n;
            n4 -= 2;
        }
        return n3 % 10 == 0;
    }

    int[] decodeEnd(BitArray bitArray, int n) {
        return UPCEANReader.findGuardPattern(bitArray, n, false, START_END_PATTERN);
    }

    static int[] findGuardPattern(BitArray bitArray, int n, boolean bl, int[] nArray) {
        return UPCEANReader.findGuardPattern(bitArray, n, bl, nArray, new int[nArray.length]);
    }

    private static int[] findGuardPattern(BitArray bitArray, int n, boolean bl, int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = bitArray.getSize();
        boolean bl2 = bl;
        n = bl ? bitArray.getNextUnset(n) : bitArray.getNextSet(n);
        int n4 = 0;
        int n5 = n;
        int n6 = n;
        while (n6 < n3) {
            if (bitArray.get(n6) ^ bl2) {
                int n7 = n4;
                nArray2[n7] = nArray2[n7] + 1;
            } else {
                if (n4 == n2 - 1) {
                    if (UPCEANReader.patternMatchVariance(nArray2, nArray, 179) < 122) {
                        return new int[]{n5, n6};
                    }
                    n5 += nArray2[0] + nArray2[1];
                    System.arraycopy(nArray2, 2, nArray2, 0, n2 - 2);
                    nArray2[n2 - 2] = 0;
                    nArray2[n2 - 1] = 0;
                    --n4;
                } else {
                    ++n4;
                }
                nArray2[n4] = 1;
                bl2 = !bl2;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n, int[][] nArray2) {
        UPCEANReader.recordPattern(bitArray, n, nArray);
        int n2 = 122;
        int n3 = -1;
        int n4 = nArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            int[] nArray3 = nArray2[n5];
            int n6 = UPCEANReader.patternMatchVariance(nArray, nArray3, 179);
            if (n6 < n2) {
                n2 = n6;
                n3 = n5;
            }
            ++n5;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3);
}

