/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;

public class Camera2PreviewView
extends TextureView {
    private int mRatioWidth = 0;
    private int mRatioHeight = 0;

    public Camera2PreviewView(Context context) {
        this(context, null);
    }

    public Camera2PreviewView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public Camera2PreviewView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public void setAspectRatio(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        if (this.mRatioWidth == n && this.mRatioHeight == n2) {
            return;
        }
        this.mRatioWidth = n;
        this.mRatioHeight = n2;
        this.requestLayout();
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        if (0 == this.mRatioWidth || 0 == this.mRatioHeight) {
            this.setMeasuredDimension(n3, n4);
        } else if (n3 < n4 * this.mRatioWidth / this.mRatioHeight) {
            this.setMeasuredDimension(n3, n3 * this.mRatioHeight / this.mRatioWidth);
        } else {
            this.setMeasuredDimension(n4 * this.mRatioWidth / this.mRatioHeight, n4);
        }
    }
}

