/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.util.SparseArray;
import android.view.View;
import oz.lottie.LottieAnimationView;
import oz.lottie.LottieComposition;
import oz.lottie.LottieListener;
import oz.lottie.LottieOnCompositionLoadedListener;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFLottieAnimationView$ScenceLoop;
import oz.viewer.ui.df.view.DFLottieAnimationView$Scene;

public class DFLottieAnimationView
extends LottieAnimationView
implements Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener,
LottieListener,
LottieOnCompositionLoadedListener {
    private boolean mIsLoaded;
    private Point mTargetFrame = new Point();
    private int mLoopCount;
    private SparseArray mScences = new SparseArray();
    private DFLottieAnimationView$Scene mSelectedScene;
    private boolean mAutoPlay = true;
    private boolean mNeedResume;

    public DFLottieAnimationView(Context context) {
        super(context);
        this.clearScene();
        this.setFailureListener(this);
        this.addLottieOnCompositionLoadedListener(this);
        this.addAnimatorListener(this);
        this.addAnimatorUpdateListener(this);
    }

    protected void setAutoPlay(boolean bl) {
        this.mAutoPlay = bl;
    }

    public void clearScene() {
        this.mTargetFrame.set(-1, -1);
        this.mLoopCount = -1;
        this.mScences.clear();
        this.mSelectedScene = null;
        if (this.isAnimating()) {
            this.pauseAnimation();
        }
    }

    public void loadLottie(String string) {
        this.clearScene();
        this.loadLottie(string, null);
    }

    public void loadLottie(String string, String string2) {
        this.mIsLoaded = false;
        this.clearScene();
        this.setImageAssetsFolder(string2);
        this.setAnimation(string);
    }

    private void setTargetFrame(int n, int n2) {
        if (n2 < n) {
            n2 = n;
        }
        this.mTargetFrame.set(n, n2);
        if (this.mIsLoaded) {
            this.applyTargetFrame();
        }
    }

    public void addScene(DFLottieAnimationView$Scene dFLottieAnimationView$Scene) {
        if (dFLottieAnimationView$Scene != null) {
            this.mScences.append(DFLottieAnimationView$Scene.access$000(dFLottieAnimationView$Scene), (Object)dFLottieAnimationView$Scene);
        }
    }

    public void addScene(DFLottieAnimationView$Scene[] dFLottieAnimationView$SceneArray) {
        if (dFLottieAnimationView$SceneArray != null) {
            for (int j = 0; j < dFLottieAnimationView$SceneArray.length; ++j) {
                this.addScene(dFLottieAnimationView$SceneArray[j]);
            }
        }
    }

    public DFLottieAnimationView$Scene getTargetScene() {
        return this.mSelectedScene;
    }

    public void setTargetScene(int n) {
        this.setTargetScene((DFLottieAnimationView$Scene)this.mScences.get(n));
    }

    public void setTargetScene(int n, int n2) {
        DFLottieAnimationView$Scene dFLottieAnimationView$Scene = new DFLottieAnimationView$Scene();
        DFLottieAnimationView$Scene.access$102(dFLottieAnimationView$Scene, n);
        DFLottieAnimationView$Scene.access$202(dFLottieAnimationView$Scene, n2);
        this.setTargetScene(dFLottieAnimationView$Scene);
    }

    public void setTargetScene(DFLottieAnimationView$Scene dFLottieAnimationView$Scene) {
        if (dFLottieAnimationView$Scene != null) {
            this.mSelectedScene = dFLottieAnimationView$Scene;
            this.setRepeatCount(DFLottieAnimationView$ScenceLoop.access$400(DFLottieAnimationView$Scene.access$300(this.mSelectedScene)));
            this.setTargetFrame(DFLottieAnimationView$Scene.access$100(this.mSelectedScene), DFLottieAnimationView$Scene.access$200(this.mSelectedScene));
        }
    }

    public void setRepeatCount(int n) {
        this.mLoopCount = n;
        if (this.mIsLoaded) {
            this.applyRepeatCount();
        }
    }

    private void applyRepeatCount() {
        super.setRepeatCount(this.mLoopCount);
    }

    private void applyTargetFrame() {
        if (this.mTargetFrame.x > -1 && this.mTargetFrame.y > -1) {
            this.setMinAndMaxFrame(this.mTargetFrame.x, this.mTargetFrame.y);
        }
    }

    public void onCompositionLoaded(LottieComposition lottieComposition) {
        if (!this.mIsLoaded) {
            this.mIsLoaded = true;
            this.applyRepeatCount();
            this.applyTargetFrame();
        }
    }

    private void autoPlay() {
        if (this.mAutoPlay && !this.isAnimating() && this.isShown()) {
            if (this.mNeedResume) {
                this.mNeedResume = false;
                this.resumeAnimation();
            } else {
                this.playAnimation();
            }
        }
    }

    private void autoPause() {
        if (this.mAutoPlay && this.isAnimating()) {
            this.pauseAnimation();
            this.mNeedResume = true;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.autoPlay();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.autoPause();
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (n == 0) {
            this.autoPlay();
        } else {
            this.autoPause();
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.autoPlay();
        } else {
            this.autoPause();
        }
    }

    public void playAnimation() {
        super.playAnimation();
    }

    public void pauseAnimation() {
        super.pauseAnimation();
    }

    public void resumeAnimation() {
        super.resumeAnimation();
    }

    public void onAnimationStart(Animator animator) {
    }

    public void onAnimationEnd(Animator animator) {
        if (this.mSelectedScene != null && this.mSelectedScene.getLoop().hasNext()) {
            this.setTargetScene(this.mSelectedScene.getLoop().getNext());
            this.playAnimation();
        }
    }

    public void onAnimationCancel(Animator animator) {
    }

    public void onAnimationRepeat(Animator animator) {
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
    }

    public void onResult(Throwable throwable) {
        DFUtils.d("onResult Throwable");
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

