/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.SocketChannelIOHelper;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketListener;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.handshake.HandshakeImpl1Client;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSocketClient
extends WebSocketAdapter
implements Runnable {
    private URI uri = null;
    private WebSocketImpl conn = null;
    private SocketChannel channel = null;
    private ByteChannel wrappedchannel = null;
    private SelectionKey key = null;
    private Selector selector = null;
    private Thread thread;
    private Draft draft;
    private Map<String, String> headers;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CountDownLatch closeLatch = new CountDownLatch(1);
    WebSocketClientFactory wf = new WebSocketClientFactory(){

        @Override
        public WebSocket createWebSocket(WebSocketAdapter a, Draft d, Socket s) {
            return new WebSocketImpl((WebSocketListener)WebSocketClient.this, d, s);
        }

        @Override
        public WebSocket createWebSocket(WebSocketAdapter a, List<Draft> d, Socket s) {
            return new WebSocketImpl((WebSocketListener)WebSocketClient.this, d, s);
        }

        @Override
        public ByteChannel wrapChannel(SelectionKey c, String host, int port) {
            return (ByteChannel)((Object)c.channel());
        }
    };

    public WebSocketClient(URI serverURI) {
        this(serverURI, new Draft_10());
    }

    public WebSocketClient(URI serverUri, Draft draft) {
        this(serverUri, draft, null);
    }

    public WebSocketClient(URI serverUri, Draft draft, Map<String, String> headers) {
        if (serverUri == null) {
            throw new IllegalArgumentException();
        }
        if (draft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = serverUri;
        this.draft = draft;
        this.headers = headers;
    }

    public URI getURI() {
        return this.uri;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public void connect() {
        if (this.thread != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public boolean connectBlocking() throws InterruptedException {
        this.connect();
        this.connectLatch.await();
        return this.conn.isOpen();
    }

    public void close() {
        if (this.thread != null && this.conn != null) {
            this.conn.close(1000);
        }
    }

    public void closeBlocking() throws InterruptedException {
        this.close();
        this.closeLatch.await();
    }

    public void send(String text) throws NotYetConnectedException {
        if (this.conn != null) {
            this.conn.send(text);
        }
    }

    public void send(byte[] data) throws NotYetConnectedException {
        if (this.conn != null) {
            this.conn.send(data);
        }
    }

    private void tryToConnect(InetSocketAddress remote) throws IOException {
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.channel.connect(remote);
        this.selector = Selector.open();
        this.key = this.channel.register(this.selector, 8);
    }

    @Override
    public void run() {
        if (this.thread == null) {
            this.thread = Thread.currentThread();
        }
        this.interruptableRun();
        assert (!this.channel.isOpen());
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    private final void interruptableRun() {
        try {
            this.tryToConnect(new InetSocketAddress(this.uri.getHost(), this.getPort()));
        }
        catch (ClosedByInterruptException e) {
            this.onWebsocketError(null, e);
            return;
        }
        catch (IOException e) {
            this.onWebsocketError(this.conn, e);
            return;
        }
        catch (SecurityException e) {
            this.onWebsocketError(this.conn, e);
            return;
        }
        catch (UnresolvedAddressException e) {
            this.onWebsocketError(this.conn, e);
            return;
        }
        this.conn = (WebSocketImpl)this.wf.createWebSocket((WebSocketAdapter)this, this.draft, this.channel.socket());
        ByteBuffer buff = ByteBuffer.allocate(WebSocket.RCVBUF);
        try {
            while (this.channel.isOpen()) {
                WrappedByteChannel w;
                SelectionKey key = null;
                this.selector.select();
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    key = i.next();
                    i.remove();
                    if (!key.isValid()) {
                        this.conn.eot();
                        continue;
                    }
                    if (key.isReadable() && SocketChannelIOHelper.read(buff, this.conn, this.wrappedchannel)) {
                        this.conn.decode(buff);
                    }
                    if (key.isConnectable()) {
                        try {
                            this.finishConnect(key);
                        }
                        catch (InvalidHandshakeException e) {
                            this.conn.close(e);
                        }
                    }
                    if (!key.isWritable()) continue;
                    if (SocketChannelIOHelper.batch(this.conn, this.wrappedchannel)) {
                        if (!key.isValid()) continue;
                        key.interestOps(1);
                        continue;
                    }
                    key.interestOps(5);
                }
                if (!(this.wrappedchannel instanceof WrappedByteChannel) || !(w = (WrappedByteChannel)this.wrappedchannel).isNeedRead()) continue;
                while (SocketChannelIOHelper.read(buff, this.conn, w)) {
                    this.conn.decode(buff);
                }
            }
        }
        catch (CancelledKeyException e) {
            this.conn.eot();
        }
        catch (IOException e) {
            this.conn.eot();
        }
        catch (RuntimeException e) {
            this.onError(e);
            this.conn.close(1006);
        }
    }

    private int getPort() {
        int port = this.uri.getPort();
        if (port == -1) {
            String scheme = this.uri.getScheme();
            if (scheme.equals("wss")) {
                return 443;
            }
            if (scheme.equals("ws")) {
                return 80;
            }
            throw new RuntimeException("unkonow scheme" + scheme);
        }
        return port;
    }

    private void finishConnect(SelectionKey key) throws IOException, InvalidHandshakeException {
        if (this.channel.isConnectionPending()) {
            this.channel.finishConnect();
        }
        this.conn.key = key.interestOps(5);
        this.conn.channel = this.wrappedchannel = this.wf.wrapChannel(key, this.uri.getHost(), this.getPort());
        this.sendHandshake();
    }

    private void sendHandshake() throws InvalidHandshakeException {
        String part1 = this.uri.getPath();
        String part2 = this.uri.getQuery();
        String path = part1 == null || part1.length() == 0 ? "/" : part1;
        if (part2 != null) {
            path = path + "?" + part2;
        }
        int port = this.getPort();
        String host = this.uri.getHost() + (port != 80 ? ":" + port : "");
        HandshakeImpl1Client handshake = new HandshakeImpl1Client();
        handshake.setResourceDescriptor(path);
        handshake.put("Host", host);
        if (this.headers != null) {
            for (Map.Entry<String, String> kv : this.headers.entrySet()) {
                handshake.put(kv.getKey(), kv.getValue());
            }
        }
        this.conn.startHandshake(handshake);
    }

    public int getReadyState() {
        if (this.conn == null) {
            return 0;
        }
        return this.conn.getReadyState();
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, String message) {
        this.onMessage(message);
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        this.onMessage(blob);
    }

    @Override
    public final void onWebsocketOpen(WebSocket conn, Handshakedata handshake) {
        this.connectLatch.countDown();
        this.onOpen((ServerHandshake)handshake);
    }

    @Override
    public final void onWebsocketClose(WebSocket conn, int code, String reason, boolean remote) {
        this.connectLatch.countDown();
        this.closeLatch.countDown();
        this.onClose(code, reason, remote);
    }

    @Override
    public final void onWebsocketError(WebSocket conn, Exception ex) {
        this.onError(ex);
    }

    @Override
    public final void onWriteDemand(WebSocket conn) {
        try {
            this.key.interestOps(5);
            this.selector.wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public WebSocket getConnection() {
        return this.conn;
    }

    public final void setWebSocketFactory(WebSocketClientFactory wsf) {
        this.wf = wsf;
    }

    public final WebSocketFactory getWebSocketFactory() {
        return this.wf;
    }

    public abstract void onOpen(ServerHandshake var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void onMessage(ByteBuffer bytes) {
    }

    public static interface WebSocketClientFactory
    extends WebSocketFactory {
        public ByteChannel wrapChannel(SelectionKey var1, String var2, int var3) throws IOException;
    }
}

