package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link FinishCollaborationParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author lee-mk
 * @version 1.0.0
 */
public class FinishCollaborationParameters extends HttpParameterObject {
    /**
     * セッションID
     * @since 1.0.0
     */
    private String sid;
    private String cmd;
    private Integer roomId;

    /**
     * {@link FinishCollaborationParameters} のインスタンスを初期化します。
     * @param sid ログインした時のセッションIDです。
     * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
     * @since 1.0.0
     */
    public FinishCollaborationParameters(String sid, String cmd, Integer roomId) {
        this.sid = sid;
        this.cmd = cmd;
        this.roomId = roomId;
    }

    /**
     * セッションIDを返します。
     * @return ログインした時のセッションIDです。
     * @since 1.0.0
     */
    public String getSid() {
        return sid;
    }

    /**
     * コマンドを返します。
     * @return ログインした時のセッションIDです。
     * @since 1.0.0
     */
    public String getCmd() {
        return cmd;
    }

    /**
     * roomIdを返します。
     * @return roomId
     * @since 1.0.0
     */
    public Integer getRoomId() {
        return roomId;
    }

}
