package jp.agentec.abook.abv.cl.push;

import android.content.Context;

import androidx.annotation.NonNull;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;

import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.ThreadUtil;
import jp.agentec.abook.abv.launcher.android.R;


public class FcmManager {
    private static final String TAG = "FcmManager";

    /**
     * FcmTokenを返す。ただし、PushMessageの利用なしの場合は、noneIdを返す。
     * @param context Context
     * @param resultCallback 結果値を返す関数
     */
    public static void getFcmToken(Context context, final Callback resultCallback) {
        if (context.getResources().getInteger(R.integer.push_message) == 1) {
            FirebaseMessaging.getInstance().getToken()
                    .addOnCompleteListener(new OnCompleteListener<String>() {
                        @Override
                        public void onComplete(@NonNull Task<String> task) {
                            if (!task.isSuccessful()) {
                                Logger.w(TAG, "Fetching FCM registration token failed", task.getException());
                                resultCallback.callback(null);
                                return;
                            }

                            // Get new FCM registration token
                            String token = task.getResult();
                            resultCallback.callback(token);
                        }
                    });
        } else {
            resultCallback.callback("noneId");
        }
    }
}