package jp.agentec.abook.abv.cl.util;

import android.bluetooth.BluetoothGatt;

public interface AlcoholCheckerUtilListener {
    void onConnectionError(int status);     // ディバイス接続エラー
    void onMeasurementError(String txt);    // 吹付エラー
    void onBreakDownError(String txt);      // 機器の故障
    void onLowBatteryError(String txt);     // バッテリー不足
    void onOverUsedError(String txt);       // 使用回数超過
    void onPowerOff(String txt);            // 機器の電源がOFF
    void onStartMeasurement();              // 吹付開始
    void onUpdateTBVCalc(String text);
    void onServicesDiscovered(int status);
    void onGetDeviceInfo(String alcohol);
}
