package jp.agentec.abook.abv.data;

import android.content.Context;
import android.content.SharedPreferences;

import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.ArchiveListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.ChangeRoomNameJSON;
import jp.agentec.abook.abv.bl.acms.client.json.GetFavoriteGroupJSON;
import jp.agentec.abook.abv.bl.acms.client.json.GetFavoriteUserJSON;
import jp.agentec.abook.abv.bl.acms.client.json.GroupListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.MessageInfoListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.MyInfoJSON;
import jp.agentec.abook.abv.bl.acms.client.json.RoomJSON;
import jp.agentec.abook.abv.bl.acms.client.json.RoomListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.UnreadCountJSON;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.dto.ArchiveDto;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.CommunicationLogic;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.CollectionUtil;
import jp.agentec.adf.util.StringUtil;

public class ChatData {
    private Context context;
    public String sid;
    public String roomName;
    public String loginId;
    public String shopName;
    public Integer shopMemberId;
    private boolean isOnline;
    public String groupId;
    public Long roomId;
    public String roomType;
    private String strCollaborationType;
    private String beforeRoomType;
    public Integer joinMeetingId;
    private boolean isMobile;
    private Integer collaborationJoinFlg = 0;
    private String languageCode;

    // サーバー情報
    private String chatServerUrl;
    private String cmsServerUrl;

    private int mCollaborationType;
    private int mHostRequestFlg = 0;
    private CommunicationLogic communicationLogic = AbstractLogic.getLogic(CommunicationLogic.class);

    private static ChatData instance = null;
    // シングルトン
    public static synchronized ChatData getInstance() {
        if (instance == null) {
            instance = new ChatData();
        }
        return instance;
    }

    private ChatData() {
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return sid;
    }

    public void setRoomID(Long roomID) {
        this.roomId = roomID;
    }

    public Long getRoomID() {
        return roomId;
    }

    public void setBeforeRoomType(String beforeRoomType) {
        this.beforeRoomType = beforeRoomType;
    }

    public String getBeforeRoomType() {
        return beforeRoomType;
    }

    public void setCollaborationJoinFlg(Integer collaborationJoinFlg) {
        this.collaborationJoinFlg = collaborationJoinFlg;
    }

    public void setStrCollaborationType(String strCollaborationType) {
        this.strCollaborationType = strCollaborationType;
    }

    public void setLanguageCode(String code) {
        languageCode = code;
    }

    public String getLanguageCode() {
        return languageCode;
    }

    public String getChatServerUrl() {
        return chatServerUrl;
    }

    public void setChatServerUrl(String chatServerUrl) {
        this.chatServerUrl = chatServerUrl;
    }

    public String getCmsServerUrl() {
        return cmsServerUrl;
    }

    public void setCmsServerUrl(String cmsServerUrl) {
        this.cmsServerUrl = cmsServerUrl;
    }

    public void setIsOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    public boolean getIsOnline() {
        return isOnline;
    }

    public void setIsMobile(boolean isMobile) {
        this.isMobile = isMobile;
    }

    public void updateMyInfoFromServer() throws NetworkDisconnectedException, AcmsException {
        MyInfoJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getMyInfo(sid);
        if (resultJson.shopMemberDto != null) {
            communicationLogic.insertMyInfo(resultJson.shopMemberDto);
        }
    }

    public void updateUserInfoFromServer(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        MyInfoJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getNameCard(sid, shopMemberId);
        communicationLogic.insertShopMember(resultJson.shopMemberDto);
    }

    public boolean insertFavoriteUser(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .insertFavoriteUser(sid,Integer.parseInt(shopMemberId));
        if (!result) { return false; }
        List<Integer> shopMeberIds = new ArrayList<>();
        shopMeberIds.add(Integer.parseInt(shopMemberId));
        communicationLogic.updateFavoriteUser(shopMeberIds);
        return result;
    }

    public boolean deleteFavoriteUser(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .deleteFavoriteUser(sid, Integer.parseInt(shopMemberId));
        if (result) {
            List<Integer> deleteFavoriteList = new ArrayList<Integer>();
            deleteFavoriteList.add(Integer.parseInt(shopMemberId));
            communicationLogic.deleteavoriteUser(deleteFavoriteList);
        }
        return result;
    }

    public boolean insertFavoriteGroup(String groupId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .insertFavoriteGroup(sid, Integer.parseInt(groupId));
        return result;
    }

    public void updateUnreadCount() throws NetworkDisconnectedException, AcmsException {
        UnreadCountJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getMessagesUnreadCount(sid, Integer.toString(roomId.intValue()));
        communicationLogic.updateUnreadCount(resultJson.chatMessageDtoArrayList, Integer.toString(roomId.intValue()));
    }

    public void updateMessageFromMessageId(String messageId) throws NetworkDisconnectedException, AcmsException {
        MessageInfoListJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getMessages(sid, Integer.toString(roomId.intValue()), messageId, null);
        for (ChatMessageDto chatMessageDto : resultJson.chatMessageDtoArrayList) {
            chatMessageDto.chatRoomId = roomId.intValue();
        }
        communicationLogic.insertMessageList(resultJson.chatMessageDtoArrayList);
        communicationLogic.insertShopMember(resultJson.shopMemberDtoArrayList);
        updateUnreadCount();
    }

    public void updateRoomList() throws NetworkDisconnectedException, AcmsException {
        RoomListJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getRoomList(sid);
        communicationLogic.insertChatRoomList(resultJson.roomList);
    }

    /**
     *
     * @param changeRoomName
     * @throws NetworkDisconnectedException
     * @throws AcmsException
     */
    public void changeRoomName(String changeRoomName) throws NetworkDisconnectedException, AcmsException {
        ChangeRoomNameJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .changeRoomName(sid, changeRoomName, roomId.intValue());
        if (resultJson.status != 200) { return; }

        communicationLogic.updateChatRoomName(changeRoomName, roomId.intValue());
    }

    public void joinRoom(String joinRoomId, String joinRoomName) {
        ChatRoomDto chatRoom = communicationLogic.getChatRoom(Integer.parseInt(joinRoomId));
        roomId = chatRoom.chatRoomId.longValue();
        roomName = chatRoom.chatRoomName;
        roomType = chatRoom.type.toString();
        beforeRoomType = chatRoom.type.toString();
        communicationLogic.roomDisplayOff(roomId.intValue(), ABookCommConstants.FLAG.ROOM_VIEW_FLAG.VISIBLE);
    }

    public void updateArchiveList() throws NetworkDisconnectedException, AcmsException {
        SharedPreferences pref = context.getSharedPreferences(ABookCommConstants.TAG, Context.MODE_PRIVATE);
        String updateDate = pref.getString(ABookCommConstants.KEY.ARCHIVE_UPDATED_DATE, ABookCommConstants.DEFAULT_CHECKSUM);
        ArchiveListJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getArchives(sid, updateDate);
        communicationLogic.updateArchives(resultJson.archiveList);
        if (StringUtil.isNullOrEmpty(resultJson.archiveLastUpdateDate)) { return; }
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(ABookCommConstants.KEY.ARCHIVE_UPDATED_DATE, resultJson.archiveLastUpdateDate);
        editor.commit();
    }

    public void updateArchiveDetail(String archiveId) throws NetworkDisconnectedException, AcmsException {
        ArchiveDto archiveDto = communicationLogic.getArchive(Integer.parseInt(archiveId));
        RoomJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getRoom(sid, archiveDto.roomId.toString());
        archiveDto.roomName = resultJson.chatRoomDto.chatRoomName;
        communicationLogic.updateArchiveDetial(archiveDto);
    }

    public void joinCollaboration(String collaborationType, String meetingId) throws NetworkDisconnectedException, AcmsException {
        joinMeetingId = Integer.parseInt(meetingId);
        collaborationJoinFlg = ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.JOIN;
        AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .joinCollaboration(sid, roomId.intValue());
    }

    public void joinChangedCollaboration(String collaborationType, String meetingId) throws NetworkDisconnectedException, AcmsException {
        joinMeetingId = Integer.parseInt(meetingId);
        collaborationJoinFlg = ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.JOIN;
        AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .joinCollaboration(sid, roomId.intValue());
    }

    public void inviteCollaboration(String inviteUserIds, String collaborationType) throws NetworkDisconnectedException, AcmsException {
        AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .inviteCollaboration(sid, roomId.intValue(), roomName, inviteUserIds, collaborationType);
    }

    public void finishCollaboration() throws NetworkDisconnectedException, AcmsException {
        AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .finishCollaboration(sid, roomId.intValue());
    }

    public void finishAllCollaboration() throws NetworkDisconnectedException, AcmsException {
        try {
            AcmsClient
                    .getInstance(ABVEnvironment.getInstance().networkAdapter)
                    .finishAllCollaboration(sid, roomId.intValue());
        } catch (AcmsException e) {
            e.printStackTrace();
        }
    }
    private void updateFavoriteUser() throws NetworkDisconnectedException, AcmsException {
        GetFavoriteUserJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getFavoriteUser(sid);
        communicationLogic.updateFavoriteUser(resultJson.favoriteUserIds);
    }

    public void updateFavoriteGroup() throws NetworkDisconnectedException, AcmsException {
        GetFavoriteGroupJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getFavoriteGroup(sid);
        communicationLogic.updateFavoriteGroup(resultJson.favoriteGroupIds);
    }

    public void updateAllGroupInfo() throws NetworkDisconnectedException, AcmsException {
        updateGroupInfoFromServer();
    }

    public void updateFavoriteInfo() throws NetworkDisconnectedException, AcmsException {
        updateFavoriteUser();
        updateFavoriteGroup();
    }

    public void updateGroupInfoFromServer() throws NetworkDisconnectedException {
        SharedPreferences pref = context.getSharedPreferences(ABookCommConstants.TAG, Context.MODE_PRIVATE);
        String lastUpdatedDate = pref.getString(ABookCommConstants.KEY.GROUP_MEMBER_UPDATED_DATE, ABookCommConstants.DEFAULT_CHECKSUM);
        try {
            GroupListJSON resultJson = AcmsClient
                    .getInstance(ABVEnvironment.getInstance().networkAdapter)
                    .getGroupInfo(sid, lastUpdatedDate);
            if (CollectionUtil.isNotEmpty(resultJson.groupList)) {
                communicationLogic.updateGroup(resultJson.groupList);
                SharedPreferences.Editor editor = pref.edit();
                editor.putString(ABookCommConstants.KEY.GROUP_MEMBER_UPDATED_DATE, resultJson.lastRequestDate);
                editor.commit();
            }
        } catch (AcmsException e) {
            e.printStackTrace();
        }
    }

    public void changeCollaboration(int changeCollaborationType, int meetingId) throws NetworkDisconnectedException, AcmsException {
        AcmsClient.
                getInstance(ABVEnvironment.getInstance().networkAdapter).
                changeCollaboration(sid, roomId.intValue(), changeCollaborationType, meetingId);
    }

    public void updatePreMessage(String messageId) throws NetworkDisconnectedException, AcmsException {
        if (messageId.equals("0")) {
            return;
        }
        updateMessageFromMessageId(messageId);
    }

    public String getMessageListFromMessageId(String messageId) {
        if (messageId.equals("0")) {
            return "";
        }
        return communicationLogic.getMessagesFromMessageId(roomId.intValue(), messageId);
    }

    public String getCollaborationJoinFlg() {
        return this.collaborationJoinFlg.toString();
    }

    public String getStrCollaborationType() {
        return strCollaborationType;
    }

    public String getToMoveGroupId() {
        return groupId;
    }

    public void setToMoveGroupId(String moveToGroupId) {
        groupId = moveToGroupId;
    }

    public void setHostRequestFlg(int hostRequestFlg) {
        mHostRequestFlg = hostRequestFlg;
    }

    public int getHostRequestFlg() {
        return mHostRequestFlg;
    }

    public String getServerInfo() {
        chatServerUrl = ABVEnvironment.getInstance().websocketServerHttpUrl;
        chatServerUrl= chatServerUrl.substring(0, chatServerUrl.length() - 3);
        cmsServerUrl = ABVEnvironment.getInstance().acmsAddress+ ABVDataCache.getInstance().getUrlPath();

        JSONObject jsonObj = new JSONObject();
        jsonObj.put(ABookCommConstants.KEY.CHAT_URL, chatServerUrl);
        jsonObj.put(ABookCommConstants.KEY.CMS_URL, cmsServerUrl);
        jsonObj.put(ABookCommConstants.KEY.IS_ONLINE, isOnline);
        return jsonObj.toString();
    }

    public String getMyUserInfo() {
        languageCode = ActivityHandlingHelper.getInstance().getLocaleFileName();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(ABookCommConstants.KEY.SID, sid);
        jsonObj.put(ABookCommConstants.KEY.LOGIN_ID, loginId);
        jsonObj.put(ABookCommConstants.KEY.SHOP_NAME, shopName);
        jsonObj.put(ABookCommConstants.KEY.SHOP_MEMBER_ID, shopMemberId);
        jsonObj.put(ABookCommConstants.KEY.LANGUAGE_CODE, languageCode);
        return jsonObj.toString();
    }
    public String getRoomInfo() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(ABookCommConstants.KEY.ROOM_ID_UPPERCASE_D, roomId);
        jsonObj.put(ABookCommConstants.KEY.ROOM_NAME, roomName);
        jsonObj.put(ABookCommConstants.KEY.ROOM_TYPE, roomType);
        return jsonObj.toString();
    }

    public String getDeviceInfo() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(ABookCommConstants.KEY.IS_MOBILE, isMobile);
        jsonObj.put(ABookCommConstants.KEY.PLATFORM, ABookCommConstants.PLATFORM_NAME);
        return jsonObj.toString();
    }

    public String getMessageList(String roomId) {
        return communicationLogic.getMessages(Integer.parseInt(roomId));
    }

    public String getFavoriteUsers() {
        return communicationLogic.getFavoriteUsers();
    }

    public String getMyInfo() {
        return communicationLogic.getMyInfo();
    }

    public String getUsersInRoom(String roomId) {
        return communicationLogic.getUsersInRoom(Integer.parseInt(roomId));
    }

    public String getMyGroupUsers() {
        return communicationLogic.getMyGroupUsers();
    }

    public String getMyGroupShopMemberByName(String keyword) {
        return communicationLogic.getMyGroupUserByName(keyword);
    }

    public String getAllGroupShopMemberByName(String shopMemberName) {
        return communicationLogic.getAllGroupShopMemberByName(shopMemberName);
    }

    public String getGroupByName(String keyword) {
        return communicationLogic.getGroupByName(keyword);
    }

    public String getFavoriteGroups() {
        return communicationLogic.getFavoriteGroups();
    }

    public String getGroupInfo(String groupId) {
        return communicationLogic.getGroupSearchData(Integer.parseInt(groupId));
    }

    public String getNameCardData(String shopMemberId) {
        return communicationLogic.getNameCardInfo(Integer.parseInt(shopMemberId));
    }

    public String getFavoriteGroupsList() {
        return communicationLogic.getFavoriteGroups();
    }

    public String getArchiveList() {
        return communicationLogic.getAllArchive();
    }

    public String getArchiveListByName(String keyword) {
        return communicationLogic.getArchiveListByName(keyword);
    }

    public String getUserInfo(String shopMemberId) {
        return communicationLogic.getUserInfo(Integer.parseInt(shopMemberId));
    }

    public String getUserInfoList(String shopMemberIds) {
        return communicationLogic.getUserList(shopMemberIds);
    }

    public String getArchiveDetail(String archiveId) {
        return communicationLogic.getArchiveDetail(Integer.parseInt(archiveId));
    }

    public String getContentList() {
        return communicationLogic.getContentList();
    }

    public String getUserListByLoginId(String loginIdList) {
        return communicationLogic.getUserListByLoginId(loginIdList);
    }

    public String getRoomList(String roomType, String keyword) {
        return communicationLogic.getChatRoomList(Integer.parseInt(roomType), keyword);
    }

    public int getJoinCollaborationType() {
        return mCollaborationType;
    }

    public void setJoinCollaborationType(int collaborationType) {
        mCollaborationType = collaborationType;
    }
}
