package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.os.AsyncTask;

import com.theta.network.HttpConnector;
import com.theta.network.HttpEventListener;

import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaCameraActivity;

/**
 * THETAカメラ撮影スレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class ShootTask extends AsyncTask<Void, Void, HttpConnector.ShootResult> {
    private static final String TAG = "ShootTask";

    private final WeakReference<ThetaCameraActivity> refActivity;

    public ShootTask(ThetaCameraActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected void onPreExecute() {
        Logger.d(TAG, "takePicture");
    }

    @Override
    protected HttpConnector.ShootResult doInBackground(Void... params) {
        Logger.d(TAG, "doInBackground");
        CaptureListener postviewListener = new CaptureListener();
        boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(), ABookKeys.THETA_OLD_VERSION_FLG, false);
        HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
        return camera.takePicture(postviewListener);
    }

    @Override
    protected void onPostExecute(HttpConnector.ShootResult result) {
        if (result == HttpConnector.ShootResult.FAIL_CAMERA_DISCONNECTED) {
            Logger.e(TAG, "takePicture:FAIL_CAMERA_DISCONNECTED");
        } else if (result == HttpConnector.ShootResult.FAIL_STORE_FULL) {
            Logger.e(TAG, "takePicture:FAIL_STORE_FULL");
        } else if (result == HttpConnector.ShootResult.FAIL_DEVICE_BUSY) {
            Logger.e(TAG, "takePicture:FAIL_DEVICE_BUSY");
        } else if (result == HttpConnector.ShootResult.SUCCESS) {
            Logger.d(TAG, "takePicture:SUCCESS");
        }
        if (result != HttpConnector.ShootResult.SUCCESS) {
            ThetaCameraActivity activity = refActivity.get();
            activity.shootTaskFinish(ABookValues.FAIL);
        }
    }

    private class CaptureListener implements HttpEventListener {
        private String latestCapturedFileId;
        private boolean ImageAdd = false;

        @Override
        public void onCheckStatus(boolean newStatus) {
            if (newStatus) {
                Logger.d(TAG, "takePicture:FINISHED");
            } else {
                Logger.d(TAG, "takePicture:PROGRESS");
            }
        }

        @Override
        public void onObjectChanged(String latestCapturedFileId) {
            this.ImageAdd = true;
            this.latestCapturedFileId = latestCapturedFileId;
            Logger.d(TAG, "ImageAdd:FileId " + this.latestCapturedFileId);
        }

        @Override
        public void onCompleted() {
            Logger.d(TAG, "CaptureComplete");
            if (ImageAdd) {
                ThetaCameraActivity activity = refActivity.get();
                activity.shootTaskFinish(latestCapturedFileId);
            }
        }

        @Override
        public void onError(String errorMessage) {
            Logger.e(TAG, "CaptureError " + errorMessage);
            ThetaCameraActivity activity = refActivity.get();
            activity.shootTaskFinish(ABookValues.FAIL);
        }
    }
}
