/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.manager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oz.lottie.ImageAssetDelegate;
import oz.lottie.LottieImageAsset;
import oz.lottie.utils.Logger;
import oz.lottie.utils.Utils;

public class ImageAssetManager {
    private static final Object bitmapHashLock = new Object();
    private final Context context;
    private String imagesFolder;
    private ImageAssetDelegate delegate;
    private final Map imageAssets;

    public ImageAssetManager(Drawable.Callback callback, String string, ImageAssetDelegate imageAssetDelegate, Map map) {
        this.imagesFolder = string;
        if (!TextUtils.isEmpty((CharSequence)string) && this.imagesFolder.charAt(this.imagesFolder.length() - 1) != '/') {
            this.imagesFolder = String.valueOf(this.imagesFolder) + '/';
        }
        if (!(callback instanceof View)) {
            Logger.warning("LottieDrawable must be inside of a view for images to work.");
            this.imageAssets = new HashMap();
            this.context = null;
            return;
        }
        this.context = ((View)callback).getContext();
        this.imageAssets = map;
        this.setDelegate(imageAssetDelegate);
    }

    public void setDelegate(ImageAssetDelegate imageAssetDelegate) {
        this.delegate = imageAssetDelegate;
    }

    public Bitmap updateBitmap(String string, Bitmap bitmap) {
        if (bitmap == null) {
            LottieImageAsset lottieImageAsset = (LottieImageAsset)this.imageAssets.get(string);
            Bitmap bitmap2 = lottieImageAsset.getBitmap();
            lottieImageAsset.setBitmap(null);
            return bitmap2;
        }
        Bitmap bitmap3 = ((LottieImageAsset)this.imageAssets.get(string)).getBitmap();
        this.putBitmap(string, bitmap);
        return bitmap3;
    }

    public Bitmap bitmapForId(String string) {
        InputStream inputStream;
        LottieImageAsset lottieImageAsset = (LottieImageAsset)this.imageAssets.get(string);
        if (lottieImageAsset == null) {
            return null;
        }
        Bitmap bitmap = lottieImageAsset.getBitmap();
        if (bitmap != null) {
            return bitmap;
        }
        if (this.delegate != null) {
            bitmap = this.delegate.fetchBitmap(lottieImageAsset);
            if (bitmap != null) {
                this.putBitmap(string, bitmap);
            }
            return bitmap;
        }
        String string2 = lottieImageAsset.getFileName();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = true;
        options.inDensity = 160;
        if (string2.startsWith("data:") && string2.indexOf("base64,") > 0) {
            byte[] byArray;
            try {
                byArray = Base64.decode((String)string2.substring(string2.indexOf(44) + 1), (int)0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.warning("data URL did not have correct base64 format.", illegalArgumentException);
                return null;
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            return this.putBitmap(string, bitmap);
        }
        try {
            if (TextUtils.isEmpty((CharSequence)this.imagesFolder)) {
                throw new IllegalStateException("You must set an images folder before loading an image. Set it with LottieComposition#setImagesFolder or LottieDrawable#setImagesFolder");
            }
            inputStream = this.context.getAssets().open(String.valueOf(this.imagesFolder) + string2);
        }
        catch (IOException iOException) {
            Logger.warning("Unable to open asset.", iOException);
            return null;
        }
        bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        bitmap = Utils.resizeBitmapIfNeeded(bitmap, lottieImageAsset.getWidth(), lottieImageAsset.getHeight());
        return this.putBitmap(string, bitmap);
    }

    public boolean hasSameContext(Context context) {
        return context == null && this.context == null || this.context.equals(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap putBitmap(String string, Bitmap bitmap) {
        Object object = bitmapHashLock;
        synchronized (object) {
            ((LottieImageAsset)this.imageAssets.get(string)).setBitmap(bitmap);
            return bitmap;
        }
    }
}

