/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser.moshi;

import java.io.EOFException;
import oz.lottie.custom.okio.Buffer;
import oz.lottie.custom.okio.BufferedSource;
import oz.lottie.custom.okio.ByteString;
import oz.lottie.parser.moshi.JsonDataException;
import oz.lottie.parser.moshi.JsonEncodingException;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.parser.moshi.JsonReader$Token;

final class JsonUtf8Reader
extends JsonReader {
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.encodeUtf8("'\\");
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.encodeUtf8("\"\\");
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.encodeUtf8("{}[]:, \n\t\r\f/\\;#=");
    private static final ByteString LINEFEED_OR_CARRIAGE_RETURN = ByteString.encodeUtf8("\n\r");
    private static final ByteString CLOSING_BLOCK_COMMENT = ByteString.encodeUtf8("*/");
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_BUFFERED_NAME = 15;
    private static final int PEEKED_LONG = 16;
    private static final int PEEKED_NUMBER = 17;
    private static final int PEEKED_EOF = 18;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final BufferedSource source;
    private final Buffer buffer;
    private int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;

    JsonUtf8Reader(BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        this.source = bufferedSource;
        this.buffer = bufferedSource.buffer();
        this.pushScope(6);
    }

    @Override
    public void beginArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.pushScope(1);
        this.pathIndices[this.stackSize - 1] = 0;
        this.peeked = 0;
    }

    @Override
    public void endArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 4) {
            --this.stackSize;
        } else {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        this.peeked = 0;
    }

    @Override
    public void beginObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.pushScope(3);
        this.peeked = 0;
    }

    @Override
    public void endObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 2) {
            --this.stackSize;
        } else {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.pathNames[this.stackSize] = null;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        this.peeked = 0;
    }

    @Override
    public boolean hasNext() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        return n != 2 && n != 4 && n != 18;
    }

    @Override
    public JsonReader$Token peek() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        switch (n) {
            case 1: {
                return JsonReader$Token.BEGIN_OBJECT;
            }
            case 2: {
                return JsonReader$Token.END_OBJECT;
            }
            case 3: {
                return JsonReader$Token.BEGIN_ARRAY;
            }
            case 4: {
                return JsonReader$Token.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return JsonReader$Token.NAME;
            }
            case 5: 
            case 6: {
                return JsonReader$Token.BOOLEAN;
            }
            case 7: {
                return JsonReader$Token.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonReader$Token.STRING;
            }
            case 16: 
            case 17: {
                return JsonReader$Token.NUMBER;
            }
            case 18: {
                return JsonReader$Token.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    private int doPeek() {
        int n;
        int n2;
        block44: {
            block46: {
                block45: {
                    block43: {
                        n2 = this.scopes[this.stackSize - 1];
                        if (n2 != 1) break block43;
                        this.scopes[this.stackSize - 1] = 2;
                        break block44;
                    }
                    if (n2 != 2) break block45;
                    n = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    switch (n) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break block44;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                }
                if (n2 == 3 || n2 == 5) {
                    int n3;
                    this.scopes[this.stackSize - 1] = 4;
                    if (n2 == 5) {
                        n3 = this.nextNonWhitespace(true);
                        this.buffer.readByte();
                        switch (n3) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    n3 = this.nextNonWhitespace(true);
                    switch (n3) {
                        case 34: {
                            this.buffer.readByte();
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.buffer.readByte();
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (n2 != 5) {
                                this.buffer.readByte();
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    this.checkLenient();
                    if (this.isLiteral((char)n3)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n2 != 4) break block46;
                this.scopes[this.stackSize - 1] = 5;
                n = this.nextNonWhitespace(true);
                this.buffer.readByte();
                switch (n) {
                    case 58: {
                        break block44;
                    }
                    case 61: {
                        this.checkLenient();
                        if (this.source.request(1L) && this.buffer.getByte(0L) == 62) {
                            this.buffer.readByte();
                        }
                        break block44;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
            }
            if (n2 == 6) {
                this.scopes[this.stackSize - 1] = 7;
            } else if (n2 == 7) {
                n = this.nextNonWhitespace(false);
                if (n == -1) {
                    this.peeked = 18;
                    return 18;
                }
                this.checkLenient();
            } else if (n2 == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        n = this.nextNonWhitespace(true);
        switch (n) {
            case 93: {
                if (n2 == 1) {
                    this.buffer.readByte();
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (n2 == 1 || n2 == 2) {
                    this.checkLenient();
                    this.peeked = 7;
                    return 7;
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.buffer.readByte();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                this.buffer.readByte();
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.buffer.readByte();
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.buffer.readByte();
                this.peeked = 1;
                return 1;
            }
        }
        int n4 = this.peekKeyword();
        if (n4 != 0) {
            return n4;
        }
        n4 = this.peekNumber();
        if (n4 != 0) {
            return n4;
        }
        if (!this.isLiteral(this.buffer.getByte(0L))) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() {
        int n;
        String string;
        String string2;
        byte by = this.buffer.getByte(0L);
        if (by == 116 || by == 84) {
            string2 = "true";
            string = "TRUE";
            n = 5;
        } else if (by == 102 || by == 70) {
            string2 = "false";
            string = "FALSE";
            n = 6;
        } else if (by == 110 || by == 78) {
            string2 = "null";
            string = "NULL";
            n = 7;
        } else {
            return 0;
        }
        int n2 = string2.length();
        int n3 = 1;
        while (n3 < n2) {
            if (!this.source.request(n3 + 1)) {
                return 0;
            }
            by = this.buffer.getByte(n3);
            if (by != string2.charAt(n3) && by != string.charAt(n3)) {
                return 0;
            }
            ++n3;
        }
        if (this.source.request(n2 + 1) && this.isLiteral(this.buffer.getByte(n2))) {
            return 0;
        }
        this.buffer.skip(n2);
        this.peeked = n;
        return this.peeked;
    }

    private int peekNumber() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        block6: while (this.source.request(n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            switch (by) {
                case 45: {
                    if (n == 0) {
                        bl = true;
                        n = 1;
                        break;
                    }
                    if (n == 5) {
                        n = 6;
                        break;
                    }
                    return 0;
                }
                case 43: {
                    if (n == 5) {
                        n = 6;
                        break;
                    }
                    return 0;
                }
                case 69: 
                case 101: {
                    if (n == 2 || n == 4) {
                        n = 5;
                        break;
                    }
                    return 0;
                }
                case 46: {
                    if (n == 2) {
                        n = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (by < 48 || by > 57) {
                        if (!this.isLiteral(by)) break block6;
                        return 0;
                    }
                    if (n == 1 || n == 0) {
                        l = -(by - 48);
                        n = 2;
                        break;
                    }
                    if (n == 2) {
                        if (l == 0L) {
                            return 0;
                        }
                        long l2 = l * 10L - (long)(by - 48);
                        bl2 &= l > -922337203685477580L || l == -922337203685477580L && l2 < l;
                        l = l2;
                        break;
                    }
                    if (n == 3) {
                        n = 4;
                        break;
                    }
                    if (n != 5 && n != 6) break;
                    n = 7;
                }
            }
            ++n2;
        }
        if (!(n != 2 || !bl2 || l == Long.MIN_VALUE && !bl || l == 0L && bl)) {
            this.peekedLong = bl ? l : -l;
            this.buffer.skip(n2);
            this.peeked = 16;
            return 16;
        }
        if (n == 2 || n == 4 || n == 7) {
            this.peekedNumberLength = n2;
            this.peeked = 17;
            return 17;
        }
        return 0;
    }

    private boolean isLiteral(int n) {
        switch (n) {
            case 35: 
            case 47: 
            case 59: 
            case 61: 
            case 92: {
                this.checkLenient();
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 44: 
            case 58: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String nextName() {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 14) {
            string = this.nextUnquotedValue();
        } else if (n == 13) {
            string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (n == 12) {
            string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (n == 15) {
            string = this.peekedString;
        } else {
            throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = string;
        return string;
    }

    @Override
    public int selectName(JsonReader$Options jsonReader$Options) {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n < 12 || n > 15) {
            return -1;
        }
        if (n == 15) {
            return this.findName(this.peekedString, jsonReader$Options);
        }
        int n2 = this.source.select(jsonReader$Options.doubleQuoteSuffix);
        if (n2 != -1) {
            this.peeked = 0;
            this.pathNames[this.stackSize - 1] = jsonReader$Options.strings[n2];
            return n2;
        }
        String string = this.pathNames[this.stackSize - 1];
        String string2 = this.nextName();
        n2 = this.findName(string2, jsonReader$Options);
        if (n2 == -1) {
            this.peeked = 15;
            this.peekedString = string2;
            this.pathNames[this.stackSize - 1] = string;
        }
        return n2;
    }

    @Override
    public void skipName() {
        if (this.failOnUnknown) {
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 14) {
            this.skipUnquotedValue();
        } else if (n == 13) {
            this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (n == 12) {
            this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (n != 15) {
            throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private int findName(String string, JsonReader$Options jsonReader$Options) {
        int n = 0;
        int n2 = jsonReader$Options.strings.length;
        while (n < n2) {
            if (string.equals(jsonReader$Options.strings[n])) {
                this.peeked = 0;
                this.pathNames[this.stackSize - 1] = string;
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public String nextString() {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 10) {
            string = this.nextUnquotedValue();
        } else if (n == 9) {
            string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (n == 8) {
            string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (n == 11) {
            string = this.peekedString;
            this.peekedString = null;
        } else if (n == 16) {
            string = Long.toString(this.peekedLong);
        } else if (n == 17) {
            string = this.buffer.readUtf8(this.peekedNumberLength);
        } else {
            throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        return string;
    }

    private int findString(String string, JsonReader$Options jsonReader$Options) {
        int n = 0;
        int n2 = jsonReader$Options.strings.length;
        while (n < n2) {
            if (string.equals(jsonReader$Options.strings[n])) {
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                this.pathIndices[n3] = this.pathIndices[n3] + 1;
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public boolean nextBoolean() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 5) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return true;
        }
        if (n == 6) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return false;
        }
        throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
    }

    @Override
    public double nextDouble() {
        double d2;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 16) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 17) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (n == 9) {
            this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (n == 8) {
            this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (n == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (n != 11) {
            throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            d2 = Double.parseDouble(this.peekedString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPath());
        }
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + d2 + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        return d2;
    }

    private String nextQuotedValue(ByteString byteString) {
        long l;
        StringBuilder stringBuilder = null;
        while (true) {
            if ((l = this.source.indexOfElement(byteString)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(l) != 92) break;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.buffer.readUtf8(l));
            this.buffer.readByte();
            stringBuilder.append(this.readEscapeCharacter());
        }
        if (stringBuilder == null) {
            String string = this.buffer.readUtf8(l);
            this.buffer.readByte();
            return string;
        }
        stringBuilder.append(this.buffer.readUtf8(l));
        this.buffer.readByte();
        return stringBuilder.toString();
    }

    private String nextUnquotedValue() {
        long l = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return l != -1L ? this.buffer.readUtf8(l) : this.buffer.readUtf8();
    }

    private void skipQuotedValue(ByteString byteString) {
        long l;
        while (true) {
            if ((l = this.source.indexOfElement(byteString)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(l) != 92) break;
            this.buffer.skip(l + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(l + 1L);
    }

    private void skipUnquotedValue() {
        long l = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(l != -1L ? l : this.buffer.size());
    }

    @Override
    public int nextInt() {
        double d2;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 16) {
            int n2 = (int)this.peekedLong;
            if (this.peekedLong != (long)n2) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return n2;
        }
        if (n == 17) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (n == 9 || n == 8) {
            this.peekedString = n == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                int n4 = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n5 = this.stackSize - 1;
                this.pathIndices[n5] = this.pathIndices[n5] + 1;
                return n4;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            d2 = Double.parseDouble(this.peekedString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        int n6 = (int)d2;
        if ((double)n6 != d2) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n7 = this.stackSize - 1;
        this.pathIndices[n7] = this.pathIndices[n7] + 1;
        return n6;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.scopes[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() {
        if (this.failOnUnknown) {
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        int n = 0;
        do {
            int n2;
            if ((n2 = this.peeked) == 0) {
                n2 = this.doPeek();
            }
            if (n2 == 3) {
                this.pushScope(1);
                ++n;
            } else if (n2 == 1) {
                this.pushScope(3);
                ++n;
            } else if (n2 == 4) {
                if (--n < 0) {
                    throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
                }
                --this.stackSize;
            } else if (n2 == 2) {
                if (--n < 0) {
                    throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
                }
                --this.stackSize;
            } else if (n2 == 14 || n2 == 10) {
                this.skipUnquotedValue();
            } else if (n2 == 9 || n2 == 13) {
                this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
            } else if (n2 == 8 || n2 == 12) {
                this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
            } else if (n2 == 17) {
                this.buffer.skip(this.peekedNumberLength);
            } else if (n2 == 18) {
                throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
            this.peeked = 0;
        } while (n != 0);
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private int nextNonWhitespace(boolean bl) {
        int n = 0;
        block4: while (this.source.request(n + 1)) {
            byte by;
            if ((by = this.buffer.getByte(n++)) == 10 || by == 32 || by == 13 || by == 9) continue;
            this.buffer.skip(n - 1);
            if (by == 47) {
                if (!this.source.request(2L)) {
                    return by;
                }
                this.checkLenient();
                byte by2 = this.buffer.getByte(1L);
                switch (by2) {
                    case 42: {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        if (!this.skipToEndOfBlockComment()) {
                            throw this.syntaxError("Unterminated comment");
                        }
                        n = 0;
                        continue block4;
                    }
                    case 47: {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        this.skipToEndOfLine();
                        n = 0;
                        continue block4;
                    }
                    default: {
                        return by;
                    }
                }
            }
            if (by == 35) {
                this.checkLenient();
                this.skipToEndOfLine();
                n = 0;
                continue;
            }
            return by;
        }
        if (bl) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    private void checkLenient() {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() {
        long l = this.source.indexOfElement(LINEFEED_OR_CARRIAGE_RETURN);
        this.buffer.skip(l != -1L ? l + 1L : this.buffer.size());
    }

    private boolean skipToEndOfBlockComment() {
        long l = this.source.indexOf(CLOSING_BLOCK_COMMENT);
        boolean bl = l != -1L;
        this.buffer.skip(bl ? l + (long)CLOSING_BLOCK_COMMENT.size() : this.buffer.size());
        return bl;
    }

    public String toString() {
        return "JsonReader(" + this.source + ")";
    }

    private char readEscapeCharacter() {
        if (!this.source.request(1L)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        byte by = this.buffer.readByte();
        switch (by) {
            case 117: {
                if (!this.source.request(4L)) {
                    throw new EOFException("Unterminated escape sequence at path " + this.getPath());
                }
                char c2 = '\u0000';
                int n = 0;
                int n2 = n + 4;
                while (n < n2) {
                    byte by2 = this.buffer.getByte(n);
                    c2 = (char)(c2 << 4);
                    if (by2 >= 48 && by2 <= 57) {
                        c2 = (char)(c2 + (by2 - 48));
                    } else if (by2 >= 97 && by2 <= 102) {
                        c2 = (char)(c2 + (by2 - 97 + 10));
                    } else if (by2 >= 65 && by2 <= 70) {
                        c2 = (char)(c2 + (by2 - 65 + 10));
                    } else {
                        throw this.syntaxError("\\u" + this.buffer.readUtf8(4L));
                    }
                    ++n;
                }
                this.buffer.skip(4L);
                return c2;
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 102: {
                return '\f';
            }
            case 10: 
            case 34: 
            case 39: 
            case 47: 
            case 92: {
                return (char)by;
            }
        }
        if (!this.lenient) {
            throw this.syntaxError("Invalid escape sequence: \\" + (char)by);
        }
        return (char)by;
    }
}

