/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import oz.util.view.camera.ImageSealView;
import oz.util.view.camera.ImageSealView$OnTakePictureListener;
import oz.viewer.ui.df.ctrl.DFImageRecognitionData;
import oz.viewer.ui.df.view.DFInputCompImageBase;
import oz.viewer.ui.df.view.DFInputCompView$DFInputCompInterface;

public class DFInputCompImageSeal
extends DFInputCompImageBase
implements View.OnClickListener,
ImageSealView$OnTakePictureListener {
    private ImageSealView mImageSealView;

    public DFInputCompImageSeal(Context context, DFInputCompView$DFInputCompInterface dFInputCompView$DFInputCompInterface) {
        super(context, dFInputCompView$DFInputCompInterface);
    }

    FrameLayout getImagePickerView() {
        this.mImageSealView = new ImageSealView(this.getContext());
        this.mImageSealView.setPictureRatio(this.getInterface().getCompRatio());
        return this.mImageSealView;
    }

    void setOnClickListener() {
        this.mImageSealView.setOnTakePictureListener(this);
        this.mResetButton.setOnClickListener((View.OnClickListener)this);
    }

    protected void create(int n, int n2) {
        this.addView((View)this.getContentLayout());
        if (this.getValue() == null || this.getValue().toString().isEmpty()) {
            this.mResetButton.setVisibility(4);
        }
    }

    protected void updateSizeChanged(int n, int n2) {
        this.mImageSealView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
    }

    protected void updateInternal(boolean bl) {
        if (this.isValueChanged()) {
            int n;
            String string;
            Object object = this.getValue();
            Bitmap bitmap = null;
            if (object != null && (string = object.toString()).length() > 12 && string.startsWith("data:") && (n = string.indexOf("base64,")) > -1) {
                String string2 = string.substring(n + 7);
                try {
                    byte[] byArray = Base64.decode((String)string2, (int)2);
                    if (byArray != null) {
                        bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.mImageSealView.setImageBitmap(bitmap);
        }
    }

    protected void disposeInternal(boolean bl) {
        super.disposeInternal(bl);
        if (bl && this.mImageSealView != null) {
            this.mImageSealView.dismiss();
        }
    }

    public void OnTakePicture(Bitmap bitmap) {
        if (bitmap != null && this.mResetButton.getVisibility() == 4) {
            this.mResetButton.setVisibility(0);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, this.getInterface().getJPGQuality(), (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byArray = this.getInterface().applyImageFilter(byArray);
        byte[] byArray2 = Base64.encode((byte[])byArray, (int)2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data:image/jpg;base64,");
        stringBuilder.append(new String(byArray2));
        this.setValue(stringBuilder.toString());
    }

    public int OnTakePreview(DFImageRecognitionData dFImageRecognitionData) {
        int[] nArray = new int[14];
        nArray[0] = dFImageRecognitionData.mRectWidth;
        nArray[1] = dFImageRecognitionData.mRectHeight;
        nArray[2] = dFImageRecognitionData.mRectLeft;
        nArray[3] = dFImageRecognitionData.mRectTop;
        nArray[4] = dFImageRecognitionData.mBitmapWidth;
        nArray[5] = dFImageRecognitionData.mBitmapHeight;
        nArray[6] = dFImageRecognitionData.mRotation;
        nArray[7] = dFImageRecognitionData.mCameraType;
        nArray[8] = dFImageRecognitionData.mIsFocused;
        nArray[9] = dFImageRecognitionData.mIsOnceFocused;
        nArray[10] = dFImageRecognitionData.mIsForceShutter;
        nArray[11] = dFImageRecognitionData.mIsPreview;
        return this.getInterface().OnCameraPreview(dFImageRecognitionData.mBitmap, dFImageRecognitionData.mData, nArray);
    }

    public void OnStopSpeech() {
        this.getInterface().stopSpeech();
    }

    public void onClick(View view) {
        if (view == this.mImageLayout) {
            this.mResetButton.setVisibility(0);
        } else if (view == this.mResetButton) {
            this.setValue(null, true);
            this.update(false);
            this.mResetButton.setVisibility(4);
        }
    }

    public void OnSetImagePickerFlashModeOpt(int n) {
    }

    public void OnSetImagePickerFacingModeOpt(int n) {
    }

    public void setFlashMode(int n) {
    }

    public void setFacingMode(int n) {
    }
}

