/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;

public class FileUtils {
    private static final String TAG = "FileUtils";

    public static void recursivelyDeleteFile(File currentFile) {
        File[] files;
        assert (!ThreadUtils.runningOnUiThread());
        if (currentFile.isDirectory() && (files = currentFile.listFiles()) != null) {
            for (File file : files) {
                FileUtils.recursivelyDeleteFile(file);
            }
        }
        if (!currentFile.delete()) {
            Log.e(TAG, "Failed to delete: " + currentFile, new Object[0]);
        }
    }

    public static boolean extractAsset(Context context, String assetName, File dest) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int c;
            inputStream = context.getAssets().open(assetName);
            outputStream = new BufferedOutputStream(new FileOutputStream(dest));
            byte[] buffer = new byte[8192];
            while ((c = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, c);
            }
            inputStream.close();
            outputStream.close();
            return true;
        }
        catch (IOException e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

