/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.Locale;
import org.chromium.base.CommandLine;
import org.chromium.base.annotations.CalledByNative;

public class LocaleUtils {
    private LocaleUtils() {
    }

    public static String getLocale(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if ("iw".equals(language)) {
            language = "he";
        } else if ("in".equals(language)) {
            language = "id";
        } else if ("tl".equals(language)) {
            language = "fil";
        }
        return country.isEmpty() ? language : language + "-" + country;
    }

    @CalledByNative
    public static String getDefaultLocale() {
        return LocaleUtils.getLocale(Locale.getDefault());
    }

    @CalledByNative
    private static String getDefaultCountryCode() {
        CommandLine commandLine = CommandLine.getInstance();
        return commandLine.hasSwitch("default-country-code") ? commandLine.getSwitchValue("default-country-code") : Locale.getDefault().getCountry();
    }
}

