/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import org.chromium.base.Log;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.R;
import org.chromium.content.app.ChildProcessService;
import org.chromium.content.common.IChildProcessCallback;

@JNINamespace(value="content")
public class DownloadProcessService
extends ChildProcessService {
    private static final String TAG = "DownloadProcess";
    private long mClientContext;
    private IChildProcessCallback mCallback;
    private int mDownloadCount;

    @Override
    public void onCreate() {
        super.onCreate();
        this.startForeground(R.id.download_service_notification, new Notification());
    }

    @SuppressLint(value={"NewApi"})
    public int onStartCommand(Intent intent, int flags, int startId) {
        assert (Build.VERSION.SDK_INT >= 18);
        this.initializeParams(intent);
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            IBinder binder = bundle.getBinder("com.google.android.apps.chrome.extra.child_process_callback");
            this.mCallback = IChildProcessCallback.Stub.asInterface(binder);
            this.getServiceInfo(bundle);
        }
        return 1;
    }

    private void onDownloadStarted(boolean started, int downloadId) {
        if (this.mCallback != null) {
            try {
                this.mCallback.onDownloadStarted(started, downloadId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to callback the browser process.", new Object[]{e});
            }
        }
        if (started) {
            ++this.mDownloadCount;
        }
    }

    private void onDownloadCompleted(boolean success) {
        --this.mDownloadCount;
        if (this.mDownloadCount == 0) {
            this.stopSelf();
        }
    }
}

