/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.content.R;

@JNINamespace(value="content")
class MediaThrottler
implements MediaPlayer.OnErrorListener {
    private static final String TAG = "cr_MediaThrottler";
    private static final long UNKNOWN_LAST_SERVER_CRASH_TIME = -1L;
    private int mRequestCount;
    private final Context mContext;
    private MediaPlayer mPlayer;
    private long mLastCrashTime = -1L;
    private int mServerCrashCount;
    private final Object mLock = new Object();
    private Handler mHandler;
    private static final long SERVER_CRASH_INTERVAL_THRESHOLD_IN_MILLIS = 60000L;
    private static final int RELEASE_WATCH_DOG_PLAYER_DELAY_IN_MILLIS = 5000;
    private static final int SERVER_CRASH_COUNT_THRESHOLD_FOR_THROTTLING = 4;
    private final Runnable mDelayedReleaseRunnable = new Runnable(){

        @Override
        public void run() {
            new ReleaseWatchDogTask().execute(new Void[0]);
        }
    };

    @CalledByNative
    private static MediaThrottler create(Context context) {
        return new MediaThrottler(context);
    }

    private MediaThrottler(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean requestDecoderResources() {
        Object object = this.mLock;
        synchronized (object) {
            long currentTime = SystemClock.elapsedRealtime();
            if (this.mLastCrashTime != -1L && currentTime - this.mLastCrashTime < 60000L && this.mServerCrashCount >= 4) {
                Log.e(TAG, "Request to decode media data denied due to throttling.", new Object[0]);
                return false;
            }
            ++this.mRequestCount;
            if (this.mRequestCount == 1 || this.mPlayer == null) {
                this.mHandler.removeCallbacks(this.mDelayedReleaseRunnable);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        new StartWatchDogTask().execute(new Void[0]);
                    }
                });
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onDecodeRequestFinished() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mRequestCount;
            if (this.mRequestCount == 0) {
                this.prepareToStopWatchDog();
            }
        }
    }

    private void prepareToStopWatchDog() {
        this.mHandler.postDelayed(this.mDelayedReleaseRunnable, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onError(MediaPlayer mp, int what, int extra) {
        if (what == 100) {
            Object object = this.mLock;
            synchronized (object) {
                this.onMediaServerCrash();
            }
        }
        return true;
    }

    private void onMediaServerCrash() {
        assert (Thread.holdsLock(this.mLock));
        long currentTime = SystemClock.elapsedRealtime();
        if (this.mLastCrashTime != -1L && currentTime - this.mLastCrashTime < 60000L) {
            ++this.mServerCrashCount;
        } else {
            this.recordNumMediaServerCrashes();
            this.mServerCrashCount = 1;
        }
        this.mLastCrashTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.recordNumMediaServerCrashes();
            this.mServerCrashCount = 0;
            this.mLastCrashTime = -1L;
        }
    }

    private void recordNumMediaServerCrashes() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mServerCrashCount > 0) {
            RecordHistogram.recordCountHistogram("Media.Android.NumMediaServerCrashes", this.mServerCrashCount);
        }
    }

    private class StartWatchDogTask
    extends AsyncTask<Void, Void, Void> {
        private StartWatchDogTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... voids) {
            Object object = MediaThrottler.this.mLock;
            synchronized (object) {
                if (MediaThrottler.this.mPlayer != null || MediaThrottler.this.mRequestCount == 0) {
                    return null;
                }
                try {
                    MediaThrottler.this.mPlayer = MediaPlayer.create((Context)MediaThrottler.this.mContext, (int)R.raw.empty);
                }
                catch (IllegalStateException e) {
                    Log.e(MediaThrottler.TAG, "Exception happens while creating the watch dog player.", e);
                }
                catch (RuntimeException e) {
                    Log.e(MediaThrottler.TAG, "Exception happens while creating the watch dog player.", e);
                }
                if (MediaThrottler.this.mPlayer == null) {
                    Log.e(MediaThrottler.TAG, "Unable to create watch dog player, treat it as server crash.", new Object[0]);
                    MediaThrottler.this.onMediaServerCrash();
                } else {
                    MediaThrottler.this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)MediaThrottler.this);
                }
            }
            return null;
        }
    }

    private class ReleaseWatchDogTask
    extends AsyncTask<Void, Void, Void> {
        private ReleaseWatchDogTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... voids) {
            Object object = MediaThrottler.this.mLock;
            synchronized (object) {
                if (MediaThrottler.this.mRequestCount == 0 && MediaThrottler.this.mPlayer != null) {
                    MediaThrottler.this.mPlayer.release();
                    MediaThrottler.this.mPlayer = null;
                }
            }
            return null;
        }
    }
}

