/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.animation.AnimationUtils;
import org.chromium.base.Log;
import org.chromium.content.browser.ContentViewCore;

public class JoystickScrollProvider {
    private static final String TAG = "JoystickScroll";
    private static final float JOYSTICK_SCROLL_FACTOR_MULTIPLIER = 20.0f;
    private static final float JOYSTICK_SCROLL_DEADZONE = 0.2f;
    private static final float SCROLL_FACTOR_FALLBACK = 128.0f;
    private final ContentViewCore mView;
    private float mScrollVelocityX;
    private float mScrollVelocityY;
    private float mScrollFactor;
    private long mLastAnimateTimeMillis;
    private boolean mEnabled;
    private Runnable mScrollRunnable;

    public JoystickScrollProvider(ContentViewCore contentView) {
        this.mView = contentView;
        this.mEnabled = true;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        if (!enabled) {
            this.stop();
        }
    }

    public boolean onMotion(MotionEvent event) {
        if (!this.mEnabled) {
            return false;
        }
        if ((event.getSource() & 0x10) == 0) {
            return false;
        }
        Log.d(TAG, "Joystick left stick axis: " + event.getAxisValue(0) + "," + event.getAxisValue(1));
        this.computeNewScrollVelocity(event);
        if (this.mScrollVelocityX == 0.0f && this.mScrollVelocityY == 0.0f) {
            this.stop();
            return false;
        }
        if (this.mScrollRunnable == null) {
            this.mScrollRunnable = new Runnable(){

                @Override
                public void run() {
                    JoystickScrollProvider.this.animateScroll();
                }
            };
        }
        if (this.mLastAnimateTimeMillis == 0L) {
            this.mView.getContainerView().postOnAnimation(this.mScrollRunnable);
            this.mLastAnimateTimeMillis = AnimationUtils.currentAnimationTimeMillis();
        }
        return true;
    }

    private void animateScroll() {
        if (this.mLastAnimateTimeMillis == 0L) {
            return;
        }
        long timeMillis = AnimationUtils.currentAnimationTimeMillis();
        long dt = timeMillis - this.mLastAnimateTimeMillis;
        float dx = this.mScrollVelocityX * (float)dt / 1000.0f;
        float dy = this.mScrollVelocityY * (float)dt / 1000.0f;
        this.mView.scrollBy(dx, dy, true);
        this.mLastAnimateTimeMillis = timeMillis;
        this.mView.getContainerView().postOnAnimation(this.mScrollRunnable);
    }

    private void stop() {
        this.mLastAnimateTimeMillis = 0L;
    }

    private void computeNewScrollVelocity(MotionEvent event) {
        if (this.mScrollFactor == 0.0f) {
            TypedValue outValue = new TypedValue();
            if (!this.mView.getContext().getTheme().resolveAttribute(16842829, outValue, true)) {
                this.mScrollFactor = outValue.getDimension(this.mView.getContext().getResources().getDisplayMetrics());
            } else {
                Log.d(TAG, "Theme attribute listPreferredItemHeight not definedswitching to fallback scroll factor ");
                this.mScrollFactor = 128.0f * this.mView.getRenderCoordinates().getDeviceScaleFactor();
            }
        }
        this.mScrollVelocityX = this.getFilteredAxisValue(event, 0) * this.mScrollFactor * 20.0f;
        this.mScrollVelocityY = this.getFilteredAxisValue(event, 1) * this.mScrollFactor * 20.0f;
    }

    private float getFilteredAxisValue(MotionEvent event, int axis) {
        float axisValWithNoise = event.getAxisValue(axis);
        if (axisValWithNoise > 0.2f || axisValWithNoise < -0.2f) {
            return axisValWithNoise;
        }
        return 0.0f;
    }
}

