/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.view.MotionEvent;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.input.AnimationIntervalProvider;

public class JoystickZoomProvider {
    private static final String TAG = "JoystickZoomProvider";
    private static final float JOYSTICK_NOISE_THRESHOLD = 0.2f;
    private static final float ZOOM_SPEED = 1.65f;
    private long mLastAnimateTimeMillis;
    private float mZoomInVelocity;
    private float mZoomOutVelocity;
    protected final ContentViewCore mContentViewCore;
    protected float mDeviceScaleFactor;
    private int mZoomXcoord;
    private int mZoomYcoord;
    protected Runnable mZoomRunnable;
    private AnimationIntervalProvider mSystemAnimationIntervalProvider;

    public JoystickZoomProvider(ContentViewCore cvc, AnimationIntervalProvider animationTimeProvider) {
        this.mContentViewCore = cvc;
        this.mDeviceScaleFactor = this.mContentViewCore.getRenderCoordinates().getDeviceScaleFactor();
        this.mZoomXcoord = this.mContentViewCore.getViewportWidthPix() / 2;
        this.mZoomYcoord = this.mContentViewCore.getViewportHeightPix() / 2;
        this.mSystemAnimationIntervalProvider = animationTimeProvider;
    }

    public boolean onMotion(MotionEvent event) {
        if ((event.getSource() & 0x10) == 0) {
            return false;
        }
        this.computeNewZoomVelocity(event);
        if (this.mZoomInVelocity == 0.0f && this.mZoomOutVelocity == 0.0f) {
            this.stop();
            return false;
        }
        if (this.mZoomRunnable == null) {
            this.mZoomRunnable = new Runnable(){

                @Override
                public void run() {
                    JoystickZoomProvider.this.animateZoom();
                }
            };
        }
        if (this.mLastAnimateTimeMillis == 0L) {
            this.mLastAnimateTimeMillis = this.mSystemAnimationIntervalProvider.getLastAnimationFrameInterval();
            this.mContentViewCore.getContainerView().postOnAnimation(this.mZoomRunnable);
            this.mContentViewCore.pinchBegin(this.mZoomXcoord, this.mZoomYcoord);
        }
        return true;
    }

    protected void stop() {
        if (this.mLastAnimateTimeMillis != 0L) {
            this.mContentViewCore.pinchEnd();
            this.mLastAnimateTimeMillis = 0L;
        }
    }

    private void computeNewZoomVelocity(MotionEvent event) {
        this.mZoomInVelocity = this.getFilteredAxisValue(event, 18);
        this.mZoomOutVelocity = this.getFilteredAxisValue(event, 17);
    }

    protected void animateZoom() {
        if (!this.mContentViewCore.getContainerView().hasFocus()) {
            this.stop();
            return;
        }
        if (this.mLastAnimateTimeMillis == 0L) {
            return;
        }
        long timeMillis = this.mSystemAnimationIntervalProvider.getLastAnimationFrameInterval();
        long dt = timeMillis - this.mLastAnimateTimeMillis;
        float zoomFactor = (float)Math.pow(1.65f, this.mDeviceScaleFactor * (this.mZoomInVelocity - this.mZoomOutVelocity) * (float)dt / 1000.0f);
        this.mContentViewCore.pinchBy(this.mZoomXcoord, this.mZoomYcoord, zoomFactor);
        this.mLastAnimateTimeMillis = timeMillis;
        this.mContentViewCore.getContainerView().postOnAnimation(this.mZoomRunnable);
    }

    private float getFilteredAxisValue(MotionEvent event, int axis) {
        float axisValWithNoise = event.getAxisValue(axis);
        return axisValWithNoise > 0.2f ? axisValWithNoise : 0.0f;
    }
}

