/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.widget.PopupWindow;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ContainerViewObserver;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.PositionObserver;
import org.chromium.content.browser.ViewPositionObserver;
import org.chromium.content.browser.input.HandleViewResources;
import org.chromium.content_public.browser.GestureStateListener;

@JNINamespace(value="content")
public class PopupTouchHandleDrawable
extends View {
    private final PopupWindow mContainer;
    private final PositionObserver.Listener mParentPositionListener;
    private final ContainerViewObserver mParentViewObserver;
    private ContentViewCore mContentViewCore;
    private PositionObserver mParentPositionObserver;
    private Drawable mDrawable;
    private int mPositionX;
    private int mPositionY;
    private int mParentPositionX;
    private int mParentPositionY;
    private boolean mMirrorHorizontal;
    private boolean mMirrorVertical;
    private float mAlpha;
    private final int[] mTempScreenCoords = new int[2];
    private int mOrientation = 3;
    private static final int MOVING_FADE_IN_DELAY_MS = 300;
    private static final int FADE_IN_DURATION_MS = 200;
    private Runnable mDeferredHandleFadeInRunnable;
    private long mFadeStartTime;
    private Runnable mTemporarilyHiddenExpiredRunnable;
    private long mTemporarilyHiddenExpireTime;
    private boolean mVisible;
    private boolean mScrolling;
    private boolean mFocused;
    private boolean mTemporarilyHidden;
    private boolean mAttachedToWindow;
    private boolean mWasShowingAllowed;
    private final GestureStateListener mGestureStateListener;
    private boolean mDelayVisibilityUpdateWAR;
    private Runnable mInvalidationRunnable;
    private boolean mHasPendingInvalidate;

    private PopupTouchHandleDrawable(ContentViewCore contentViewCore) {
        super(contentViewCore.getContainerView().getContext());
        this.mContentViewCore = contentViewCore;
        this.mContainer = new PopupWindow((Context)this.mContentViewCore.getWindowAndroid().getContext().get(), null, 16843464);
        this.mContainer.setSplitTouchEnabled(true);
        this.mContainer.setClippingEnabled(false);
        this.mContainer.setAnimationStyle(0);
        PopupTouchHandleDrawable.setWindowLayoutType(this.mContainer, 1002);
        this.mContainer.setWidth(-2);
        this.mContainer.setHeight(-2);
        this.mAlpha = 1.0f;
        this.mVisible = this.getVisibility() == 0;
        this.mFocused = this.mContentViewCore.getContainerView().hasWindowFocus();
        this.mParentPositionObserver = new ViewPositionObserver((View)this.mContentViewCore.getContainerView());
        this.mParentPositionListener = new PositionObserver.Listener(){

            @Override
            public void onPositionChanged(int x, int y) {
                PopupTouchHandleDrawable.this.updateParentPosition(x, y);
            }
        };
        this.mParentViewObserver = new ContainerViewObserver(){

            @Override
            public void onContainerViewChanged(ViewGroup newContainerView) {
                PopupTouchHandleDrawable.this.mParentPositionObserver.clearListener();
                PopupTouchHandleDrawable.this.mParentPositionObserver = new ViewPositionObserver((View)newContainerView);
                if (PopupTouchHandleDrawable.this.mContainer.isShowing()) {
                    PopupTouchHandleDrawable.this.mParentPositionObserver.addListener(PopupTouchHandleDrawable.this.mParentPositionListener);
                }
            }
        };
        this.mGestureStateListener = new GestureStateListener(){

            @Override
            public void onScrollStarted(int scrollOffsetX, int scrollOffsetY) {
                PopupTouchHandleDrawable.this.setIsScrolling(true);
            }

            @Override
            public void onScrollEnded(int scrollOffsetX, int scrollOffsetY) {
                PopupTouchHandleDrawable.this.setIsScrolling(false);
            }

            @Override
            public void onFlingStartGesture(int vx, int vy, int scrollOffsetY, int scrollExtentY) {
                PopupTouchHandleDrawable.this.setIsScrolling(false);
            }

            @Override
            public void onScrollOffsetOrExtentChanged(int scrollOffsetY, int scrollExtentY) {
                PopupTouchHandleDrawable.this.temporarilyHide();
            }

            @Override
            public void onWindowFocusChanged(boolean hasWindowFocus) {
                PopupTouchHandleDrawable.this.setIsFocused(hasWindowFocus);
            }

            @Override
            public void onDestroyed() {
                PopupTouchHandleDrawable.this.destroy();
            }
        };
        this.mContentViewCore.addGestureStateListener(this.mGestureStateListener);
        this.mContentViewCore.addContainerViewObserver(this.mParentViewObserver);
    }

    private static void setWindowLayoutType(PopupWindow window, int layoutType) {
        if (Build.VERSION.SDK_INT >= 23) {
            window.setWindowLayoutType(layoutType);
            return;
        }
        try {
            Method setWindowLayoutTypeMethod = PopupWindow.class.getMethod("setWindowLayoutType", Integer.TYPE);
            setWindowLayoutTypeMethod.invoke((Object)window, layoutType);
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static Drawable getHandleDrawable(Context context, int orientation) {
        switch (orientation) {
            case 0: {
                return HandleViewResources.getLeftHandleDrawable(context);
            }
            case 2: {
                return HandleViewResources.getRightHandleDrawable(context);
            }
            case 1: {
                return HandleViewResources.getCenterHandleDrawable(context);
            }
        }
        assert (false);
        return HandleViewResources.getCenterHandleDrawable(context);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mContentViewCore == null) {
            return false;
        }
        this.mContentViewCore.getContainerView().getLocationOnScreen(this.mTempScreenCoords);
        float offsetX = event.getRawX() - event.getX() - (float)this.mTempScreenCoords[0];
        float offsetY = event.getRawY() - event.getY() - (float)this.mTempScreenCoords[1];
        MotionEvent offsetEvent = MotionEvent.obtainNoHistory((MotionEvent)event);
        offsetEvent.offsetLocation(offsetX, offsetY);
        boolean handled = this.mContentViewCore.onTouchHandleEvent(offsetEvent);
        offsetEvent.recycle();
        return handled;
    }

    @CalledByNative
    private static PopupTouchHandleDrawable create(ContentViewCore contentViewCore) {
        return new PopupTouchHandleDrawable(contentViewCore);
    }

    @CalledByNative
    private void setOrientation(int orientation, boolean mirrorVertical, boolean mirrorHorizontal) {
        assert (orientation >= 0 && orientation <= 3);
        boolean orientationChanged = this.mOrientation != orientation;
        boolean mirroringChanged = this.mMirrorHorizontal != mirrorHorizontal || this.mMirrorVertical != mirrorVertical;
        this.mOrientation = orientation;
        this.mMirrorHorizontal = mirrorHorizontal;
        this.mMirrorVertical = mirrorVertical;
        if (orientationChanged) {
            this.mDrawable = PopupTouchHandleDrawable.getHandleDrawable(this.getContext(), this.mOrientation);
        }
        if (this.mDrawable != null) {
            this.mDrawable.setAlpha((int)(255.0f * this.mAlpha));
        }
        if (orientationChanged || mirroringChanged) {
            this.scheduleInvalidate();
        }
    }

    private void updateParentPosition(int parentPositionX, int parentPositionY) {
        if (this.mParentPositionX == parentPositionX && this.mParentPositionY == parentPositionY) {
            return;
        }
        this.mParentPositionX = parentPositionX;
        this.mParentPositionY = parentPositionY;
        this.temporarilyHide();
    }

    private int getContainerPositionX() {
        return this.mParentPositionX + this.mPositionX;
    }

    private int getContainerPositionY() {
        return this.mParentPositionY + this.mPositionY;
    }

    private void updatePosition() {
        this.mContainer.update(this.getContainerPositionX(), this.getContainerPositionY(), this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
    }

    private boolean isShowingAllowed() {
        return this.mAttachedToWindow && this.mVisible && this.mFocused && !this.mScrolling && !this.mTemporarilyHidden;
    }

    private void updateVisibility() {
        int newVisibility;
        int n = newVisibility = this.isShowingAllowed() ? 0 : 4;
        if (newVisibility == 0 && this.getVisibility() != 0 && !this.mDelayVisibilityUpdateWAR) {
            this.mDelayVisibilityUpdateWAR = true;
            this.scheduleInvalidate();
            return;
        }
        this.mDelayVisibilityUpdateWAR = false;
        this.setVisibility(newVisibility);
    }

    private void setIsScrolling(boolean scrolling) {
        if (this.mScrolling == scrolling) {
            return;
        }
        this.mScrolling = scrolling;
        this.onVisibilityInputChanged();
    }

    private void setIsFocused(boolean focused) {
        if (this.mFocused == focused) {
            return;
        }
        this.mFocused = focused;
        this.onVisibilityInputChanged();
    }

    private void setTemporarilyHidden(boolean hidden) {
        if (this.mTemporarilyHidden == hidden) {
            return;
        }
        this.mTemporarilyHidden = hidden;
        if (this.mTemporarilyHidden) {
            if (this.mTemporarilyHiddenExpiredRunnable == null) {
                this.mTemporarilyHiddenExpiredRunnable = new Runnable(){

                    @Override
                    public void run() {
                        PopupTouchHandleDrawable.this.setTemporarilyHidden(false);
                    }
                };
            }
            this.removeCallbacks(this.mTemporarilyHiddenExpiredRunnable);
            long now = SystemClock.uptimeMillis();
            long delay = Math.max(0L, this.mTemporarilyHiddenExpireTime - now);
            this.postDelayed(this.mTemporarilyHiddenExpiredRunnable, delay);
        } else if (this.mTemporarilyHiddenExpiredRunnable != null) {
            this.removeCallbacks(this.mTemporarilyHiddenExpiredRunnable);
        }
        this.onVisibilityInputChanged();
    }

    private void onVisibilityInputChanged() {
        if (!this.mContainer.isShowing()) {
            return;
        }
        boolean allowed = this.isShowingAllowed();
        if (this.mWasShowingAllowed == allowed) {
            return;
        }
        this.mWasShowingAllowed = allowed;
        this.cancelFadeIn();
        if (allowed) {
            if (this.mDeferredHandleFadeInRunnable == null) {
                this.mDeferredHandleFadeInRunnable = new Runnable(){

                    @Override
                    public void run() {
                        PopupTouchHandleDrawable.this.beginFadeIn();
                    }
                };
            }
            this.postOnAnimation(this.mDeferredHandleFadeInRunnable);
        } else {
            this.updateVisibility();
        }
    }

    private void updateAlpha() {
        if (this.mAlpha == 1.0f) {
            return;
        }
        long currentTimeMillis = AnimationUtils.currentAnimationTimeMillis();
        this.mAlpha = Math.min(1.0f, (float)(currentTimeMillis - this.mFadeStartTime) / 200.0f);
        this.mDrawable.setAlpha((int)(255.0f * this.mAlpha));
        this.scheduleInvalidate();
    }

    private void temporarilyHide() {
        if (!this.mContainer.isShowing()) {
            return;
        }
        this.mTemporarilyHiddenExpireTime = SystemClock.uptimeMillis() + 300L;
        this.setTemporarilyHidden(true);
    }

    private void doInvalidate() {
        if (!this.mContainer.isShowing()) {
            return;
        }
        this.updateVisibility();
        this.updatePosition();
        this.invalidate();
    }

    private void scheduleInvalidate() {
        if (this.mInvalidationRunnable == null) {
            this.mInvalidationRunnable = new Runnable(){

                @Override
                public void run() {
                    PopupTouchHandleDrawable.this.mHasPendingInvalidate = false;
                    PopupTouchHandleDrawable.this.doInvalidate();
                }
            };
        }
        if (this.mHasPendingInvalidate) {
            return;
        }
        this.mHasPendingInvalidate = true;
        this.postOnAnimation(this.mInvalidationRunnable);
    }

    private void cancelFadeIn() {
        if (this.mDeferredHandleFadeInRunnable == null) {
            return;
        }
        this.removeCallbacks(this.mDeferredHandleFadeInRunnable);
    }

    private void beginFadeIn() {
        if (this.getVisibility() == 0) {
            return;
        }
        this.mAlpha = 0.0f;
        this.mFadeStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.doInvalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mDrawable == null) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        this.setMeasuredDimension(this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
    }

    protected void onDraw(Canvas c) {
        boolean needsMirror;
        if (this.mDrawable == null) {
            return;
        }
        boolean bl = needsMirror = this.mMirrorHorizontal || this.mMirrorVertical;
        if (needsMirror) {
            c.save();
            float scaleX = this.mMirrorHorizontal ? -1.0f : 1.0f;
            float scaleY = this.mMirrorVertical ? -1.0f : 1.0f;
            c.scale(scaleX, scaleY, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        }
        this.updateAlpha();
        this.mDrawable.setBounds(0, 0, this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
        this.mDrawable.draw(c);
        if (needsMirror) {
            c.restore();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.onVisibilityInputChanged();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachedToWindow = false;
        this.onVisibilityInputChanged();
    }

    @CalledByNative
    private void destroy() {
        if (this.mContentViewCore == null) {
            return;
        }
        this.hide();
        this.mContentViewCore.removeGestureStateListener(this.mGestureStateListener);
        this.mContentViewCore.removeContainerViewObserver(this.mParentViewObserver);
        this.mContentViewCore = null;
    }

    @CalledByNative
    private void show() {
        if (this.mContentViewCore == null) {
            return;
        }
        if (this.mContainer.isShowing()) {
            return;
        }
        this.updateParentPosition(this.mParentPositionObserver.getPositionX(), this.mParentPositionObserver.getPositionY());
        this.mParentPositionObserver.addListener(this.mParentPositionListener);
        this.mContainer.setContentView((View)this);
        try {
            this.mContainer.showAtLocation((View)this.mContentViewCore.getContainerView(), 0, this.getContainerPositionX(), this.getContainerPositionY());
        }
        catch (WindowManager.BadTokenException e) {
            this.hide();
        }
    }

    @CalledByNative
    private void hide() {
        this.mTemporarilyHiddenExpireTime = 0L;
        this.setTemporarilyHidden(false);
        this.mAlpha = 1.0f;
        if (this.mContainer.isShowing()) {
            try {
                this.mContainer.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mParentPositionObserver.clearListener();
    }

    @CalledByNative
    private void setOrigin(float originX, float originY) {
        if ((float)this.mPositionX == originX && (float)this.mPositionY == originY) {
            return;
        }
        this.mPositionX = (int)originX;
        this.mPositionY = (int)originY;
        if (this.getVisibility() == 0) {
            this.scheduleInvalidate();
        }
    }

    @CalledByNative
    private void setVisible(boolean visible) {
        if (this.mVisible == visible) {
            return;
        }
        this.mVisible = visible;
        this.onVisibilityInputChanged();
    }

    @CalledByNative
    private int getPositionX() {
        return this.mPositionX;
    }

    @CalledByNative
    private float getHandleHorizontalPaddingRatio() {
        return HandleViewResources.getHandleHorizontalPaddingRatio();
    }

    @CalledByNative
    private int getPositionY() {
        return this.mPositionY;
    }

    @CalledByNative
    private int getVisibleWidth() {
        if (this.mDrawable == null) {
            return 0;
        }
        return this.mDrawable.getIntrinsicWidth();
    }

    @CalledByNative
    private int getVisibleHeight() {
        if (this.mDrawable == null) {
            return 0;
        }
        return this.mDrawable.getIntrinsicHeight();
    }
}

