/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.webcontents;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.webcontents.WebContentsObserverProxy;
import org.chromium.content_public.browser.AccessibilitySnapshotCallback;
import org.chromium.content_public.browser.AccessibilitySnapshotNode;
import org.chromium.content_public.browser.ContentBitmapCallback;
import org.chromium.content_public.browser.ImageDownloadCallback;
import org.chromium.content_public.browser.JavaScriptCallback;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.WebContents;
import org.chromium.content_public.browser.WebContentsObserver;

@JNINamespace(value="content")
class WebContentsImpl
implements WebContents {
    private static final String PARCEL_VERSION_KEY = "version";
    private static final String PARCEL_WEBCONTENTS_KEY = "webcontents";
    private static final String PARCEL_PROCESS_GUARD_KEY = "processguard";
    private static final long PARCELABLE_VERSION_ID = 0L;
    private static UUID sParcelableUUID = UUID.randomUUID();
    public static final Parcelable.Creator<WebContents> CREATOR = new Parcelable.Creator<WebContents>(){

        public WebContents createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle();
            if (bundle.getLong(WebContentsImpl.PARCEL_VERSION_KEY, -1L) != 0L) {
                return null;
            }
            ParcelUuid parcelUuid = (ParcelUuid)bundle.getParcelable(WebContentsImpl.PARCEL_PROCESS_GUARD_KEY);
            if (sParcelableUUID.compareTo(parcelUuid.getUuid()) != 0) {
                return null;
            }
            return WebContentsImpl.nativeFromNativePtr(bundle.getLong(WebContentsImpl.PARCEL_WEBCONTENTS_KEY));
        }

        public WebContents[] newArray(int size) {
            return new WebContents[size];
        }
    };
    private long mNativeWebContentsAndroid;
    private NavigationController mNavigationController;
    private WebContentsObserverProxy mObserverProxy;
    private boolean mContextMenuOpened;

    @VisibleForTesting
    public static void invalidateSerializedWebContentsForTesting() {
        sParcelableUUID = UUID.randomUUID();
    }

    private WebContentsImpl(long nativeWebContentsAndroid, NavigationController navigationController) {
        this.mNativeWebContentsAndroid = nativeWebContentsAndroid;
        this.mNavigationController = navigationController;
    }

    @CalledByNative
    private static WebContentsImpl create(long nativeWebContentsAndroid, NavigationController navigationController) {
        return new WebContentsImpl(nativeWebContentsAndroid, navigationController);
    }

    @CalledByNative
    private void clearNativePtr() {
        this.mNativeWebContentsAndroid = 0L;
        this.mNavigationController = null;
        if (this.mObserverProxy != null) {
            this.mObserverProxy.destroy();
            this.mObserverProxy = null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle data = new Bundle();
        data.putLong(PARCEL_VERSION_KEY, 0L);
        data.putParcelable(PARCEL_PROCESS_GUARD_KEY, (Parcelable)new ParcelUuid(sParcelableUUID));
        data.putLong(PARCEL_WEBCONTENTS_KEY, this.mNativeWebContentsAndroid);
        dest.writeBundle(data);
    }

    @CalledByNative
    private long getNativePointer() {
        return this.mNativeWebContentsAndroid;
    }

    @Override
    public void destroy() {
        if (!ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Attempting to destroy WebContents on non-UI thread");
        }
        if (this.mNativeWebContentsAndroid != 0L) {
            WebContentsImpl.nativeDestroyWebContents(this.mNativeWebContentsAndroid);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.mNativeWebContentsAndroid == 0L;
    }

    @Override
    public NavigationController getNavigationController() {
        return this.mNavigationController;
    }

    @Override
    public String getTitle() {
        return this.nativeGetTitle(this.mNativeWebContentsAndroid);
    }

    @Override
    public String getVisibleUrl() {
        return this.nativeGetVisibleURL(this.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isLoading() {
        return this.nativeIsLoading(this.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isLoadingToDifferentDocument() {
        return this.nativeIsLoadingToDifferentDocument(this.mNativeWebContentsAndroid);
    }

    @Override
    public void stop() {
        this.nativeStop(this.mNativeWebContentsAndroid);
    }

    @Override
    public void cut() {
        this.nativeCut(this.mNativeWebContentsAndroid);
    }

    @Override
    public void copy() {
        this.nativeCopy(this.mNativeWebContentsAndroid);
    }

    @Override
    public void paste() {
        this.nativePaste(this.mNativeWebContentsAndroid);
    }

    @Override
    public void replace(String word) {
        this.nativeReplace(this.mNativeWebContentsAndroid, word);
    }

    @Override
    public void selectAll() {
        this.nativeSelectAll(this.mNativeWebContentsAndroid);
    }

    @Override
    public void unselect() {
        if (this.isDestroyed()) {
            return;
        }
        this.nativeUnselect(this.mNativeWebContentsAndroid);
    }

    @Override
    public void insertCSS(String css) {
        if (this.isDestroyed()) {
            return;
        }
        this.nativeInsertCSS(this.mNativeWebContentsAndroid, css);
    }

    @Override
    public void onHide() {
        this.nativeOnHide(this.mNativeWebContentsAndroid);
    }

    @Override
    public void onShow() {
        this.nativeOnShow(this.mNativeWebContentsAndroid);
    }

    @Override
    public void suspendAllMediaPlayers() {
        this.nativeSuspendAllMediaPlayers(this.mNativeWebContentsAndroid);
    }

    @Override
    public void setAudioMuted(boolean mute) {
        this.nativeSetAudioMuted(this.mNativeWebContentsAndroid, mute);
    }

    @Override
    public int getBackgroundColor() {
        return this.nativeGetBackgroundColor(this.mNativeWebContentsAndroid);
    }

    @Override
    public void showInterstitialPage(String url, long interstitialPageDelegateAndroid) {
        this.nativeShowInterstitialPage(this.mNativeWebContentsAndroid, url, interstitialPageDelegateAndroid);
    }

    @Override
    public boolean isShowingInterstitialPage() {
        return this.nativeIsShowingInterstitialPage(this.mNativeWebContentsAndroid);
    }

    @Override
    public boolean focusLocationBarByDefault() {
        return this.nativeFocusLocationBarByDefault(this.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isReady() {
        return this.nativeIsRenderWidgetHostViewReady(this.mNativeWebContentsAndroid);
    }

    @Override
    public void exitFullscreen() {
        this.nativeExitFullscreen(this.mNativeWebContentsAndroid);
    }

    @Override
    public void updateTopControlsState(boolean enableHiding, boolean enableShowing, boolean animate) {
        this.nativeUpdateTopControlsState(this.mNativeWebContentsAndroid, enableHiding, enableShowing, animate);
    }

    @Override
    public void showImeIfNeeded() {
        this.nativeShowImeIfNeeded(this.mNativeWebContentsAndroid);
    }

    @Override
    public void scrollFocusedEditableNodeIntoView() {
        this.nativeScrollFocusedEditableNodeIntoView(this.mNativeWebContentsAndroid);
    }

    @Override
    public void selectWordAroundCaret() {
        this.nativeSelectWordAroundCaret(this.mNativeWebContentsAndroid);
    }

    @Override
    public void adjustSelectionByCharacterOffset(int startAdjust, int endAdjust) {
        this.nativeAdjustSelectionByCharacterOffset(this.mNativeWebContentsAndroid, startAdjust, endAdjust);
    }

    @Override
    public String getUrl() {
        if (this.isDestroyed()) {
            return null;
        }
        return this.nativeGetURL(this.mNativeWebContentsAndroid);
    }

    @Override
    public String getLastCommittedUrl() {
        return this.nativeGetLastCommittedURL(this.mNativeWebContentsAndroid);
    }

    @Override
    public boolean isIncognito() {
        return this.nativeIsIncognito(this.mNativeWebContentsAndroid);
    }

    @Override
    public void resumeLoadingCreatedWebContents() {
        this.nativeResumeLoadingCreatedWebContents(this.mNativeWebContentsAndroid);
    }

    @Override
    public void evaluateJavaScript(String script, JavaScriptCallback callback) {
        if (this.isDestroyed() || script == null) {
            return;
        }
        this.nativeEvaluateJavaScript(this.mNativeWebContentsAndroid, script, callback);
    }

    @Override
    @VisibleForTesting
    public void evaluateJavaScriptForTests(String script, JavaScriptCallback callback) {
        if (script == null) {
            return;
        }
        this.nativeEvaluateJavaScriptForTests(this.mNativeWebContentsAndroid, script, callback);
    }

    @Override
    public void addMessageToDevToolsConsole(int level, String message) {
        this.nativeAddMessageToDevToolsConsole(this.mNativeWebContentsAndroid, level, message);
    }

    @Override
    public void sendMessageToFrame(String frameName, String message, String targetOrigin) {
        this.nativeSendMessageToFrame(this.mNativeWebContentsAndroid, frameName, message, targetOrigin);
    }

    @Override
    public boolean hasAccessedInitialDocument() {
        return this.nativeHasAccessedInitialDocument(this.mNativeWebContentsAndroid);
    }

    @CalledByNative
    private static void onEvaluateJavaScriptResult(String jsonResult, JavaScriptCallback callback) {
        callback.handleJavaScriptResult(jsonResult);
    }

    @Override
    public int getThemeColor() {
        return this.nativeGetThemeColor(this.mNativeWebContentsAndroid);
    }

    @Override
    public void requestAccessibilitySnapshot(AccessibilitySnapshotCallback callback) {
        this.nativeRequestAccessibilitySnapshot(this.mNativeWebContentsAndroid, callback);
    }

    @Override
    public void resumeMediaSession() {
        this.nativeResumeMediaSession(this.mNativeWebContentsAndroid);
    }

    @Override
    public void suspendMediaSession() {
        this.nativeSuspendMediaSession(this.mNativeWebContentsAndroid);
    }

    @Override
    public void stopMediaSession() {
        this.nativeStopMediaSession(this.mNativeWebContentsAndroid);
    }

    @Override
    public String getEncoding() {
        return this.nativeGetEncoding(this.mNativeWebContentsAndroid);
    }

    @CalledByNative
    private static void onAccessibilitySnapshot(AccessibilitySnapshotNode root, AccessibilitySnapshotCallback callback) {
        callback.onAccessibilitySnapshot(root);
    }

    @CalledByNative
    private static void addAccessibilityNodeAsChild(AccessibilitySnapshotNode parent, AccessibilitySnapshotNode child) {
        parent.addChild(child);
    }

    @CalledByNative
    private static AccessibilitySnapshotNode createAccessibilitySnapshotNode(int parentRelativeLeft, int parentRelativeTop, int width, int height, boolean isRootNode, String text, int color2, int bgcolor, float size, int textStyle, String className) {
        AccessibilitySnapshotNode node = new AccessibilitySnapshotNode(text, className);
        if ((double)size >= 0.0) {
            boolean bold = (textStyle & 1) > 0;
            boolean italic = (textStyle & 2) > 0;
            boolean underline = (textStyle & 4) > 0;
            boolean lineThrough = (textStyle & 8) > 0;
            node.setStyle(color2, bgcolor, size, bold, italic, underline, lineThrough);
        }
        node.setLocationInfo(parentRelativeLeft, parentRelativeTop, width, height, isRootNode);
        return node;
    }

    @CalledByNative
    private static void setAccessibilitySnapshotSelection(AccessibilitySnapshotNode node, int start, int end) {
        node.setSelection(start, end);
    }

    @Override
    public void addObserver(WebContentsObserver observer) {
        assert (this.mNativeWebContentsAndroid != 0L);
        if (this.mObserverProxy == null) {
            this.mObserverProxy = new WebContentsObserverProxy(this);
        }
        this.mObserverProxy.addObserver(observer);
    }

    @Override
    public void removeObserver(WebContentsObserver observer) {
        if (this.mObserverProxy == null) {
            return;
        }
        this.mObserverProxy.removeObserver(observer);
    }

    @Override
    @VisibleForTesting
    public ObserverList.RewindableIterator<WebContentsObserver> getObserversForTesting() {
        return this.mObserverProxy.getObserversForTesting();
    }

    @Override
    public void getContentBitmapAsync(Bitmap.Config config, float scale, Rect srcRect, ContentBitmapCallback callback) {
        this.nativeGetContentBitmap(this.mNativeWebContentsAndroid, callback, config, scale, srcRect.left, srcRect.top, srcRect.width(), srcRect.height());
    }

    @Override
    public void onContextMenuOpened() {
        this.mContextMenuOpened = true;
    }

    @Override
    public void onContextMenuClosed() {
        if (!this.mContextMenuOpened) {
            return;
        }
        this.mContextMenuOpened = false;
        if (this.mNativeWebContentsAndroid != 0L) {
            this.nativeOnContextMenuClosed(this.mNativeWebContentsAndroid);
        }
    }

    @CalledByNative
    private void onGetContentBitmapFinished(ContentBitmapCallback callback, Bitmap bitmap, int response) {
        callback.onFinishGetBitmap(bitmap, response);
    }

    @Override
    public void reloadLoFiImages() {
        this.nativeReloadLoFiImages(this.mNativeWebContentsAndroid);
    }

    @Override
    public int downloadImage(String url, boolean isFavicon, int maxBitmapSize, boolean bypassCache, ImageDownloadCallback callback) {
        return this.nativeDownloadImage(this.mNativeWebContentsAndroid, url, isFavicon, maxBitmapSize, bypassCache, callback);
    }

    @CalledByNative
    private void onDownloadImageFinished(ImageDownloadCallback callback, int id2, int httpStatusCode, String imageUrl, List<Bitmap> bitmaps, List<Rect> sizes) {
        callback.onFinishDownloadImage(id2, httpStatusCode, imageUrl, bitmaps, sizes);
    }

    @CalledByNative
    private static List<Bitmap> createBitmapList() {
        return new ArrayList<Bitmap>();
    }

    @CalledByNative
    private static void addToBitmapList(List<Bitmap> bitmaps, Bitmap bitmap) {
        bitmaps.add(bitmap);
    }

    @CalledByNative
    private static List<Rect> createSizeList() {
        return new ArrayList<Rect>();
    }

    @CalledByNative
    private static void createSizeAndAddToList(List<Rect> sizes, int width, int height) {
        sizes.add(new Rect(0, 0, width, height));
    }

    private static native void nativeDestroyWebContents(long var0);

    private static native WebContents nativeFromNativePtr(long var0);

    private native String nativeGetTitle(long var1);

    private native String nativeGetVisibleURL(long var1);

    private native boolean nativeIsLoading(long var1);

    private native boolean nativeIsLoadingToDifferentDocument(long var1);

    private native void nativeStop(long var1);

    private native void nativeCut(long var1);

    private native void nativeCopy(long var1);

    private native void nativePaste(long var1);

    private native void nativeReplace(long var1, String var3);

    private native void nativeSelectAll(long var1);

    private native void nativeUnselect(long var1);

    private native void nativeInsertCSS(long var1, String var3);

    private native void nativeOnHide(long var1);

    private native void nativeOnShow(long var1);

    private native void nativeSuspendAllMediaPlayers(long var1);

    private native void nativeSetAudioMuted(long var1, boolean var3);

    private native int nativeGetBackgroundColor(long var1);

    private native void nativeShowInterstitialPage(long var1, String var3, long var4);

    private native boolean nativeIsShowingInterstitialPage(long var1);

    private native boolean nativeFocusLocationBarByDefault(long var1);

    private native boolean nativeIsRenderWidgetHostViewReady(long var1);

    private native void nativeExitFullscreen(long var1);

    private native void nativeUpdateTopControlsState(long var1, boolean var3, boolean var4, boolean var5);

    private native void nativeShowImeIfNeeded(long var1);

    private native void nativeScrollFocusedEditableNodeIntoView(long var1);

    private native void nativeSelectWordAroundCaret(long var1);

    private native void nativeAdjustSelectionByCharacterOffset(long var1, int var3, int var4);

    private native String nativeGetURL(long var1);

    private native String nativeGetLastCommittedURL(long var1);

    private native boolean nativeIsIncognito(long var1);

    private native void nativeResumeLoadingCreatedWebContents(long var1);

    private native void nativeEvaluateJavaScript(long var1, String var3, JavaScriptCallback var4);

    private native void nativeEvaluateJavaScriptForTests(long var1, String var3, JavaScriptCallback var4);

    private native void nativeAddMessageToDevToolsConsole(long var1, int var3, String var4);

    private native void nativeSendMessageToFrame(long var1, String var3, String var4, String var5);

    private native boolean nativeHasAccessedInitialDocument(long var1);

    private native int nativeGetThemeColor(long var1);

    private native void nativeRequestAccessibilitySnapshot(long var1, AccessibilitySnapshotCallback var3);

    private native void nativeResumeMediaSession(long var1);

    private native void nativeSuspendMediaSession(long var1);

    private native void nativeStopMediaSession(long var1);

    private native String nativeGetEncoding(long var1);

    private native void nativeGetContentBitmap(long var1, ContentBitmapCallback var3, Bitmap.Config var4, float var5, float var6, float var7, float var8, float var9);

    private native void nativeOnContextMenuClosed(long var1);

    private native void nativeReloadLoFiImages(long var1);

    private native int nativeDownloadImage(long var1, String var3, boolean var4, int var5, boolean var6, ImageDownloadCallback var7);
}

