/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.bluetooth;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.ParcelUuid;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.bluetooth.ChromeBluetoothRemoteGattCharacteristic;
import org.chromium.device.bluetooth.ChromeBluetoothRemoteGattDescriptor;
import org.chromium.device.bluetooth.Wrappers;

@JNINamespace(value="device")
@TargetApi(value=21)
final class ChromeBluetoothDevice {
    private static final String TAG = "Bluetooth";
    private long mNativeBluetoothDeviceAndroid;
    final Wrappers.BluetoothDeviceWrapper mDevice;
    private HashSet<String> mUuidsFromScan;
    Wrappers.BluetoothGattWrapper mBluetoothGatt;
    private final BluetoothGattCallbackImpl mBluetoothGattCallbackImpl;
    final HashMap<Wrappers.BluetoothGattCharacteristicWrapper, ChromeBluetoothRemoteGattCharacteristic> mWrapperToChromeCharacteristicsMap;
    final HashMap<Wrappers.BluetoothGattDescriptorWrapper, ChromeBluetoothRemoteGattDescriptor> mWrapperToChromeDescriptorsMap;

    private ChromeBluetoothDevice(long nativeBluetoothDeviceAndroid, Wrappers.BluetoothDeviceWrapper deviceWrapper) {
        this.mNativeBluetoothDeviceAndroid = nativeBluetoothDeviceAndroid;
        this.mDevice = deviceWrapper;
        this.mUuidsFromScan = new HashSet();
        this.mBluetoothGattCallbackImpl = new BluetoothGattCallbackImpl();
        this.mWrapperToChromeCharacteristicsMap = new HashMap();
        this.mWrapperToChromeDescriptorsMap = new HashMap();
        Log.v(TAG, "ChromeBluetoothDevice created.");
    }

    @CalledByNative
    private void onBluetoothDeviceAndroidDestruction() {
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.close();
            this.mBluetoothGatt = null;
        }
        this.mNativeBluetoothDeviceAndroid = 0L;
    }

    @CalledByNative
    private static ChromeBluetoothDevice create(long nativeBluetoothDeviceAndroid, Object deviceWrapper) {
        return new ChromeBluetoothDevice(nativeBluetoothDeviceAndroid, (Wrappers.BluetoothDeviceWrapper)deviceWrapper);
    }

    @CalledByNative
    private boolean updateAdvertisedUUIDs(List<ParcelUuid> uuidsFromScan) {
        if (uuidsFromScan == null) {
            return false;
        }
        boolean uuidsUpdated = false;
        for (ParcelUuid uuid : uuidsFromScan) {
            uuidsUpdated |= this.mUuidsFromScan.add(uuid.toString());
        }
        return uuidsUpdated;
    }

    @CalledByNative
    private int getBluetoothClass() {
        return this.mDevice.getBluetoothClass_getDeviceClass();
    }

    @CalledByNative
    private String getAddress() {
        return this.mDevice.getAddress();
    }

    @CalledByNative
    private boolean isPaired() {
        return this.mDevice.getBondState() == 12;
    }

    @CalledByNative
    private String[] getUuids() {
        return this.mUuidsFromScan.toArray(new String[this.mUuidsFromScan.size()]);
    }

    @CalledByNative
    private void createGattConnectionImpl(Context context) {
        Log.i(TAG, "connectGatt", new Object[0]);
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.close();
        }
        this.mBluetoothGatt = this.mDevice.connectGatt(context, false, this.mBluetoothGattCallbackImpl);
    }

    @CalledByNative
    private void disconnectGatt() {
        Log.i(TAG, "BluetoothGatt.disconnect", new Object[0]);
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.disconnect();
        }
    }

    @CalledByNative
    private String getDeviceName() {
        return this.mDevice.getName();
    }

    private native void nativeOnConnectionStateChange(long var1, int var3, boolean var4);

    private native void nativeCreateGattRemoteService(long var1, String var3, Object var4);

    private native void nativeOnGattServicesDiscovered(long var1);

    private class BluetoothGattCallbackImpl
    extends Wrappers.BluetoothGattCallbackWrapper {
        private BluetoothGattCallbackImpl() {
        }

        @Override
        public void onConnectionStateChange(final int status, final int newState) {
            Log.i(ChromeBluetoothDevice.TAG, "onConnectionStateChange status:%d newState:%s", status, newState == 2 ? "Connected" : "Disconnected");
            if (newState == 2) {
                ChromeBluetoothDevice.this.mBluetoothGatt.discoverServices();
            } else if (newState == 0 && ChromeBluetoothDevice.this.mBluetoothGatt != null) {
                ChromeBluetoothDevice.this.mBluetoothGatt.close();
                ChromeBluetoothDevice.this.mBluetoothGatt = null;
            }
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ChromeBluetoothDevice.this.mNativeBluetoothDeviceAndroid != 0L) {
                        ChromeBluetoothDevice.this.nativeOnConnectionStateChange(ChromeBluetoothDevice.this.mNativeBluetoothDeviceAndroid, status, newState == 2);
                    }
                }
            });
        }

        @Override
        public void onServicesDiscovered(int status) {
            Log.i(ChromeBluetoothDevice.TAG, "onServicesDiscovered status:%d==%s", status, status == 0 ? "OK" : "Error");
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ChromeBluetoothDevice.this.mNativeBluetoothDeviceAndroid != 0L) {
                        for (Wrappers.BluetoothGattServiceWrapper service : ChromeBluetoothDevice.this.mBluetoothGatt.getServices()) {
                            String serviceInstanceId = ChromeBluetoothDevice.this.getAddress() + "/" + service.getUuid().toString() + "," + service.getInstanceId();
                            ChromeBluetoothDevice.this.nativeCreateGattRemoteService(ChromeBluetoothDevice.this.mNativeBluetoothDeviceAndroid, serviceInstanceId, service);
                        }
                        ChromeBluetoothDevice.this.nativeOnGattServicesDiscovered(ChromeBluetoothDevice.this.mNativeBluetoothDeviceAndroid);
                    }
                }
            });
        }

        @Override
        public void onCharacteristicChanged(final Wrappers.BluetoothGattCharacteristicWrapper characteristic) {
            Log.i(ChromeBluetoothDevice.TAG, "device onCharacteristicChanged.", new Object[0]);
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChromeBluetoothRemoteGattCharacteristic chromeCharacteristic = ChromeBluetoothDevice.this.mWrapperToChromeCharacteristicsMap.get(characteristic);
                    if (chromeCharacteristic == null) {
                        Log.v(ChromeBluetoothDevice.TAG, "onCharacteristicChanged when chromeCharacteristic == null.");
                    } else {
                        chromeCharacteristic.onCharacteristicChanged();
                    }
                }
            });
        }

        @Override
        public void onCharacteristicRead(final Wrappers.BluetoothGattCharacteristicWrapper characteristic, final int status) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChromeBluetoothRemoteGattCharacteristic chromeCharacteristic = ChromeBluetoothDevice.this.mWrapperToChromeCharacteristicsMap.get(characteristic);
                    if (chromeCharacteristic == null) {
                        Log.v(ChromeBluetoothDevice.TAG, "onCharacteristicRead when chromeCharacteristic == null.");
                    } else {
                        chromeCharacteristic.onCharacteristicRead(status);
                    }
                }
            });
        }

        @Override
        public void onCharacteristicWrite(final Wrappers.BluetoothGattCharacteristicWrapper characteristic, final int status) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChromeBluetoothRemoteGattCharacteristic chromeCharacteristic = ChromeBluetoothDevice.this.mWrapperToChromeCharacteristicsMap.get(characteristic);
                    if (chromeCharacteristic == null) {
                        Log.v(ChromeBluetoothDevice.TAG, "onCharacteristicWrite when chromeCharacteristic == null.");
                    } else {
                        chromeCharacteristic.onCharacteristicWrite(status);
                    }
                }
            });
        }

        @Override
        public void onDescriptorRead(final Wrappers.BluetoothGattDescriptorWrapper descriptor, final int status) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChromeBluetoothRemoteGattDescriptor chromeDescriptor = ChromeBluetoothDevice.this.mWrapperToChromeDescriptorsMap.get(descriptor);
                    if (chromeDescriptor == null) {
                        Log.v(ChromeBluetoothDevice.TAG, "onDescriptorRead when chromeDescriptor == null.");
                    } else {
                        chromeDescriptor.onDescriptorRead(status);
                    }
                }
            });
        }

        @Override
        public void onDescriptorWrite(final Wrappers.BluetoothGattDescriptorWrapper descriptor, final int status) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChromeBluetoothRemoteGattDescriptor chromeDescriptor = ChromeBluetoothDevice.this.mWrapperToChromeDescriptorsMap.get(descriptor);
                    if (chromeDescriptor == null) {
                        Log.v(ChromeBluetoothDevice.TAG, "onDescriptorWrite when chromeDescriptor == null.");
                    } else {
                        chromeDescriptor.onDescriptorWrite(status);
                    }
                }
            });
        }
    }
}

