/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.bluetooth;

import java.util.List;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.bluetooth.ChromeBluetoothDevice;
import org.chromium.device.bluetooth.Wrappers;

@JNINamespace(value="device")
final class ChromeBluetoothRemoteGattService {
    private static final String TAG = "Bluetooth";
    private long mNativeBluetoothRemoteGattServiceAndroid;
    final Wrappers.BluetoothGattServiceWrapper mService;
    final String mInstanceId;
    ChromeBluetoothDevice mChromeDevice;

    private ChromeBluetoothRemoteGattService(long nativeBluetoothRemoteGattServiceAndroid, Wrappers.BluetoothGattServiceWrapper serviceWrapper, String instanceId, ChromeBluetoothDevice chromeDevice) {
        this.mNativeBluetoothRemoteGattServiceAndroid = nativeBluetoothRemoteGattServiceAndroid;
        this.mService = serviceWrapper;
        this.mInstanceId = instanceId;
        this.mChromeDevice = chromeDevice;
        Log.v(TAG, "ChromeBluetoothRemoteGattService created.");
    }

    @CalledByNative
    private void onBluetoothRemoteGattServiceAndroidDestruction() {
        this.mNativeBluetoothRemoteGattServiceAndroid = 0L;
    }

    @CalledByNative
    private static ChromeBluetoothRemoteGattService create(long nativeBluetoothRemoteGattServiceAndroid, Object bluetoothGattServiceWrapper, String instanceId, ChromeBluetoothDevice chromeDevice) {
        return new ChromeBluetoothRemoteGattService(nativeBluetoothRemoteGattServiceAndroid, (Wrappers.BluetoothGattServiceWrapper)bluetoothGattServiceWrapper, instanceId, chromeDevice);
    }

    @CalledByNative
    private String getUUID() {
        return this.mService.getUuid().toString();
    }

    @CalledByNative
    private void createCharacteristics() {
        List<Wrappers.BluetoothGattCharacteristicWrapper> characteristics = this.mService.getCharacteristics();
        for (Wrappers.BluetoothGattCharacteristicWrapper characteristic : characteristics) {
            String characteristicInstanceId = this.mInstanceId + "/" + characteristic.getUuid().toString() + "," + characteristic.getInstanceId();
            this.nativeCreateGattRemoteCharacteristic(this.mNativeBluetoothRemoteGattServiceAndroid, characteristicInstanceId, characteristic, this.mChromeDevice);
        }
    }

    private native void nativeCreateGattRemoteCharacteristic(long var1, String var3, Object var4, Object var5);
}

