/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
class WebAudioMediaCodecBridge {
    private static final String TAG = "cr.media";
    static final long TIMEOUT_MICROSECONDS = 500L;

    WebAudioMediaCodecBridge() {
    }

    @CalledByNative
    private static String createTempFile(Context ctx) throws IOException {
        File outputDirectory = ctx.getCacheDir();
        File outputFile = File.createTempFile("webaudio", ".dat", outputDirectory);
        return outputFile.getAbsolutePath();
    }

    @CalledByNative
    private static boolean decodeAudioFile(Context ctx, long nativeMediaCodecBridge, int inputFD, long dataSize) {
        ByteBuffer[] codecOutputBuffers;
        ByteBuffer[] codecInputBuffers;
        MediaCodec codec;
        String mime;
        int sampleRate;
        int inputChannelCount;
        if (dataSize < 0L || dataSize > Integer.MAX_VALUE) {
            return false;
        }
        MediaExtractor extractor = new MediaExtractor();
        ParcelFileDescriptor encodedFD = ParcelFileDescriptor.adoptFd((int)inputFD);
        try {
            extractor.setDataSource(encodedFD.getFileDescriptor(), 0L, dataSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            encodedFD.detachFd();
            return false;
        }
        if (extractor.getTrackCount() <= 0) {
            encodedFD.detachFd();
            return false;
        }
        MediaFormat format = extractor.getTrackFormat(0);
        try {
            inputChannelCount = format.getInteger("channel-count");
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to determine number of channels", new Object[0]);
            encodedFD.detachFd();
            return false;
        }
        int outputChannelCount = inputChannelCount;
        try {
            sampleRate = format.getInteger("sample-rate");
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to determine sample rate", new Object[0]);
            encodedFD.detachFd();
            return false;
        }
        try {
            mime = format.getString("mime");
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to determine type of encoding used by the file", new Object[0]);
            encodedFD.detachFd();
            return false;
        }
        long durationMicroseconds = 0L;
        if (format.containsKey("durationUs")) {
            try {
                durationMicroseconds = format.getLong("durationUs");
            }
            catch (Exception e) {
                Log.d(TAG, "Cannot get duration");
            }
        }
        if (durationMicroseconds > Integer.MAX_VALUE) {
            durationMicroseconds = 0L;
        }
        Log.d(TAG, "Initial: Tracks: %d Format: %s", extractor.getTrackCount(), format);
        try {
            codec = MediaCodec.createDecoderByType((String)mime);
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to create MediaCodec for mime type: %s", mime);
            encodedFD.detachFd();
            return false;
        }
        try {
            codec.configure(format, null, null, 0);
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to configure codec for format " + format, e);
            encodedFD.detachFd();
            return false;
        }
        try {
            codec.start();
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to start()", e);
            encodedFD.detachFd();
            return false;
        }
        try {
            codecInputBuffers = codec.getInputBuffers();
        }
        catch (Exception e) {
            Log.w(TAG, "getInputBuffers() failed", e);
            encodedFD.detachFd();
            return false;
        }
        try {
            codecOutputBuffers = codec.getOutputBuffers();
        }
        catch (Exception e) {
            Log.w(TAG, "getOutputBuffers() failed", e);
            encodedFD.detachFd();
            return false;
        }
        extractor.selectTrack(0);
        boolean sawInputEOS = false;
        boolean sawOutputEOS = false;
        boolean destinationInitialized = false;
        boolean decodedSuccessfully = true;
        while (!sawOutputEOS) {
            int outputBufIndex;
            if (!sawInputEOS) {
                int inputBufIndex;
                try {
                    inputBufIndex = codec.dequeueInputBuffer(500L);
                }
                catch (Exception e) {
                    Log.w(TAG, "dequeueInputBuffer(%d) failed.", 500L, e);
                    decodedSuccessfully = false;
                    break;
                }
                if (inputBufIndex >= 0) {
                    int sampleSize;
                    ByteBuffer dstBuf = codecInputBuffers[inputBufIndex];
                    try {
                        sampleSize = extractor.readSampleData(dstBuf, 0);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "readSampleData failed.", new Object[0]);
                        decodedSuccessfully = false;
                        break;
                    }
                    long presentationTimeMicroSec = 0L;
                    if (sampleSize < 0) {
                        sawInputEOS = true;
                        sampleSize = 0;
                    } else {
                        presentationTimeMicroSec = extractor.getSampleTime();
                    }
                    try {
                        codec.queueInputBuffer(inputBufIndex, 0, sampleSize, presentationTimeMicroSec, sawInputEOS ? 4 : 0);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "queueInputBuffer(%d, 0, %d, %d, %d) failed.", inputBufIndex, sampleSize, presentationTimeMicroSec, sawInputEOS ? 4 : 0, e);
                        decodedSuccessfully = false;
                        break;
                    }
                    if (!sawInputEOS) {
                        extractor.advance();
                    }
                }
            }
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            try {
                outputBufIndex = codec.dequeueOutputBuffer(info, 500L);
            }
            catch (Exception e) {
                Log.w(TAG, "dequeueOutputBuffer(%s, %d) failed", info, 500L);
                e.printStackTrace();
                decodedSuccessfully = false;
                break;
            }
            if (outputBufIndex >= 0) {
                ByteBuffer buf = codecOutputBuffers[outputBufIndex];
                if (!destinationInitialized) {
                    Log.d(TAG, "Final:  Rate: %d Channels: %d Mime: %s Duration: %d microsec", sampleRate, inputChannelCount, mime, durationMicroseconds);
                    WebAudioMediaCodecBridge.nativeInitializeDestination(nativeMediaCodecBridge, inputChannelCount, sampleRate, durationMicroseconds);
                    destinationInitialized = true;
                }
                if (destinationInitialized && info.size > 0) {
                    WebAudioMediaCodecBridge.nativeOnChunkDecoded(nativeMediaCodecBridge, buf, info.size, inputChannelCount, outputChannelCount);
                }
                buf.clear();
                codec.releaseOutputBuffer(outputBufIndex, false);
                if ((info.flags & 4) == 0) continue;
                sawOutputEOS = true;
                continue;
            }
            if (outputBufIndex == -3) {
                codecOutputBuffers = codec.getOutputBuffers();
                continue;
            }
            if (outputBufIndex != -2) continue;
            MediaFormat newFormat = codec.getOutputFormat();
            outputChannelCount = newFormat.getInteger("channel-count");
            sampleRate = newFormat.getInteger("sample-rate");
            Log.d(TAG, "output format changed to " + newFormat);
        }
        encodedFD.detachFd();
        codec.stop();
        codec.release();
        codec = null;
        return decodedSuccessfully;
    }

    private static native void nativeOnChunkDecoded(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native void nativeInitializeDestination(long var0, int var2, int var3, long var4);
}

