/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidKeyStore {
    private static final String TAG = "AndroidKeyStore";

    @CalledByNative
    private static byte[] getRSAKeyModulus(PrivateKey privateKey) {
        if (privateKey instanceof RSAKey) {
            return ((RSAKey)((Object)privateKey)).getModulus().toByteArray();
        }
        Log.w(TAG, "Not a RSAKey instance!", new Object[0]);
        return null;
    }

    @CalledByNative
    private static byte[] getECKeyOrder(PrivateKey privateKey) {
        if (privateKey instanceof ECKey) {
            ECParameterSpec params = ((ECKey)((Object)privateKey)).getParams();
            return params.getOrder().toByteArray();
        }
        Log.w(TAG, "Not an ECKey instance!", new Object[0]);
        return null;
    }

    @CalledByNative
    private static byte[] rawSignDigestWithPrivateKey(PrivateKey privateKey, byte[] message) {
        Signature signature = null;
        try {
            String keyAlgorithm = privateKey.getAlgorithm();
            if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
                signature = Signature.getInstance("NONEwithRSA");
            } else if ("EC".equalsIgnoreCase(keyAlgorithm)) {
                signature = Signature.getInstance("NONEwithECDSA");
            }
        }
        catch (NoSuchAlgorithmException keyAlgorithm) {
            // empty catch block
        }
        if (signature == null) {
            Log.e(TAG, "Unsupported private key algorithm: " + privateKey.getAlgorithm(), new Object[0]);
            return null;
        }
        try {
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while signing message with " + privateKey.getAlgorithm() + " private key: " + e, new Object[0]);
            return null;
        }
    }

    @CalledByNative
    private static int getPrivateKeyType(PrivateKey privateKey) {
        String keyAlgorithm = privateKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return 0;
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return 2;
        }
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getOpenSSLKeyForPrivateKey(PrivateKey privateKey) {
        Class<?> superClass;
        if (privateKey == null) {
            Log.e(TAG, "privateKey == null", new Object[0]);
            return null;
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            Log.e(TAG, "does not implement RSAPrivateKey", new Object[0]);
            return null;
        }
        try {
            superClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateKey");
        }
        catch (Exception e) {
            Log.e(TAG, "Cannot find system OpenSSLRSAPrivateKey class: " + e, new Object[0]);
            return null;
        }
        if (!superClass.isInstance(privateKey)) {
            Log.e(TAG, "Private key is not an OpenSSLRSAPrivateKey instance, its class name is:" + privateKey.getClass().getCanonicalName(), new Object[0]);
            return null;
        }
        try {
            Method getKey = superClass.getDeclaredMethod("getOpenSSLKey", new Class[0]);
            getKey.setAccessible(true);
            Object opensslKey = null;
            try {
                opensslKey = getKey.invoke((Object)privateKey, new Object[0]);
            }
            finally {
                getKey.setAccessible(false);
            }
            if (opensslKey == null) {
                Log.e(TAG, "getOpenSSLKey() returned null", new Object[0]);
                return null;
            }
            return opensslKey;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while trying to retrieve system EVP_PKEY handle: " + e, new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static long getOpenSSLHandleForPrivateKey(PrivateKey privateKey) {
        Object opensslKey = AndroidKeyStore.getOpenSSLKeyForPrivateKey(privateKey);
        if (opensslKey == null) {
            return 0L;
        }
        try {
            Method getPkeyContext;
            try {
                getPkeyContext = opensslKey.getClass().getDeclaredMethod("getPkeyContext", new Class[0]);
            }
            catch (Exception e) {
                Log.e(TAG, "No getPkeyContext() method on OpenSSLKey member:" + e, new Object[0]);
                return 0L;
            }
            getPkeyContext.setAccessible(true);
            long evp_pkey = 0L;
            try {
                evp_pkey = ((Number)getPkeyContext.invoke(opensslKey, new Object[0])).longValue();
            }
            finally {
                getPkeyContext.setAccessible(false);
            }
            if (evp_pkey == 0L) {
                Log.e(TAG, "getPkeyContext() returned null", new Object[0]);
            }
            return evp_pkey;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while trying to retrieve system EVP_PKEY handle: " + e, new Object[0]);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static Object getOpenSSLEngineForPrivateKey(PrivateKey privateKey) {
        Class<?> engineClass;
        try {
            engineClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLEngine");
        }
        catch (Exception e) {
            Log.e(TAG, "Cannot find system OpenSSLEngine class: " + e, new Object[0]);
            return null;
        }
        Object opensslKey = AndroidKeyStore.getOpenSSLKeyForPrivateKey(privateKey);
        if (opensslKey == null) {
            return null;
        }
        try {
            Method getEngine;
            try {
                getEngine = opensslKey.getClass().getDeclaredMethod("getEngine", new Class[0]);
            }
            catch (Exception e) {
                Log.e(TAG, "No getEngine() method on OpenSSLKey member:" + e, new Object[0]);
                return null;
            }
            getEngine.setAccessible(true);
            Object engine = null;
            try {
                engine = getEngine.invoke(opensslKey, new Object[0]);
            }
            finally {
                getEngine.setAccessible(false);
            }
            if (engine == null) {
                Log.e(TAG, "getEngine() returned null", new Object[0]);
            }
            if (!engineClass.isInstance(engine)) {
                Log.e(TAG, "Engine is not an OpenSSLEngine instance, its class name is:" + engine.getClass().getCanonicalName(), new Object[0]);
                return null;
            }
            return engine;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while trying to retrieve OpenSSLEngine object: " + e, new Object[0]);
            return null;
        }
    }
}

