/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import org.chromium.base.annotations.CalledByNative;

public class DeviceFormFactor {
    public static final int MINIMUM_TABLET_WIDTH_DP = 600;
    private static final int MINIMUM_LARGE_TABLET_WIDTH_DP = 720;
    private static Boolean sIsTablet = null;
    private static Boolean sIsLargeTablet = null;
    private static Integer sMinimumTabletWidthPx = null;
    private static Float sDensity = null;

    @CalledByNative
    public static boolean isTablet(Context context) {
        if (sIsTablet == null) {
            sIsTablet = DeviceFormFactor.getSmallestDeviceWidthDp(context) >= 600;
        }
        return sIsTablet;
    }

    public static boolean isLargeTablet(Context context) {
        if (sIsLargeTablet == null) {
            sIsLargeTablet = DeviceFormFactor.getSmallestDeviceWidthDp(context) >= 720;
        }
        return sIsLargeTablet;
    }

    public static int getSmallestDeviceWidthDp(Context context) {
        assert (context.getApplicationContext() != null);
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getRealMetrics(metrics);
            return Math.round(Math.min((float)metrics.heightPixels / metrics.density, (float)metrics.widthPixels / metrics.density));
        }
        return context.getResources().getConfiguration().smallestScreenWidthDp;
    }

    public static int getMinimumTabletWidthPx(Context context) {
        if (sMinimumTabletWidthPx == null) {
            sMinimumTabletWidthPx = Math.round(600.0f * context.getResources().getDisplayMetrics().density);
        }
        return sMinimumTabletWidthPx;
    }

    public static void resetValuesIfNeeded(Context context) {
        float currentDensity = context.getResources().getDisplayMetrics().density;
        if (sDensity != null && sDensity.floatValue() != currentDensity) {
            sIsTablet = null;
            sIsLargeTablet = null;
            sMinimumTabletWidthPx = null;
        }
        sDensity = Float.valueOf(currentDensity);
    }
}

