/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.widget.DatePicker;

class ChromeDatePickerDialog
extends DatePickerDialog {
    private final DatePickerDialog.OnDateSetListener mCallBack;

    public ChromeDatePickerDialog(Context context, DatePickerDialog.OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        super(context, callBack, year, monthOfYear, dayOfMonth);
        this.mCallBack = callBack;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1 && this.mCallBack != null) {
            DatePicker datePicker = this.getDatePicker();
            datePicker.clearFocus();
            this.mCallBack.onDateSet(datePicker, datePicker.getYear(), datePicker.getMonth(), datePicker.getDayOfMonth());
        }
    }

    public void setTitle(CharSequence title) {
        if (Build.VERSION.SDK_INT >= 21) {
            title = "";
        }
        super.setTitle(title);
    }
}

