/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.async;

import android.os.AsyncTask;
import android.util.SparseArray;
import java.util.concurrent.ExecutionException;
import org.chromium.base.TraceEvent;
import org.chromium.ui.resources.Resource;
import org.chromium.ui.resources.ResourceLoader;

public class AsyncPreloadResourceLoader
extends ResourceLoader {
    private final SparseArray<AsyncLoadTask> mOutstandingLoads = new SparseArray();
    private final ResourceCreator mCreator;

    public AsyncPreloadResourceLoader(int resourceType, ResourceLoader.ResourceLoaderCallback callback, ResourceCreator creator) {
        super(resourceType, callback);
        this.mCreator = creator;
    }

    @Override
    public void loadResource(int resId) {
        AsyncLoadTask task = (AsyncLoadTask)((Object)this.mOutstandingLoads.get(resId));
        if (task != null && !task.cancel(false)) {
            try {
                this.registerResource((Resource)task.get(), resId);
            }
            catch (InterruptedException e) {
                this.notifyLoadFinished(resId, null);
            }
            catch (ExecutionException e) {
                this.notifyLoadFinished(resId, null);
            }
            return;
        }
        this.registerResource(this.createResource(resId), resId);
    }

    @Override
    public void preloadResource(int resId) {
        if (this.mOutstandingLoads.get(resId) != null) {
            return;
        }
        AsyncLoadTask task = new AsyncLoadTask(resId);
        task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, null);
        this.mOutstandingLoads.put(resId, (Object)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createResource(int resId) {
        try {
            TraceEvent.begin("AsyncPreloadResourceLoader.createResource");
            Resource resource = this.mCreator.create(resId);
            return resource;
        }
        finally {
            TraceEvent.end("AsyncPreloadResourceLoader.createResource");
        }
    }

    private void registerResource(Resource resource, int resourceId) {
        this.notifyLoadFinished(resourceId, resource);
        if (resource != null) {
            resource.getBitmap().recycle();
        }
        this.mOutstandingLoads.remove(resourceId);
    }

    private class AsyncLoadTask
    extends AsyncTask<Void, Void, Resource> {
        private final int mResourceId;

        public AsyncLoadTask(int resourceId) {
            this.mResourceId = resourceId;
        }

        protected Resource doInBackground(Void ... params) {
            return AsyncPreloadResourceLoader.this.createResource(this.mResourceId);
        }

        protected void onPostExecute(Resource resource) {
            if (AsyncPreloadResourceLoader.this.mOutstandingLoads.get(this.mResourceId) == null) {
                return;
            }
            AsyncPreloadResourceLoader.this.registerResource(resource, this.mResourceId);
        }
    }

    public static interface ResourceCreator {
        public Resource create(int var1);
    }
}

