/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Log;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.chromium.net.X509Util;

class SslUtil {
    private static final String TAG = "SslUtil";

    SslUtil() {
    }

    public static SslError sslErrorFromNetErrorCode(int error, SslCertificate cert, String url) {
        assert (error >= -215 && error <= -200);
        return new SslError(5, cert, url);
    }

    public static SslCertificate getCertificateFromDerBytes(byte[] derBytes) {
        if (derBytes == null) {
            return null;
        }
        try {
            X509Certificate x509Certificate = X509Util.createCertificateFromBytes(derBytes);
            return new SslCertificate(x509Certificate);
        }
        catch (CertificateException e) {
            Log.w((String)TAG, (String)("Could not read certificate: " + e));
        }
        catch (KeyStoreException e) {
            Log.w((String)TAG, (String)("Could not read certificate: " + e));
        }
        catch (NoSuchAlgorithmException e) {
            Log.w((String)TAG, (String)("Could not read certificate: " + e));
        }
        return null;
    }

    public static boolean shouldDenyRequest(int error) {
        assert (error >= -215 && error <= -200);
        switch (error) {
            case -213: 
            case -212: 
            case -211: 
            case -208: 
            case -207: 
            case -206: 
            case -203: 
            case -202: 
            case -201: 
            case -200: 
            case -150: 
            case -129: {
                return true;
            }
        }
        return false;
    }
}

