/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.SharedPreferences;
import android.webkit.ValueCallback;
import java.util.HashSet;
import java.util.Set;
import org.chromium.base.ThreadUtils;
import org.chromium.net.GURLUtils;

public final class XWalkGeolocationPermissions {
    private static final String PREF_PREFIX = XWalkGeolocationPermissions.class.getCanonicalName() + "%";
    private final SharedPreferences mSharedPreferences;

    public XWalkGeolocationPermissions(SharedPreferences sharedPreferences) {
        this.mSharedPreferences = sharedPreferences;
    }

    public void allow(String origin) {
        String key = this.getOriginKey(origin);
        if (key != null) {
            this.mSharedPreferences.edit().putBoolean(key, true).apply();
        }
    }

    public void deny(String origin) {
        String key = this.getOriginKey(origin);
        if (key != null) {
            this.mSharedPreferences.edit().putBoolean(key, false).apply();
        }
    }

    public void clear(String origin) {
        String key = this.getOriginKey(origin);
        if (key != null) {
            this.mSharedPreferences.edit().remove(key).apply();
        }
    }

    public void clearAll() {
        SharedPreferences.Editor editor = null;
        for (String name : this.mSharedPreferences.getAll().keySet()) {
            if (!name.startsWith(PREF_PREFIX)) continue;
            if (editor == null) {
                editor = this.mSharedPreferences.edit();
            }
            editor.remove(name);
        }
        if (editor != null) {
            editor.apply();
        }
    }

    public boolean isOriginAllowed(String origin) {
        return this.mSharedPreferences.getBoolean(this.getOriginKey(origin), false);
    }

    public boolean hasOrigin(String origin) {
        return this.mSharedPreferences.contains(this.getOriginKey(origin));
    }

    public void getAllowed(String origin, final ValueCallback<Boolean> callback) {
        final boolean finalAllowed = this.isOriginAllowed(origin);
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                callback.onReceiveValue((Object)finalAllowed);
            }
        });
    }

    public void getOrigins(final ValueCallback<Set<String>> callback) {
        final HashSet<String> origins = new HashSet<String>();
        for (String name : this.mSharedPreferences.getAll().keySet()) {
            if (!name.startsWith(PREF_PREFIX)) continue;
            origins.add(name.substring(PREF_PREFIX.length()));
        }
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                callback.onReceiveValue((Object)origins);
            }
        });
    }

    private String getOriginKey(String url) {
        String origin = GURLUtils.getOrigin(url);
        if (origin.isEmpty()) {
            return null;
        }
        return PREF_PREFIX + origin;
    }

    public static interface Callback {
        public void invoke(String var1, boolean var2, boolean var3);
    }
}

