/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extensions;

import android.util.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="xwalk::extensions")
public abstract class XWalkExtensionAndroid {
    private static final String TAG = "XWalkExtensionAndroid";
    private long mXWalkExtension;

    public XWalkExtensionAndroid(String name, String jsApi) {
        this.mXWalkExtension = this.nativeGetOrCreateExtension(name, jsApi, null);
    }

    public XWalkExtensionAndroid(String name, String jsApi, String[] entryPoints) {
        this.mXWalkExtension = this.nativeGetOrCreateExtension(name, jsApi, entryPoints);
    }

    protected void destroyExtension() {
        if (this.mXWalkExtension == 0L) {
            Log.e((String)TAG, (String)"The extension to be destroyed is invalid!");
            return;
        }
        this.nativeDestroyExtension(this.mXWalkExtension);
        this.mXWalkExtension = 0L;
    }

    public void postMessage(int instanceID, String message) {
        if (this.mXWalkExtension == 0L) {
            Log.e((String)TAG, (String)"Can not post a message to an invalid extension!");
            return;
        }
        this.nativePostMessage(this.mXWalkExtension, instanceID, message);
    }

    public void postBinaryMessage(int instanceID, byte[] message) {
        if (this.mXWalkExtension == 0L) {
            Log.e((String)TAG, (String)"Can not post a binary message to an invalid extension!");
            return;
        }
        this.nativePostBinaryMessage(this.mXWalkExtension, instanceID, message);
    }

    public void broadcastMessage(String message) {
        if (this.mXWalkExtension == 0L) {
            Log.e((String)TAG, (String)"Can not broadcast message to an invalid extension!");
            return;
        }
        this.nativeBroadcastMessage(this.mXWalkExtension, message);
    }

    @CalledByNative
    public void onInstanceCreated(int instanceID) {
    }

    @CalledByNative
    public void onInstanceDestroyed(int instanceID) {
    }

    @CalledByNative
    public abstract void onMessage(int var1, String var2);

    @CalledByNative
    public void onBinaryMessage(int instanceID, byte[] message) {
    }

    @CalledByNative
    public abstract String onSyncMessage(int var1, String var2);

    private native long nativeGetOrCreateExtension(String var1, String var2, String[] var3);

    private native void nativePostMessage(long var1, int var3, String var4);

    private native void nativePostBinaryMessage(long var1, int var3, byte[] var4);

    private native void nativeBroadcastMessage(long var1, String var3);

    private native void nativeDestroyExtension(long var1);
}

