package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.adf.util.DateTimeUtil;

public class MessageInfoListJSON extends AcmsCommonJSON {


    public ArrayList<ChatMessageDto> chatMessageDtoArrayList;
    public ArrayList<ShopMemberDto> shopMemberDtoArrayList;

    public MessageInfoListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // メッセージ情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }
        HashMap<Integer, Integer> existShopMmeberMap = new HashMap<Integer, Integer>();
        JSONArray messageInfoList = json.getJSONObject(ABookCommConstants.KEY.BODY).getJSONArray(ABookCommConstants.KEY.MESSAGE_INFO_LIST);
        if (messageInfoList == null) { return; }

        chatMessageDtoArrayList = new ArrayList<ChatMessageDto>();
        shopMemberDtoArrayList = new ArrayList<ShopMemberDto>();

        for (int listCount = 0; listCount < messageInfoList.length(); listCount++) {
            if (messageInfoList.getJSONObject(listCount).length() == 0) {
                break;
            }
            ChatMessageDto chatMessageDto = new ChatMessageDto();

            JSONObject messageInfoJSON = messageInfoList.getJSONObject(listCount);
            if (messageInfoJSON == null) { continue; }

            chatMessageDto.shopMemberId = messageInfoJSON.getInt(ABookCommConstants.KEY.SHOP_MEMBER_ID);
            chatMessageDto.loginId = messageInfoJSON.getString(ABookCommConstants.KEY.LOGIN_ID);
            chatMessageDto.chatMessageId = messageInfoJSON.getInt(ABookCommConstants.KEY.MESSAGE_ID);
            chatMessageDto.messageType = messageInfoJSON.getInt(ABookCommConstants.KEY.MESSAGE_TYPE);
            if (ABookCommConstants.FLAG.MESSAGE_TYPE.COLLABORATION_START.equals(chatMessageDto.messageType)
                    || ABookCommConstants.FLAG.MESSAGE_TYPE.COLLABORATION_END.equals(chatMessageDto.messageType)) {
                chatMessageDto.message = messageInfoJSON.getJSONObject(ABookCommConstants.KEY.MESSAGE).toString();
            } else {
                chatMessageDto.message = messageInfoJSON.getString(ABookCommConstants.KEY.MESSAGE);
            }
            chatMessageDto.unreadCount = messageInfoJSON.getInt(ABookCommConstants.KEY.UNREAD_COUNT);

            if (messageInfoJSON.has(ABookCommConstants.KEY.TIME)) {
                chatMessageDto.insertDate = DateTimeUtil.millToDateString(messageInfoJSON.getJSONObject(ABookCommConstants.KEY.TIME).getLong(ABookCommConstants.KEY.TIME));
            }
            chatMessageDtoArrayList.add(chatMessageDto);


            if (existShopMmeberMap.get(chatMessageDto.shopMemberId) != null) { continue; }
            ShopMemberDto shopMemberDto = new ShopMemberDto();
            shopMemberDto.shopMemberId = messageInfoJSON.getInt(ABookCommConstants.KEY.SHOP_MEMBER_ID);
            shopMemberDto.shopMemberName = messageInfoJSON.getString(ABookCommConstants.KEY.MEMBER_NAME);
            shopMemberDto.loginId = messageInfoJSON.getString(ABookCommConstants.KEY.LOGIN_ID);
            if (messageInfoJSON.has(ABookCommConstants.KEY.PROFILE_IMAGE_PATH)) {
                shopMemberDto.profileUrl = messageInfoJSON.getString(ABookCommConstants.KEY.PROFILE_IMAGE_PATH);
            }
            existShopMmeberMap.put(shopMemberDto.shopMemberId,shopMemberDto.shopMemberId);
            shopMemberDtoArrayList.add(shopMemberDto);

        }
    }
}

