package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link GetGroupInfoParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class GetGroupInfoParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private String groupIds;
	private String updatedDate;

	/**
	 * {@link GetGroupInfoParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public GetGroupInfoParameters(String sid) {
		this.sid = sid;
	}

	/**
	 * {@link GetGroupInfoParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @since 1.0.0
	 */
	public GetGroupInfoParameters(String sid, String cmd) {
		this.sid = sid;
		this.cmd = cmd;
	}

	public GetGroupInfoParameters(String sid, String cmd, String groupId, String updatedDate) {
		this.sid = sid;
		this.cmd = cmd;
		this.groupIds = groupId;
		this.updatedDate = updatedDate;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	public String getUpdatedDate() {
		return updatedDate;
	}

	public String getGroupIds() {
		return groupIds;
	}
}
