package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link GetMessagesParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class GetMessagesParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private String roomId;
	private String lineNum;

	/**
	 * {@link GetMessagesParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public GetMessagesParameters(String sid) {
		this.sid = sid;
	}

	/**
	 * {@link GetMessagesParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @since 1.0.0
	 */
	public GetMessagesParameters(String sid, String cmd, String roomId, String lineNum) {
		this.sid = sid;
		this.cmd = cmd;
		this.roomId = roomId;
		this.lineNum = lineNum;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	public String getRoomId() {
		return roomId;
	}

	public String getLineNum() {
		return lineNum;
	}

}
