package jp.agentec.abook.abv.bl.data;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;

/**
 * DBへの接続を管理するクラス
 * 
 * ActivityのonCreate時に必ず、以下の手順で呼び出すこと。
 * もしくはInitilizerの中で行っても良い。
 * 
 * DBConnector conn = DBConnector.getInstance();
 * SQLiteOpenHelper sqlLiteOpenHelper = new ...;
 * conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
 * conn.init();
 * 
 * @author tsukada
 *
 */
public class DBConnector {
	private static volatile DBConnector dbConnector = null;
	public static final String DatabaseName = "ABVJE";
	public static final int DatabaseVersion = DatabaseVersions.Ver1_2_362;

	protected SQLiteDatabase db = null;

	private jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper sqlLiteOpenHelper = null;

	public void setSqlLiteOpenHelper(jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper sqlLiteOpenHelper) {
		this.sqlLiteOpenHelper = sqlLiteOpenHelper;
	}

	public static DBConnector getInstance() {
		if (dbConnector == null) {
			synchronized (DBConnector.class) {
				if (dbConnector == null) {
					dbConnector = new DBConnector();
				}
			}
		}
		
		return dbConnector;
	}

	public SQLiteDatabase getDatabase() {
		if (!isOpen()) {
			db = sqlLiteOpenHelper.openDatabase();
		}
		return db;
	}
	
	/**
	 * データベースコネクションがオープンされているか確認します。
	 * @return コネクションがオープンされているとtrueを返します。
	 * @since 1.0.0
	 */
	public synchronized boolean isOpen() {
		return db != null && db.isOpen();
	}
}
