package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.CollaborationDetailDto;

public class CollaborationDetailDao extends AbstractCommunicationDao {

	/**
	 * {@link CollaborationDetailDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ CollaborationDetailDao() {
	}

	@Override
	protected CollaborationDetailDto convert(Cursor cursor) {
		CollaborationDetailDto dto = new CollaborationDetailDto();

		int column = cursor.getColumnIndex("collaboration_detial_id");
		if (column != -1) {
			dto.collaborationDetialId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("collaboration_id");
		if (column != -1) {
			dto.collaborationId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("collaboration_type");
		if (column != -1) {
			dto.collaborationType = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("collaboration_duration");
		if (column != -1) {
			dto.collaborationDuration = cursor.getString(column);
		}
		return dto;
	}

	public List<CollaborationDetailDto> getCollaborationDetail(int collaborationDetialId) {
		List<CollaborationDetailDto> list = rawQueryGetDtoList("select * from t_collaboration_detail where collaboration_detial_id = ?", new String[]{""+ collaborationDetialId}, CollaborationDetailDto.class);
		return list;
	}

	public void insertCollaborationDetail(CollaborationDetailDto dto) {
		insert("insert into t_collaboration_detail (collaboration_detial_id, collaboration_id, collaboration_type, collaboration_duration) values (?,?,?,?)", dto.getInsertValues());
	}

	public void deleteCollaborationDetail() {
		try {
			beginTransaction();
			delete("t_collaboration_detail", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteCollaborationDetail failed.", e);
			throw new RuntimeException(e);
		}
	}

}
