package jp.agentec.abook.abv.ui.viewer.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.acms.type.OperationType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.ABVExceptionCode;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ContentDao;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContentObjectLogLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.cl.util.ContentLogUtil;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVAuthenticatedActivity;
import jp.agentec.abook.abv.ui.common.activity.ABVContentViewActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.ABookSettingActivity;
import jp.agentec.abook.abv.ui.home.helper.ABookCheckWebViewHelper;
import jp.agentec.abook.abv.ui.home.helper.ABookPermissionHelper;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.home.helper.ContentViewHelper;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.FileUtil;

public class CommunicationWebViewActivity extends ABVAuthenticatedActivity {
    private static final String TAG = "CommunicationWebViewActivity";

    private LinearLayout historyLayout;
    private ImageButton addSceneButton;

    protected ImageButton promoteBtn;
    protected ImageButton pauseBtn;
    protected ImageButton mBtnRemoteStart;
    protected Button historyListBtn;
    protected ImageButton btnWebClose;
    protected Button closeButton;
    protected Button btnLinkOriginalBack;
    protected Button btnWebBack;
    protected Button btnWebForward;
    private ProgressBar m_progress;
    protected ContentDto mContentDto;
    protected File mLocalFile;
    public final static int ABOOK_CHECK_TASK_IMAGE = 103;
    public final static int ABOOK_CHECK_TASK_VIDEO = 104;

    @Override
    protected void onDestroy() {
        Logger.d(TAG, "onDestroy");
        super.onDestroy();
    }


    protected Uri attachmentImageProcessing(Uri uri) throws Exception {
        if (uri == null) {
            return null;
        }
        String[] operationion = {MediaStore.MediaColumns.DATA};
        Cursor cursor = getContentResolver().query(uri, operationion, null, null, null);
        String photoFilePath = ABookCheckWebViewHelper.getInstance().contentSchemeUriToFilePath(cursor);
        try {
            int rotationAngle = ABookCheckWebViewHelper.getInstance().rotateBitmapOrientation(photoFilePath);
            mLocalFile = new File(photoFilePath);
            if (mLocalFile.exists()) {
                return Uri.fromFile(mLocalFile);
            }
        } catch (FileNotFoundException e) {
            Logger.e(TAG, "image file is not found", e);
        }
        return null;
    }
}
