/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.data;

import android.graphics.Color;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class OZCustomUIData {
    public OZCustomUIData() {
        this.init();
    }

    public OZCustomUIData(String string) {
        this.init();
        this.parse(string);
    }

    protected boolean hasJSONKey(JSONObject jSONObject, String string) {
        if (string != null && !string.isEmpty()) {
            return jSONObject.has(OZCustomUIData.getJSONKey(this.getJSONPrefix(), string));
        }
        return false;
    }

    protected int parseInt(JSONObject jSONObject, String string) {
        return this.parseInt(jSONObject, string, 0);
    }

    protected int parseInt(JSONObject jSONObject, String string, int n) {
        int n2 = n;
        if (jSONObject != null && string != null && !string.isEmpty()) {
            try {
                n2 = jSONObject.getInt(OZCustomUIData.getJSONKey(this.getJSONPrefix(), string));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return n2;
    }

    protected int parseIntRange(JSONObject jSONObject, String string, int n, int n2, int n3) {
        return Math.min(n2, Math.max(n3, this.parseInt(jSONObject, string, n)));
    }

    protected int parseIntRangeDefaultValue(JSONObject jSONObject, String string, int n, int n2, int n3) {
        return this.parseIntRangeDefaultValue(jSONObject, string, n, n2, n3, n);
    }

    protected int parseIntRangeDefaultValue(JSONObject jSONObject, String string, int n, int n2, int n3, int n4) {
        int n5 = this.parseInt(jSONObject, string, n);
        if (n2 < n5 || n3 > n5) {
            n5 = n4;
        }
        return n5;
    }

    protected float parseFloat(JSONObject jSONObject, String string) {
        return this.parseFloat(jSONObject, string, 0.0f);
    }

    protected float parseFloat(JSONObject jSONObject, String string, float f2) {
        return (float)this.parseDouble(jSONObject, string, f2);
    }

    protected float parseFloatRange(JSONObject jSONObject, String string, float f2, float f3, int n) {
        return Math.min(f3, Math.max((float)n, this.parseFloat(jSONObject, string, f2)));
    }

    protected double parseDouble(JSONObject jSONObject, String string) {
        return this.parseInt(jSONObject, string, 0);
    }

    protected double parseDouble(JSONObject jSONObject, String string, double d2) {
        double d3 = d2;
        if (jSONObject != null && string != null && !string.isEmpty()) {
            try {
                d3 = jSONObject.getDouble(OZCustomUIData.getJSONKey(this.getJSONPrefix(), string));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return d3;
    }

    protected String parseString(JSONObject jSONObject, String string) {
        String string2 = null;
        if (jSONObject != null && string != null && !string.isEmpty()) {
            try {
                string2 = jSONObject.getString(OZCustomUIData.getJSONKey(this.getJSONPrefix(), string));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return string2;
    }

    protected int parseColor(JSONObject jSONObject, String string, String string2, int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n3 = this.hasJSONKey(jSONObject, string2) ? this.parseIntRange(jSONObject, string2, n2, 255, 0) : n2;
        if (this.hasJSONKey(jSONObject, string)) {
            try {
                String string3 = this.parseString(jSONObject, string);
                if (!string3.startsWith("#")) {
                    string3 = String.format("#%s", string3);
                }
                n4 = Color.parseColor((String)string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return Color.argb((int)n3, (int)Color.red((int)n4), (int)Color.green((int)n4), (int)Color.blue((int)n4));
    }

    private static String getJSONKey(String string, String string2) {
        if (string.isEmpty()) {
            return string2;
        }
        return String.format("%s_%s", string, string2);
    }

    protected String getJSONPrefix() {
        return "";
    }

    public void parse(String string) {
        if (string != null && !string.isEmpty()) {
            JSONObject jSONObject = null;
            try {
                jSONObject = new JSONObject(string);
                if (jSONObject != null) {
                    jSONObject = this.getTargetObject(jSONObject);
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            if (jSONObject != null) {
                this.parseInternal(jSONObject);
            }
        }
    }

    public boolean isValid() {
        return this.validCheck();
    }

    protected static JSONObject getJSONObjectSafe(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        if (jSONObject != null && string != null && jSONObject.has(string)) {
            try {
                jSONObject2 = jSONObject.getJSONObject(string);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject2;
    }

    protected JSONObject getTargetObject(JSONObject jSONObject) {
        return jSONObject;
    }

    protected abstract void init();

    protected abstract void parseInternal(JSONObject var1);

    protected abstract boolean validCheck();
}

