/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oz.util.barcode.client.result.ParsedResult;
import oz.util.barcode.client.result.ParsedResultType;

public final class CalendarParsedResult
extends ParsedResult {
    private static final Pattern RFC2445_DURATION = Pattern.compile("P(?:(\\d+)W)?(?:(\\d+)D)?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+)S)?)?");
    private static final long[] RFC2445_DURATION_FIELD_UNITS = new long[]{604800000L, 86400000L, 3600000L, 60000L, 1000L};
    private static final Pattern DATE_TIME = Pattern.compile("[0-9]{8}(T[0-9]{6}Z?)?");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
    private static final DateFormat DATE_TIME_FORMAT;
    private final String summary;
    private final Date start;
    private final boolean startAllDay;
    private final Date end;
    private final boolean endAllDay;
    private final String location;
    private final String organizer;
    private final String[] attendees;
    private final String description;
    private final double latitude;
    private final double longitude;

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
    }

    public CalendarParsedResult(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String string7, double d2, double d3) {
        super(ParsedResultType.CALENDAR);
        this.summary = string;
        try {
            this.start = CalendarParsedResult.parseDate(string2);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.toString());
        }
        if (string3 == null) {
            long l = CalendarParsedResult.parseDurationMS(string4);
            this.end = l < 0L ? null : new Date(this.start.getTime() + l);
        } else {
            try {
                this.end = CalendarParsedResult.parseDate(string3);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException.toString());
            }
        }
        this.startAllDay = string2.length() == 8;
        this.endAllDay = string3 != null && string3.length() == 8;
        this.location = string5;
        this.organizer = string6;
        this.attendees = stringArray;
        this.description = string7;
        this.latitude = d2;
        this.longitude = d3;
    }

    public String getSummary() {
        return this.summary;
    }

    public Date getStart() {
        return this.start;
    }

    public boolean isStartAllDay() {
        return this.startAllDay;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isEndAllDay() {
        return this.endAllDay;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public String[] getAttendees() {
        return this.attendees;
    }

    public String getDescription() {
        return this.description;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(100);
        CalendarParsedResult.maybeAppend(this.summary, stringBuilder);
        CalendarParsedResult.maybeAppend(CalendarParsedResult.format(this.startAllDay, this.start), stringBuilder);
        CalendarParsedResult.maybeAppend(CalendarParsedResult.format(this.endAllDay, this.end), stringBuilder);
        CalendarParsedResult.maybeAppend(this.location, stringBuilder);
        CalendarParsedResult.maybeAppend(this.organizer, stringBuilder);
        CalendarParsedResult.maybeAppend(this.attendees, stringBuilder);
        CalendarParsedResult.maybeAppend(this.description, stringBuilder);
        return stringBuilder.toString();
    }

    private static Date parseDate(String string) {
        Date date;
        if (!DATE_TIME.matcher(string).matches()) {
            throw new ParseException(string, 0);
        }
        if (string.length() == 8) {
            return DATE_FORMAT.parse(string);
        }
        if (string.length() == 16 && string.charAt(15) == 'Z') {
            date = DATE_TIME_FORMAT.parse(string.substring(0, 15));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            long l = date.getTime();
            gregorianCalendar.setTime(new Date(l += (long)gregorianCalendar.get(15)));
            date = new Date(l += (long)gregorianCalendar.get(16));
        } else {
            date = DATE_TIME_FORMAT.parse(string);
        }
        return date;
    }

    private static String format(boolean bl, Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = bl ? DateFormat.getDateInstance(2) : DateFormat.getDateTimeInstance(2, 2);
        return dateFormat.format(date);
    }

    private static long parseDurationMS(CharSequence charSequence) {
        if (charSequence == null) {
            return -1L;
        }
        Matcher matcher = RFC2445_DURATION.matcher(charSequence);
        if (!matcher.matches()) {
            return -1L;
        }
        long l = 0L;
        int n = 0;
        while (n < RFC2445_DURATION_FIELD_UNITS.length) {
            String string = matcher.group(n + 1);
            if (string != null) {
                l += RFC2445_DURATION_FIELD_UNITS[n] * (long)Integer.parseInt(string);
            }
            ++n;
        }
        return l;
    }
}

