/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.OneDReader;

public final class ITFReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 199;
    private static final int W = 3;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{48, 44, 24, 20, 18, 16, 14, 12, 10, 8, 6};
    private int narrowLineWidth = -1;
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN_REVERSED = new int[]{1, 1, 3};
    static final int[][] PATTERNS = new int[][]{{1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int[] nArray = this.decodeStart(bitArray);
        int[] nArray2 = this.decodeEnd(bitArray);
        StringBuilder stringBuilder = new StringBuilder(20);
        ITFReader.decodeMiddle(bitArray, nArray[1], nArray2[0], stringBuilder);
        String string = stringBuilder.toString();
        int[] nArray3 = null;
        if (map != null) {
            nArray3 = (int[])map.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (nArray3 == null) {
            nArray3 = DEFAULT_ALLOWED_LENGTHS;
        }
        int n2 = string.length();
        boolean bl = false;
        int[] nArray4 = nArray3;
        int n3 = nArray3.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray4[n4];
            if (n2 == n5) {
                bl = true;
                break;
            }
            ++n4;
        }
        if (!bl) {
            throw FormatException.getFormatInstance();
        }
        return new Result(string, null, new ResultPoint[]{new ResultPoint(nArray[1], n), new ResultPoint(nArray2[0], n)}, BarcodeFormat.ITF);
    }

    private static void decodeMiddle(BitArray bitArray, int n, int n2, StringBuilder stringBuilder) {
        int[] nArray = new int[10];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        while (n < n2) {
            int n3;
            ITFReader.recordPattern(bitArray, n, nArray);
            int n4 = 0;
            while (n4 < 5) {
                n3 = n4 << 1;
                nArray2[n4] = nArray[n3];
                nArray3[n4] = nArray[n3 + 1];
                ++n4;
            }
            n4 = ITFReader.decodeDigit(nArray2);
            stringBuilder.append((char)(48 + n4));
            n4 = ITFReader.decodeDigit(nArray3);
            stringBuilder.append((char)(48 + n4));
            int[] nArray4 = nArray;
            int n5 = nArray.length;
            int n6 = 0;
            while (n6 < n5) {
                n3 = nArray4[n6];
                n += n3;
                ++n6;
            }
        }
    }

    int[] decodeStart(BitArray bitArray) {
        int n = ITFReader.skipWhiteSpace(bitArray);
        int[] nArray = ITFReader.findGuardPattern(bitArray, n, START_PATTERN);
        this.narrowLineWidth = nArray[1] - nArray[0] >> 2;
        this.validateQuietZone(bitArray, nArray[0]);
        return nArray;
    }

    private void validateQuietZone(BitArray bitArray, int n) {
        int n2 = this.narrowLineWidth * 10;
        n2 = n2 < n ? n2 : n;
        int n3 = n - 1;
        while (n2 > 0 && n3 >= 0) {
            if (bitArray.get(n3)) break;
            --n2;
            --n3;
        }
        if (n2 != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static int skipWhiteSpace(BitArray bitArray) {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        if (n2 == n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n2;
    }

    int[] decodeEnd(BitArray bitArray) {
        bitArray.reverse();
        try {
            int n = ITFReader.skipWhiteSpace(bitArray);
            int[] nArray = ITFReader.findGuardPattern(bitArray, n, END_PATTERN_REVERSED);
            this.validateQuietZone(bitArray, nArray[0]);
            int n2 = nArray[0];
            nArray[0] = bitArray.getSize() - nArray[1];
            nArray[1] = bitArray.getSize() - n2;
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            bitArray.reverse();
        }
    }

    private static int[] findGuardPattern(BitArray bitArray, int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = bitArray.getSize();
        boolean bl = false;
        int n4 = 0;
        int n5 = n;
        int n6 = n;
        while (n6 < n3) {
            if (bitArray.get(n6) ^ bl) {
                int n7 = n4;
                nArray2[n7] = nArray2[n7] + 1;
            } else {
                if (n4 == n2 - 1) {
                    if (ITFReader.patternMatchVariance(nArray2, nArray, 199) < 107) {
                        return new int[]{n5, n6};
                    }
                    n5 += nArray2[0] + nArray2[1];
                    System.arraycopy(nArray2, 2, nArray2, 0, n2 - 2);
                    nArray2[n2 - 2] = 0;
                    nArray2[n2 - 1] = 0;
                    --n4;
                } else {
                    ++n4;
                }
                nArray2[n4] = 1;
                bl = !bl;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] nArray) {
        int n = 107;
        int n2 = -1;
        int n3 = PATTERNS.length;
        int n4 = 0;
        while (n4 < n3) {
            int[] nArray2 = PATTERNS[n4];
            int n5 = ITFReader.patternMatchVariance(nArray, nArray2, 199);
            if (n5 < n) {
                n = n5;
                n2 = n4;
            }
            ++n4;
        }
        if (n2 >= 0) {
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

