/*
 * Decompiled with CFR 0.152.
 */
package oz.util.video;

import android.app.Activity;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import java.io.InputStream;
import java.util.Formatter;
import java.util.Locale;
import oz.main.OZStorage;
import oz.util.video.VideoControllerView$1;
import oz.util.video.VideoControllerView$2;
import oz.util.video.VideoControllerView$3;
import oz.util.video.VideoControllerView$4;
import oz.util.video.VideoControllerView$5;
import oz.util.video.VideoControllerView$6;
import oz.util.video.VideoControllerView$7;
import oz.util.video.VideoControllerView$Builder;
import oz.util.video.VideoControllerView$ControllerViewHandler;
import oz.util.video.VideoControllerView$MediaPlayerControlListener;
import oz.util.video.VideoGestureListener;
import oz.util.video.ViewAnimator;
import oz.util.video.ViewGestureListener;

public class VideoControllerView
extends FrameLayout
implements View.OnTouchListener,
VideoGestureListener {
    private static final String TAG = "VideoControllerView";
    private static final int HANDLER_ANIMATE_OUT = 1;
    private static final int HANDLER_UPDATE_PROGRESS = 2;
    private static final int HANDLER_TOGGLE_CONTROL = 3;
    private static final long PROGRESS_SEEK = 500L;
    private static final long ANIMATE_TIME = 300L;
    private View mRootView;
    private SeekBar mSeekBar;
    private TextView mEndTime;
    private TextView mCurrentTime;
    private boolean mIsShowing;
    private boolean mIsDragging;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private GestureDetector mGestureDetector;
    private Activity mContext;
    private boolean mCanSeekVideo;
    private boolean mCanControlVolume;
    private boolean mCanControlBrightness;
    private String mVideoTitle;
    private VideoControllerView$MediaPlayerControlListener mMediaPlayerControlListener;
    private ViewGroup mAnchorView;
    private SurfaceView mSurfaceView;
    private int mExitIcon;
    private String mStrExitIcon;
    private int mPauseIcon;
    private String mStrPauseIcon;
    private int mPlayIcon;
    private String mStrPlayIcon;
    private int mShrinkIcon;
    private String mStrShrinkIcon;
    private int mStretchIcon;
    private String mStrStretchIcon;
    private View mTopLayout;
    private ImageButton mBackButton;
    private TextView mTitleText;
    private boolean mShowTopLayout;
    private View mCenterLayout;
    private ImageView mCenterImage;
    private ProgressBar mCenterProgress;
    private float mCurBrightness = -1.0f;
    private int mCurVolume = -1;
    private AudioManager mAudioManager;
    private int mMaxVolume;
    private View mBottomLayout;
    private ImageButton mPauseButton;
    private ImageButton mFullscreenButton;
    private Handler mHandler = new VideoControllerView$ControllerViewHandler(this);
    private float mIconSize;
    private SeekBar.OnSeekBarChangeListener mSeekListener = new VideoControllerView$4(this);
    private View.OnClickListener mBackListener = new VideoControllerView$5(this);
    private View.OnClickListener mPauseListener = new VideoControllerView$6(this);
    private View.OnClickListener mFullscreenListener = new VideoControllerView$7(this);

    public VideoControllerView(VideoControllerView$Builder videoControllerView$Builder) {
        super((Context)VideoControllerView$Builder.access$000(videoControllerView$Builder));
        float f2 = this.DpToPx(1.0f);
        if (f2 <= 1.0f) {
            f2 = 1.5f;
        }
        this.mIconSize = f2 * f2 * 1.5f;
        this.mContext = VideoControllerView$Builder.access$000(videoControllerView$Builder);
        this.mMediaPlayerControlListener = VideoControllerView$Builder.access$100(videoControllerView$Builder);
        this.mVideoTitle = VideoControllerView$Builder.access$200(videoControllerView$Builder);
        this.mCanSeekVideo = VideoControllerView$Builder.access$300(videoControllerView$Builder);
        this.mCanControlVolume = VideoControllerView$Builder.access$400(videoControllerView$Builder);
        this.mCanControlBrightness = VideoControllerView$Builder.access$500(videoControllerView$Builder);
        this.mExitIcon = VideoControllerView$Builder.access$600(videoControllerView$Builder);
        this.mStrExitIcon = VideoControllerView$Builder.access$700(videoControllerView$Builder);
        this.mPauseIcon = VideoControllerView$Builder.access$800(videoControllerView$Builder);
        this.mStrPauseIcon = VideoControllerView$Builder.access$900(videoControllerView$Builder);
        this.mPlayIcon = VideoControllerView$Builder.access$1000(videoControllerView$Builder);
        this.mStrPlayIcon = VideoControllerView$Builder.access$1100(videoControllerView$Builder);
        this.mStretchIcon = VideoControllerView$Builder.access$1200(videoControllerView$Builder);
        this.mStrStretchIcon = VideoControllerView$Builder.access$1300(videoControllerView$Builder);
        this.mShrinkIcon = VideoControllerView$Builder.access$1400(videoControllerView$Builder);
        this.mStrShrinkIcon = VideoControllerView$Builder.access$1500(videoControllerView$Builder);
        this.mSurfaceView = VideoControllerView$Builder.access$1600(videoControllerView$Builder);
        this.setAnchorView(VideoControllerView$Builder.access$1700(videoControllerView$Builder));
        this.mSurfaceView.setOnTouchListener((View.OnTouchListener)new VideoControllerView$1(this));
    }

    private View makeControllerView() {
        this.mRootView = this.createControllerView();
        this.initControllerView();
        return this.mRootView;
    }

    private int DpToPx(float f2) {
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private View createControllerView() {
        int n = this.DpToPx(42.0f);
        int n2 = this.DpToPx(9.0f);
        int n3 = this.DpToPx(4.0f);
        RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
        relativeLayout.setBackgroundColor(0);
        relativeLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        RelativeLayout relativeLayout2 = new RelativeLayout(this.getContext());
        relativeLayout2.setId(520294);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(10, -1);
        relativeLayout2.setBackgroundColor(Color.argb((int)204, (int)0, (int)0, (int)0));
        relativeLayout2.setMinimumHeight(n);
        relativeLayout2.setPadding(n2, n2, n2, n2);
        relativeLayout.addView((View)relativeLayout2, (ViewGroup.LayoutParams)layoutParams);
        ImageButton imageButton = new ImageButton(this.getContext());
        imageButton.setId(520295);
        layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        imageButton.setBackgroundDrawable(null);
        imageButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setImageButtonResource(imageButton, 0, "res://resource/video_top_back.png");
        relativeLayout2.addView((View)imageButton);
        TextView textView = new TextView(this.getContext());
        textView.setId(520296);
        layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13, -1);
        textView.setTextColor(-1);
        textView.setTextSize(2, 20.0f);
        textView.setTypeface(null, 1);
        relativeLayout2.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setId(520297);
        layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(12, -1);
        linearLayout.setBackgroundColor(Color.argb((int)204, (int)0, (int)0, (int)0));
        linearLayout.setMinimumHeight(n);
        linearLayout.setPadding(n2, n2, n2, n2);
        linearLayout.setOrientation(0);
        relativeLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        ImageButton imageButton2 = new ImageButton(this.getContext());
        imageButton2.setId(520298);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams2.rightMargin = n3;
        layoutParams2.gravity = 16;
        imageButton2.setBackgroundDrawable(null);
        imageButton2.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageButton2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.setImageButtonResource(imageButton2, 0, "res://resource/videoplayer_play.png");
        linearLayout.addView((View)imageButton2);
        TextView textView2 = new TextView(this.getContext());
        textView2.setId(520299);
        layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams2.rightMargin = n3;
        layoutParams2.gravity = 16;
        textView2.setTextColor(-1);
        textView2.setTextSize(2, 14.0f);
        textView2.setTypeface(null, 1);
        textView2.setText((CharSequence)"00:00");
        linearLayout.addView((View)textView2, (ViewGroup.LayoutParams)layoutParams2);
        SeekBar seekBar = new SeekBar(this.getContext());
        seekBar.setId(520300);
        layoutParams2 = new LinearLayout.LayoutParams(0, this.DpToPx(32.0f), 1.0f);
        layoutParams2.gravity = 16;
        linearLayout.addView((View)seekBar, (ViewGroup.LayoutParams)layoutParams2);
        TextView textView3 = new TextView(this.getContext());
        textView3.setId(520301);
        layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams2.rightMargin = n3;
        layoutParams2.gravity = 16;
        textView3.setTextColor(-1);
        textView3.setTextSize(2, 14.0f);
        textView3.setTypeface(null, 1);
        textView3.setText((CharSequence)"00:00");
        linearLayout.addView((View)textView3, (ViewGroup.LayoutParams)layoutParams2);
        ImageButton imageButton3 = new ImageButton(this.getContext());
        imageButton3.setId(520302);
        layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams2.gravity = 16;
        imageButton3.setBackgroundDrawable(null);
        imageButton3.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageButton3.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.setImageButtonResource(imageButton3, 0, "res://resource/videoplayer_full.png");
        linearLayout.addView((View)imageButton3);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setId(520303);
        layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13, -1);
        relativeLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)layoutParams);
        ImageView imageView = new ImageView(this.getContext());
        imageView.setId(8324624);
        FrameLayout.LayoutParams layoutParams3 = new FrameLayout.LayoutParams(-2, -2);
        layoutParams3.gravity = 17;
        imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        this.setImageViewResource(imageView, 0, "res://resource/video_volume_bg.png");
        frameLayout.addView((View)imageView);
        ProgressBar progressBar = new ProgressBar(this.getContext(), null, 16974161);
        progressBar.setId(8324625);
        layoutParams3 = new FrameLayout.LayoutParams(this.DpToPx(80.0f), this.DpToPx(5.0f), 17);
        layoutParams3.topMargin = this.DpToPx(35.0f);
        progressBar.setMax(100);
        progressBar.setProgress(20);
        frameLayout.addView((View)progressBar, (ViewGroup.LayoutParams)layoutParams3);
        return relativeLayout;
    }

    private void initControllerView() {
        this.mTopLayout = this.mRootView.findViewById(520294);
        if (!this.mShowTopLayout) {
            this.mTopLayout.setVisibility(8);
        }
        this.mBackButton = (ImageButton)this.mRootView.findViewById(520295);
        this.setImageButtonResource(this.mBackButton, this.mExitIcon, this.mStrExitIcon);
        if (this.mBackButton != null) {
            this.mBackButton.requestFocus();
            this.mBackButton.setOnClickListener(this.mBackListener);
        }
        this.mTitleText = (TextView)this.mRootView.findViewById(520296);
        this.mCenterLayout = this.mRootView.findViewById(520303);
        this.mCenterLayout.setVisibility(8);
        this.mCenterImage = (ImageView)this.mRootView.findViewById(8324624);
        this.mCenterProgress = (ProgressBar)this.mRootView.findViewById(8324625);
        this.mBottomLayout = this.mRootView.findViewById(520297);
        this.mPauseButton = (ImageButton)this.mRootView.findViewById(520298);
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mFullscreenButton = (ImageButton)this.mRootView.findViewById(520302);
        if (this.mFullscreenButton != null) {
            this.mFullscreenButton.requestFocus();
            this.mFullscreenButton.setOnClickListener(this.mFullscreenListener);
        }
        this.mSeekBar = (SeekBar)this.mRootView.findViewById(520300);
        if (this.mSeekBar != null) {
            this.mSeekBar.setOnSeekBarChangeListener(this.mSeekListener);
            this.mSeekBar.setMax(1000);
        }
        this.mEndTime = (TextView)this.mRootView.findViewById(520301);
        this.mCurrentTime = (TextView)this.mRootView.findViewById(520299);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
    }

    private void show() {
        if (!this.mIsShowing && this.mAnchorView != null && this.getParent() == null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
            this.mAnchorView.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
            ViewAnimator.putOn(this.mTopLayout).waitForSize(new VideoControllerView$2(this));
        }
        this.setSeekProgress(this.mMediaPlayerControlListener.isComplete());
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
        }
        this.togglePausePlay();
        this.toggleFullScreen();
        this.mHandler.sendEmptyMessage(2);
    }

    public void toggleControllerView() {
        if (!this.isShowing()) {
            this.show();
            this.requestAutoHide();
        } else {
            Message message = this.mHandler.obtainMessage(1);
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageDelayed(message, 100L);
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    private void hide() {
        if (this.mAnchorView == null) {
            return;
        }
        ViewAnimator.putOn(this.mTopLayout).animate().translationY(-this.mTopLayout.getHeight()).duration(300L).andAnimate(this.mBottomLayout).translationY(this.mBottomLayout.getHeight()).duration(300L).end(new VideoControllerView$3(this));
    }

    private String stringToTime(int n) {
        int n2 = n / 1000;
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        int n5 = n2 / 3600;
        this.mFormatBuilder.setLength(0);
        if (n5 > 0) {
            return this.mFormatter.format("%d:%02d:%02d", n5, n4, n3).toString();
        }
        return this.mFormatter.format("%02d:%02d", n4, n3).toString();
    }

    private int setSeekProgress() {
        return this.setSeekProgress(true);
    }

    private int setSeekProgress(boolean bl) {
        if (this.mMediaPlayerControlListener == null || this.mIsDragging) {
            return 0;
        }
        int n = this.mMediaPlayerControlListener.getCurrentPosition();
        int n2 = this.mMediaPlayerControlListener.getDuration();
        if (n2 > 86400000 || n2 < 0) {
            n2 = 0;
        }
        if (n > 86400000 || n < 0) {
            n = 0;
        }
        String string = this.stringToTime(n2);
        String string2 = this.stringToTime(n);
        if (this.mSeekBar != null) {
            if (n2 > 0) {
                long l = 1000L * (long)n / (long)n2;
                this.mSeekBar.setProgress((int)l);
            } else {
                this.mSeekBar.setProgress(0);
            }
            int n3 = this.mMediaPlayerControlListener.getBufferPercentage();
            this.mSeekBar.setSecondaryProgress(n3 * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)string);
        }
        if (this.mCurrentTime != null) {
            Log.e((String)TAG, (String)("position:" + n + " -> duration:" + n2));
            this.mCurrentTime.setText((CharSequence)string2);
            if (this.mMediaPlayerControlListener.isComplete() && !bl) {
                this.mCurrentTime.setText((CharSequence)string);
            }
        }
        this.mTitleText.setText((CharSequence)this.mVideoTitle);
        return n;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 1: {
                this.mCurVolume = -1;
                this.mCurBrightness = -1.0f;
                this.mCenterLayout.setVisibility(8);
            }
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.onTouchEvent(motionEvent);
        }
        return this.mMediaPlayerControlListener.isFullScreen();
    }

    public void togglePausePlay() {
        if (this.mRootView == null || this.mPauseButton == null || this.mMediaPlayerControlListener == null) {
            return;
        }
        if (this.mMediaPlayerControlListener.isPlaying()) {
            this.setImageButtonResource(this.mPauseButton, this.mPauseIcon, this.mStrPauseIcon);
        } else {
            this.setImageButtonResource(this.mPauseButton, this.mPlayIcon, this.mStrPlayIcon);
        }
    }

    public void toggleFullScreen() {
        if (this.mRootView == null || this.mFullscreenButton == null || this.mMediaPlayerControlListener == null) {
            return;
        }
        if (this.mMediaPlayerControlListener.isFullScreen()) {
            this.setImageButtonResource(this.mFullscreenButton, this.mShrinkIcon, this.mStrShrinkIcon);
        } else {
            this.setImageButtonResource(this.mFullscreenButton, this.mStretchIcon, this.mStrStretchIcon);
        }
    }

    private void doPauseResume() {
        if (this.mMediaPlayerControlListener == null) {
            return;
        }
        if (this.mMediaPlayerControlListener.isPlaying()) {
            this.mMediaPlayerControlListener.pause();
        } else {
            this.mMediaPlayerControlListener.start();
        }
        this.togglePausePlay();
    }

    private void doToggleFullscreen() {
        if (this.mMediaPlayerControlListener == null) {
            return;
        }
        this.mMediaPlayerControlListener.toggleFullScreen();
    }

    public void setEnabled(boolean bl) {
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(bl);
        }
        if (this.mSeekBar != null) {
            this.mSeekBar.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public void setMediaPlayerControlListener(VideoControllerView$MediaPlayerControlListener videoControllerView$MediaPlayerControlListener) {
        this.mMediaPlayerControlListener = videoControllerView$MediaPlayerControlListener;
        this.togglePausePlay();
        this.toggleFullScreen();
    }

    private void setAnchorView(ViewGroup viewGroup) {
        this.mAnchorView = viewGroup;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.removeAllViews();
        View view = this.makeControllerView();
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
        this.setGestureListener();
    }

    private void setGestureListener() {
        if (this.mCanControlVolume) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
            this.mMaxVolume = this.mAudioManager.getStreamMaxVolume(3);
        }
        this.mGestureDetector = new GestureDetector((Context)this.mContext, (GestureDetector.OnGestureListener)new ViewGestureListener((Context)this.mContext, this));
    }

    public void onSingleTap() {
        if (!this.mMediaPlayerControlListener.isPrepare() && this.mMediaPlayerControlListener.isFullScreen()) {
            this.requestToggleController();
        }
    }

    public void onHorizontalScroll(boolean bl) {
        if (this.mCanSeekVideo) {
            if (bl) {
                this.seekForWard();
            } else {
                this.seekBackWard();
            }
        }
    }

    private void seekBackWard() {
        if (this.mMediaPlayerControlListener == null) {
            return;
        }
        int n = this.mMediaPlayerControlListener.getCurrentPosition();
        n = (int)((long)n - 500L);
        this.mMediaPlayerControlListener.seekTo(n);
        this.setSeekProgress(true);
        this.show();
    }

    private void seekForWard() {
        if (this.mMediaPlayerControlListener == null) {
            return;
        }
        int n = this.mMediaPlayerControlListener.getCurrentPosition();
        n = (int)((long)n + 500L);
        this.mMediaPlayerControlListener.seekTo(n);
        this.setSeekProgress(true);
        this.show();
    }

    public void onVerticalScroll(float f2, int n) {
        if (n == 1) {
            if (this.mCanControlBrightness) {
                this.setImageViewResource(this.mCenterImage, 0, "res://resource/video_bright_bg.png");
                this.updateBrightness(f2);
            }
        } else if (this.mCanControlVolume) {
            this.setImageViewResource(this.mCenterImage, 0, "res://resource/video_volume_bg.png");
            this.updateVolume(f2);
        }
    }

    private void updateVolume(float f2) {
        int n;
        this.mCenterLayout.setVisibility(0);
        if (this.mCurVolume == -1) {
            this.mCurVolume = this.mAudioManager.getStreamVolume(3);
            if (this.mCurVolume < 0) {
                this.mCurVolume = 0;
            }
        }
        if ((n = (int)(f2 * (float)this.mMaxVolume) + this.mCurVolume) > this.mMaxVolume) {
            n = this.mMaxVolume;
        }
        if (n < 0) {
            n = 0;
        }
        this.mAudioManager.setStreamVolume(3, n, 0);
        int n2 = n * 100 / this.mMaxVolume;
        this.mCenterProgress.setProgress(n2);
    }

    private void updateBrightness(float f2) {
        if (this.mCurBrightness == -1.0f) {
            this.mCurBrightness = this.mContext.getWindow().getAttributes().screenBrightness;
            if (this.mCurBrightness <= 0.01f) {
                this.mCurBrightness = 0.01f;
            }
        }
        this.mCenterLayout.setVisibility(0);
        WindowManager.LayoutParams layoutParams = this.mContext.getWindow().getAttributes();
        layoutParams.screenBrightness = this.mCurBrightness + f2;
        if (layoutParams.screenBrightness >= 1.0f) {
            layoutParams.screenBrightness = 1.0f;
        } else if (layoutParams.screenBrightness <= 0.01f) {
            layoutParams.screenBrightness = 0.01f;
        }
        this.mContext.getWindow().setAttributes(layoutParams);
        float f3 = layoutParams.screenBrightness * 100.0f;
        this.mCenterProgress.setProgress((int)f3);
    }

    private void setImageResize(Drawable drawable2, ImageButton imageButton) {
        if (imageButton.getLayoutParams() != null) {
            if (drawable2 != null) {
                imageButton.getLayoutParams().width = (int)(this.mIconSize * (float)drawable2.getIntrinsicWidth());
                imageButton.getLayoutParams().height = (int)(this.mIconSize * (float)drawable2.getIntrinsicHeight());
            } else {
                imageButton.getLayoutParams().width = -2;
                imageButton.getLayoutParams().height = -2;
            }
            imageButton.requestLayout();
            imageButton.postInvalidate();
        }
    }

    private void setImageButtonResource(ImageButton imageButton, int n, String string) {
        if (n != 0) {
            imageButton.setImageResource(n);
        } else if (string != null) {
            Drawable drawable2 = this.getBitmapDrawable(string);
            imageButton.setImageDrawable(drawable2);
            this.setImageResize(drawable2, imageButton);
        }
    }

    private void setImageResize(Drawable drawable2, ImageView imageView) {
        if (imageView.getLayoutParams() != null) {
            if (drawable2 != null) {
                imageView.getLayoutParams().width = (int)(this.mIconSize * (float)drawable2.getIntrinsicWidth());
                imageView.getLayoutParams().height = (int)(this.mIconSize * (float)drawable2.getIntrinsicHeight());
            } else {
                imageView.getLayoutParams().width = -2;
                imageView.getLayoutParams().height = -2;
            }
        }
    }

    private void setImageViewResource(ImageView imageView, int n, String string) {
        if (n != 0) {
            imageView.setImageResource(n);
        } else if (string != null) {
            Drawable drawable2 = this.getBitmapDrawable(string);
            imageView.setImageDrawable(drawable2);
            this.setImageResize(drawable2, imageView);
        }
    }

    private Drawable getBitmapDrawable(String string) {
        BitmapDrawable bitmapDrawable = null;
        try {
            bitmapDrawable = string.toLowerCase().startsWith("res://") ? new BitmapDrawable(BitmapFactory.decodeStream((InputStream)this.getContext().getAssets().open(string.substring(6)))) : new BitmapDrawable(BitmapFactory.decodeFile((String)string));
            bitmapDrawable.setTargetDensity(OZStorage.getDensityDPI() > 2.0f ? (int)(640.0f / OZStorage.getDensityDPI()) : 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bitmapDrawable;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (!this.mMediaPlayerControlListener.isFullScreen()) {
            return false;
        }
        this.mGestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public void stopToggleControllerMsg() {
        if (this.mHandler.hasMessages(3)) {
            this.mHandler.removeMessages(3);
        }
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
    }

    public void requestToggleController() {
        this.stopToggleControllerMsg();
        this.mHandler.sendEmptyMessageDelayed(3, 100L);
    }

    public void requestAutoHide() {
        this.stopToggleControllerMsg();
        this.mHandler.sendEmptyMessageDelayed(3, 5000L);
    }

    public void requestUpdateProgress() {
        this.mHandler.sendEmptyMessage(2);
    }

    static /* synthetic */ VideoControllerView$MediaPlayerControlListener access$1800(VideoControllerView videoControllerView) {
        return videoControllerView.mMediaPlayerControlListener;
    }

    static /* synthetic */ GestureDetector access$1900(VideoControllerView videoControllerView) {
        return videoControllerView.mGestureDetector;
    }

    static /* synthetic */ void access$2000(VideoControllerView videoControllerView) {
        videoControllerView.hide();
    }

    static /* synthetic */ int access$2100(VideoControllerView videoControllerView) {
        return videoControllerView.setSeekProgress();
    }

    static /* synthetic */ boolean access$2200(VideoControllerView videoControllerView) {
        return videoControllerView.mIsDragging;
    }

    static /* synthetic */ boolean access$2300(VideoControllerView videoControllerView) {
        return videoControllerView.mIsShowing;
    }

    static /* synthetic */ boolean access$2302(VideoControllerView videoControllerView, boolean bl) {
        videoControllerView.mIsShowing = bl;
        return videoControllerView.mIsShowing;
    }

    static /* synthetic */ Handler access$2400(VideoControllerView videoControllerView) {
        return videoControllerView.mHandler;
    }

    static /* synthetic */ View access$2500(VideoControllerView videoControllerView) {
        return videoControllerView.mBottomLayout;
    }

    static /* synthetic */ View access$2600(VideoControllerView videoControllerView) {
        return videoControllerView.mTopLayout;
    }

    static /* synthetic */ ViewGroup access$2700(VideoControllerView videoControllerView) {
        return videoControllerView.mAnchorView;
    }

    static /* synthetic */ void access$2800(VideoControllerView videoControllerView) {
        videoControllerView.show();
    }

    static /* synthetic */ boolean access$2202(VideoControllerView videoControllerView, boolean bl) {
        videoControllerView.mIsDragging = bl;
        return videoControllerView.mIsDragging;
    }

    static /* synthetic */ TextView access$2900(VideoControllerView videoControllerView) {
        return videoControllerView.mCurrentTime;
    }

    static /* synthetic */ String access$3000(VideoControllerView videoControllerView, int n) {
        return videoControllerView.stringToTime(n);
    }

    static /* synthetic */ int access$3100(VideoControllerView videoControllerView, boolean bl) {
        return videoControllerView.setSeekProgress(bl);
    }

    static /* synthetic */ void access$3200(VideoControllerView videoControllerView) {
        videoControllerView.doPauseResume();
    }

    static /* synthetic */ void access$3300(VideoControllerView videoControllerView) {
        videoControllerView.doToggleFullscreen();
    }
}

