/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import oz.util.speech.OZLocaleListener;
import oz.util.speech.OZSpeechManager;
import oz.util.speech.OZSpeechRequestInfo;
import oz.util.view.animatable.AnimatableFrameLayout;
import oz.util.view.animatable.AnimatableScrollView;
import oz.util.view.animatable.AnimatableScrollView$OnMoveListener;
import oz.viewer.ui.df.DFHandler;
import oz.viewer.ui.df.DFInfoConnector;
import oz.viewer.ui.df.DFManager$1;
import oz.viewer.ui.df.DFManager$2;
import oz.viewer.ui.df.DFManager$3;
import oz.viewer.ui.df.DFManager$4;
import oz.viewer.ui.df.DFManager$5;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.ctrl.DFCompCtrl;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl$FromSTTInfo;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl$OnResultListener;
import oz.viewer.ui.df.ctrl.DFSpeechCtrl;
import oz.viewer.ui.df.view.BubbleTextLayout;
import oz.viewer.ui.df.view.BubbleTextLayout$BubbleInfo;
import oz.viewer.ui.df.view.DFCompView;
import oz.viewer.ui.df.view.DFLayoutHelper;
import oz.viewer.ui.df.view.DFMicBtnView$MIC_STATE;
import oz.viewer.ui.df.view.DFProgressbar;

public class DFManager
implements View.OnClickListener,
View.OnLayoutChangeListener,
View.OnTouchListener,
OZLocaleListener,
AnimatableScrollView$OnMoveListener,
DFEFormBotCtrl$OnResultListener {
    public static final int ID_IMAGE_BG = 0;
    public static final int ID_IMAGE_SPEAKER_ON = 1;
    public static final int ID_IMAGE_SPEAKER_OFF = 2;
    public static final int ID_IMAGE_VOICE_ON = 3;
    public static final int ID_IMAGE_VOICE_OFF = 4;
    public static final int ID_IMAGE_UP_NORMAL = 5;
    public static final int ID_IMAGE_UP_PRESSED = 6;
    public static final int ID_IMAGE_DOWN_NORMAL = 7;
    public static final int ID_IMAGE_DOWN_PRESSED = 8;
    public static final int ID_IMAGE_CLOSE_NORMAL = 9;
    public static final int ID_IMAGE_CLOSE_PRESSED = 10;
    public static final int ID_IMAGE_NEXT_ARROW = 11;
    public static final int ID_IMAGE_VOICERECORDER_READY = 12;
    public static final int ID_IMAGE_VOICERECORDER_STOP = 13;
    public static final int ID_IMAGE_VOICERECORDER_PLAY = 14;
    public static final int ID_IMAGE_VOICERECORDER_PAUSE = 15;
    public static final int ID_IMAGE_VOICERECORDER_MIC = 16;
    public static final int ID_IMAGE_VOICERECORDER_CLEAR = 17;
    public static final int ID_IMAGE_ATTACHMENT_DOCUMENT = 18;
    public static final int ID_IMAGE_ATTACHMENT_CAMERA = 19;
    public static final int ID_IMAGE_ATTACHMENT_IMAGE = 20;
    public static final int ID_IMAGE_NUMERICUPDOWN_MINUS = 21;
    public static final int ID_IMAGE_NUMERICUPDOWN_PLUS = 22;
    public static final int ID_IMAGE_XBUTTON = 23;
    public static final int ID_IMAGE_DATE_LEFT_ARROW = 24;
    public static final int ID_IMAGE_DATE_RIGHT_ARROW = 25;
    public static final int ID_IMAGE_SIGNATURE = 26;
    public static final int ID_IMAGE_CAMERA = 27;
    public static final int ID_IMAGE_TAKEPICTURE_NORMAL = 28;
    public static final int ID_IMAGE_TAKEPICTURE_PRESSED = 29;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_AUTO = 30;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_AUTO_D = 31;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_OFF = 32;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_OFF_D = 33;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_ON = 34;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_ON_D = 35;
    public static final int ID_IMAGE_TAKEPICTURE_FACING_SWITCH = 36;
    public static final int ID_IMAGE_TAKEPICTURE_FACING_SWITCH_D = 37;
    public static final String[] imageStore = new String[]{"DFBG.png", "speakon.png", "speakoff.png", "voiceon.png", "voiceoff.png", "up.png", "up.png", "down.png", "down.png", "close.png", "close.png", "next_arrow.png", "vr_ready.png", "vr_stop.png", "vr_play.png", "vr_pause.png", "vr_mic.png", "vr_clear.png", "at_document.png", "at_camera.png", "at_image.png", "nm_minus.png", "nm_plus.png", "xbutton.png", "left.png", "right.png", "signature.png", "camera.png", "takepicture_normal.png", "takepicture_pressed.png", "ip_flash_auto.png", "ip_flash_auto_d.png", "ip_flash_off.png", "ip_flash_off_d.png", "ip_flash_on.png", "ip_flash_on_d.png", "ip_facing_switch.png", "ip_facing_switch_d.png"};
    public static final int ID_ROOT_BACKGROUND_DUMMY = 104857;
    public static final int ID_ROOT_DUMMY = 104856;
    public static final int ID_ROOT = 65536;
    public static final int ID_TOP = 4096;
    public static final int ID_TOP_BAR = 4352;
    public static final int ID_TOP_BAR_BTN_DISMISS = 4353;
    public static final int ID_TOP_BAR_TV_COMP_TITLE = 4354;
    public static final int ID_TOP_CONTENT_SCROLL = 4608;
    public static final int ID_TOP_CONTENT = 4864;
    public static final int ID_TOP_CONTENT_TV_COMP_QUESTION = 4880;
    public static final int ID_TOP_CONTENT_TV_COMP_DESCRIPT = 4881;
    public static final int ID_TOP_CONTENT_TV_COMP_LAYOUT = 4882;
    public static final int ID_TOP_CONTENT_TV_COMP_QUESTION_NUMBER = 4883;
    public static final int ID_TOP_CONTENT_BTN_STT_MIC = 5121;
    public static final int ID_TOP_CONTENT_BTN_STT_MIC_BUBBLE = 5122;
    public static final int ID_BOTTOM = 8192;
    public static final int ID_BOTTOM_BAR_BTN_TTS_ALLOW = 8448;
    public static final int ID_BOTTOM_BAR_BTN_STT_ALLOW = 8449;
    public static final int ID_BOTTOM_BAR_BTN_AUTO_PROGRESS = 8450;
    public static final int ID_BOTTOM_BAR_PROGRESS = 8451;
    public static final int ID_BOTTOM_BAR_BTN_PREV = 8452;
    public static final int ID_BOTTOM_BAR_BTN_NEXT = 8453;
    public static final int MOVE_FROM_USER = 1;
    public static final int MOVE_FROM_SIMPLE_MOVE = 2;
    public static final int MOVE_FROM_SCROLL = 4;
    public static final int DF_TYPE_INPUT_COMPONENT = 0;
    public static final int DF_TYPE_STATEMENT = 1;
    public static final int DF_TYPE_WELCOME_STATEMENT = 2;
    public static final int DF_TYPE_THANKYOU_STATEMENT = 3;
    public static final int DF_TYPE_GROUP = 4;
    public static final int DF_TYPE_REPEAT_QUESTION = 5;
    public static final int DF_TYPE_COMBINED_QUESTION = 6;
    private static final int CONST_TTS_DELAY = 1000;
    private String mLocale;
    private DFInfoConnector mConnector;
    private DFCompCtrl mCompCtrl;
    private DFEFormBotCtrl mEFormBotCtrl;
    private DFSpeechCtrl mSpeechCtrl;
    private DFHandler mHandler;
    private Context mContext;
    private Dialog mDialog;
    private boolean mUseAuto;
    private boolean mUseAutoNow;
    private int mDialogWidth;
    private int mDialogHeight;
    private VelocityTracker mVelocityTracker;
    private boolean mEnablePrev;
    private boolean mEnableNext;
    private boolean mUseLayoutChange;

    public DFManager(Context context, DFInfoConnector dFInfoConnector) {
        this.mContext = context;
        this.mConnector = dFInfoConnector;
        this.mHandler = new DFHandler(this);
        this.mUseAuto = true;
        this.mUseAutoNow = this.mConnector.getAutoNext();
        this.mUseLayoutChange = true;
        this.mCompCtrl = new DFCompCtrl(this);
        this.mEFormBotCtrl = new DFEFormBotCtrl(this.mConnector.getEformServiceURL(), this.mConnector.getEformAuthorizedKey());
        this.mEFormBotCtrl.setOnResultListener(this);
        this.mSpeechCtrl = new DFSpeechCtrl(this);
        OZSpeechManager.getInstance(((Activity)context).getBaseContext()).setDFLocaleListener(this);
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getDialogWidth() {
        return this.mDialogWidth;
    }

    public int getDialogHeight() {
        return this.mDialogHeight;
    }

    public boolean isUseAutoProgress() {
        return this.mUseAuto;
    }

    public boolean isUseAutoProgressNow() {
        return this.mUseAutoNow;
    }

    public DFInfoConnector getConnector() {
        return this.mConnector;
    }

    public DFCompCtrl getCompCtrl() {
        return this.mCompCtrl;
    }

    public DFEFormBotCtrl getEFormBotCtrl() {
        return this.mEFormBotCtrl;
    }

    public DFSpeechCtrl getSpeechCtrl() {
        return this.mSpeechCtrl;
    }

    public DFHandler getDFHandler() {
        return this.mHandler;
    }

    public void cancelSpeechAndBubble() {
        this.cancelSpeech();
        this.bubbleClear(false);
    }

    public void cancelSpeech() {
        this.mEFormBotCtrl.cancelAll();
        this.mSpeechCtrl.getMicBtnManager().setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
        this.mSpeechCtrl.cancelAll();
    }

    private BubbleTextLayout getBubbleLayout() {
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            return (BubbleTextLayout)dialog.findViewById(5122);
        }
        return null;
    }

    public void bubbleUpdate(String string, boolean bl, int n, boolean bl2) {
        BubbleTextLayout bubbleTextLayout = this.getBubbleLayout();
        if (bubbleTextLayout != null) {
            boolean bl3;
            BubbleTextLayout$BubbleInfo bubbleTextLayout$BubbleInfo = new BubbleTextLayout$BubbleInfo();
            bubbleTextLayout$BubbleInfo.id = n;
            bubbleTextLayout$BubbleInfo.content = string;
            boolean bl4 = bl3 = bl2 || n != bubbleTextLayout.getFirstItemID();
            if (bl3) {
                if (bubbleTextLayout.size() == 2) {
                    bubbleTextLayout.removeLast(true);
                }
                bubbleTextLayout.insert(bubbleTextLayout$BubbleInfo, bl);
            } else {
                bubbleTextLayout.update(bubbleTextLayout$BubbleInfo);
            }
        }
    }

    public void bubbleClear(boolean bl) {
        BubbleTextLayout bubbleTextLayout = this.getBubbleLayout();
        if (bubbleTextLayout != null) {
            bubbleTextLayout.clear(bl);
        }
    }

    public void cancelSpeech(OZSpeechRequestInfo oZSpeechRequestInfo) {
        this.mEFormBotCtrl.cancelAll();
        if (oZSpeechRequestInfo.mode == 1 || oZSpeechRequestInfo.mode == 3) {
            this.mSpeechCtrl.getMicBtnManager().setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
        }
        this.mSpeechCtrl.cancelAll();
    }

    public void dismissDialog() {
        Dialog dialog = this.mDialog;
        this.mDialog = null;
        if (dialog != null && dialog.isShowing()) {
            this.mCompCtrl.OnValueChangedComp(dialog);
            this.mCompCtrl.clearComp();
            this.cancelSpeechAndBubble();
            dialog.dismiss();
            this.resetEnv();
        }
    }

    public void callDismissDialog() {
        this.mConnector.callDismissDialog();
    }

    private void resetEnv() {
        this.mConnector.clearList();
    }

    private boolean calcDialogSize() {
        boolean bl = DFUtils.isMobile(this.getContext());
        Point point = DFUtils.getScreenSize((Activity)this.mContext);
        int n = bl ? point.x : (int)((float)point.x * 0.9f);
        int n2 = bl ? point.y : (int)((float)point.y * 0.9f);
        boolean bl2 = false;
        if (this.mDialogWidth != n || this.mDialogHeight != n2) {
            this.mDialogWidth = n;
            this.mDialogHeight = n2;
            bl2 = true;
        }
        return bl2;
    }

    public void setViewDisable(boolean bl) {
        AnimatableScrollView animatableScrollView;
        if (this.mDialog != null && (animatableScrollView = (AnimatableScrollView)this.mDialog.findViewById(4608)) != null) {
            animatableScrollView.setTouchDisable(bl);
        }
    }

    public void createDialog() {
        this.calcDialogSize();
        this.mLocale = this.mConnector.getLocale();
        this.mDialog = DFLayoutHelper.createDialog(this.getContext(), this.mDialogWidth, this.mDialogHeight, this.mLocale, this.mConnector.getIsNotDFList(), this.mConnector.getSpeaker(), this.mConnector.getMicrophone());
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)new DFManager$1(this));
        this.initDialog(this.mDialog);
        this.initBottomBar();
    }

    private void initDialog(Dialog dialog) {
        if (dialog != null) {
            dialog.findViewById(104856).addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            ((ViewGroup)dialog.findViewById(104856)).addView((View)new DFManager$2(this, dialog.getContext()), 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
            this.getSpeechCtrl().updateMicBtn();
            this.getSpeechCtrl().updateTTSBtn();
            this.updateProgress(dialog);
            this.updateAutoProgressBtn();
            this.updatePrevNextBtn();
            DFUtils.setOnClick(dialog, 8448, this);
            DFUtils.setOnClick(dialog, 8449, this);
            DFUtils.setOnClick(dialog, 8452, this);
            DFUtils.setOnClick(dialog, 8453, this);
            DFUtils.setOnClick(dialog, 8450, this);
            DFUtils.setOnClick(dialog, 5121, this);
            DFUtils.setOnClick(dialog, 4353, this);
            DFUtils.setOnTouch(dialog, 4608, this);
            AnimatableScrollView animatableScrollView = (AnimatableScrollView)dialog.findViewById(4608);
            if (animatableScrollView != null) {
                animatableScrollView.setMoveListener(this);
            }
        }
    }

    private void initBottomBar() {
        if (this.mConnector.getIsNotDFList() && this.mConnector.getSpeaker() == 2 && (this.mConnector.getMicrophone() == 1 || this.mConnector.getMicrophone() == 2)) {
            View view = this.getDialog().findViewById(8192);
            view.setVisibility(8);
        }
    }

    public void updateProgress(Dialog dialog) {
        if (dialog != null) {
            if (this.mConnector.getIsNotDFList()) {
                DFProgressbar dFProgressbar = (DFProgressbar)dialog.findViewById(8451);
                dFProgressbar.setVisibility(8);
            } else {
                int n = 0;
                int n2 = 0;
                n = (int)this.mConnector.getSelectedIndex();
                n2 = (int)(this.mConnector.getCount() - 1L);
                DFUtils.setProgress(dialog, 8451, n, n2);
                dialog.findViewById(8452).setEnabled(n != 0);
                dialog.findViewById(8453).setEnabled(n != n2);
            }
        }
    }

    public void showDialog() {
        if (this.mDialog != null && !this.mDialog.isShowing()) {
            this.mDialog.show();
        }
    }

    public void updateLayout(boolean bl, boolean bl2) {
        switch (this.mConnector.getType()) {
            case 0: {
                int n = this.mConnector.getObjectAddress();
                new Handler().postDelayed((Runnable)new DFManager$3(this, n), 1000L);
                this.mCompCtrl.compUpdate(bl, bl2);
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                new Handler().postDelayed((Runnable)new DFManager$4(this), 1000L);
                this.mCompCtrl.compUpdate(bl, bl2);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (view.getId()) {
            case 4608: {
                return this.onTouch_ScrollView((ScrollView)view, motionEvent);
            }
        }
        return false;
    }

    private boolean onTouch_ScrollView(ScrollView scrollView, MotionEvent motionEvent) {
        AnimatableScrollView animatableScrollView = (AnimatableScrollView)scrollView;
        if (animatableScrollView.isTouchDisable()) {
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        switch (motionEvent.getAction()) {
            case 0: {
                this.mEnableNext = !scrollView.canScrollVertically(5);
                boolean bl = this.mEnablePrev = !scrollView.canScrollVertically(-5);
                if (!this.mEnableNext && !this.mEnablePrev) break;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
                this.mVelocityTracker.addMovement(motionEvent);
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1);
                float f2 = this.mVelocityTracker.getYVelocity();
                if (this.mHandler.hasMoveRequest()) break;
                if (this.mEnableNext && this.mCompCtrl.canNextComp(4) && f2 < -5.0f) {
                    this.mEnableNext = false;
                    this.mEnablePrev = false;
                    this.mHandler.requestMoveNextComp(4);
                    break;
                }
                if (!this.mEnablePrev || !this.mCompCtrl.canPrevComp(4) || !(f2 > 5.0f)) break;
                this.mEnableNext = false;
                this.mEnablePrev = false;
                this.mHandler.requestMovePrevComp(4);
                break;
            }
            case 1: 
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return this.mVelocityTracker != null && !this.mEnableNext && !this.mEnablePrev;
    }

    public void OnResult(int n, String string, String string2) {
        DFUtils.d("###### " + n + " , " + string2 + "  ###### ");
        DFCompView dFCompView = this.getCompCtrl().getCompView();
        if (dFCompView != null) {
            DFEFormBotCtrl$FromSTTInfo dFEFormBotCtrl$FromSTTInfo = new DFEFormBotCtrl$FromSTTInfo();
            dFEFormBotCtrl$FromSTTInfo.view = dFCompView;
            dFEFormBotCtrl$FromSTTInfo.code = n;
            dFEFormBotCtrl$FromSTTInfo.compID = string;
            dFEFormBotCtrl$FromSTTInfo.value = string2;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(19, dFEFormBotCtrl$FromSTTInfo));
        }
    }

    public void callOnResult(DFEFormBotCtrl$FromSTTInfo dFEFormBotCtrl$FromSTTInfo) {
        if (dFEFormBotCtrl$FromSTTInfo != null) {
            boolean bl = dFEFormBotCtrl$FromSTTInfo.view != null && dFEFormBotCtrl$FromSTTInfo.view == this.getCompCtrl().getCompView();
            switch (dFEFormBotCtrl$FromSTTInfo.code) {
                case 0: {
                    if (!bl) break;
                    this.mCompCtrl.updateUI(dFEFormBotCtrl$FromSTTInfo.value);
                    if (this.mUseAutoNow && this.mConnector.getSelectedIndex() < this.mConnector.getCount() - 1L) {
                        if (!this.mCompCtrl.canNextComp(2) || this.mHandler.hasMoveRequest()) break;
                        this.mHandler.requestMoveNextComp(2, 1000);
                        break;
                    }
                    this.mSpeechCtrl.getMicBtnManager().setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
                    break;
                }
                case 1: {
                    if (this.mCompCtrl.canPrevComp(2) && !this.mHandler.hasMoveRequest()) {
                        this.mHandler.requestMovePrevComp(2);
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 2: {
                    if (this.mCompCtrl.canNextComp(2) && !this.mHandler.hasMoveRequest()) {
                        this.mHandler.requestMoveNextComp(2);
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 200: {
                    if (this.mSpeechCtrl.isUseTTS() && this.mSpeechCtrl.isUseTTSNow()) {
                        this.mHandler.requestTTS("\uc11c\ubc84\uc5d0 \uc5f0\uacb0\ud558\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 4: {
                    this.callDismissDialog();
                    break;
                }
                case -1: 
                case 3: 
                case 5: {
                    if (this.mSpeechCtrl.isUseTTS() && this.mSpeechCtrl.isUseTTSNow()) {
                        this.mHandler.requestTTS(this.mConnector.getAskAgainText());
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case -2: {
                    this.cancelSpeech();
                    this.bubbleUpdate("EForm \uc11c\ubc84\uc5d0 \uc5f0\uacb0 \ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", true, 1, false);
                    break;
                }
            }
        }
    }

    private void OnAutoProgressToggle() {
        this.OnAutoProgressChanged(this.mUseAuto & !this.mUseAutoNow);
    }

    private void OnAutoProgressChanged(boolean bl) {
        if (this.mUseAutoNow != bl) {
            this.mUseAutoNow = bl;
            this.updateAutoProgressBtn();
        }
    }

    private void updateAutoProgressBtn() {
        View view;
        Dialog dialog = this.getDialog();
        if (dialog != null && (view = dialog.findViewById(8450)) != null) {
            view.setSelected(this.mUseAuto & this.mUseAutoNow);
        }
    }

    private void updatePrevNextBtn() {
        Dialog dialog = this.getDialog();
        if (dialog != null && this.mConnector.getIsNotDFList()) {
            View view = dialog.findViewById(8452);
            if (view != null) {
                view.setVisibility(8);
            }
            if ((view = dialog.findViewById(8453)) != null) {
                view.setVisibility(8);
            }
        }
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 8452: {
                this.mCompCtrl.OnMovePrevBtnClick();
                break;
            }
            case 8453: {
                this.mCompCtrl.OnMoveNextBtnClick();
                break;
            }
            case 8449: {
                this.mSpeechCtrl.OnSTTAllowBtnClick();
                break;
            }
            case 8448: {
                this.mSpeechCtrl.OnTTSAllowBtnClick();
                break;
            }
            case 8450: {
                this.OnAutoProgressToggle();
                break;
            }
            case 4353: {
                this.callDismissDialog();
                break;
            }
            case 5121: {
                this.mSpeechCtrl.onSTTBtnClick(view);
            }
        }
    }

    public void OnStartMove(AnimatableScrollView animatableScrollView, AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
    }

    public void OnFinishMove(AnimatableScrollView animatableScrollView, AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
    }

    public void OnAfterMove(AnimatableScrollView animatableScrollView, AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mDialog != null) {
            this.mHandler.requestTryHandleDFMessage();
        }
    }

    public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.mUseLayoutChange) {
            int n9 = view.getRootView().getHeight();
            if (n8 != 0 && n4 < n8 && n4 != n8 && n3 == n7 && n9 < n4 + 200 || n9 > n4 + 200 || n9 < n4) {
                if (n9 > n4 + 200) {
                    this.getSpeechCtrl().setCanShowMicBtn(true);
                    this.getSpeechCtrl().updateMicBtn();
                    DFLayoutHelper.updateDFLayoutNoReal(view, this.mDialogWidth, this.mDialogHeight);
                } else if (n9 < n4) {
                    this.getSpeechCtrl().setCanShowMicBtn(false);
                    this.getSpeechCtrl().updateMicBtn();
                    DFLayoutHelper.updateDFLayoutNoReal(view, this.mDialogWidth, n9 - 36);
                } else {
                    this.getSpeechCtrl().setCanShowMicBtn(false);
                    this.getSpeechCtrl().updateMicBtn();
                    DFLayoutHelper.updateDFLayoutNoReal(view, this.mDialogWidth, n4);
                }
            }
            this.onConfigurationChangedCustom(null);
        }
    }

    private void onConfigurationChangedCustom(Configuration configuration) {
        this.mHandler.postDelayed(new DFManager$5(this), 50L);
    }

    public String getLocale() {
        String string = "";
        if (this.mConnector != null) {
            string = this.mConnector.getLocale();
        }
        return string;
    }

    public boolean isNotDFList() {
        return this.mConnector == null ? false : this.mConnector.getIsNotDFList();
    }

    static /* synthetic */ void access$000(DFManager dFManager, Configuration configuration) {
        dFManager.onConfigurationChangedCustom(configuration);
    }

    static /* synthetic */ DFInfoConnector access$100(DFManager dFManager) {
        return dFManager.mConnector;
    }

    static /* synthetic */ DFSpeechCtrl access$200(DFManager dFManager) {
        return dFManager.mSpeechCtrl;
    }

    static /* synthetic */ DFHandler access$300(DFManager dFManager) {
        return dFManager.mHandler;
    }

    static /* synthetic */ boolean access$400(DFManager dFManager) {
        return dFManager.calcDialogSize();
    }

    static /* synthetic */ boolean access$502(DFManager dFManager, boolean bl) {
        dFManager.mUseLayoutChange = bl;
        return dFManager.mUseLayoutChange;
    }

    static /* synthetic */ int access$600(DFManager dFManager) {
        return dFManager.mDialogHeight;
    }

    static /* synthetic */ int access$700(DFManager dFManager) {
        return dFManager.mDialogWidth;
    }
}

