/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import oz.main.OZStorage;
import oz.viewer.ui.edit.ACanvasCommentView;
import oz.viewer.ui.edit.ACanvasImageView;
import oz.viewer.ui.edit.ACanvasMemoView;
import oz.viewer.ui.edit.ACanvasTrackerView;
import oz.viewer.ui.edit.AControllerImage;
import oz.viewer.ui.edit.AControllerMemo;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableCanvasView$OZGestureListener;
import oz.viewer.ui.edit.AEditableCanvasView$OZScaleListener;
import oz.viewer.ui.edit.AEditableConst$Size;
import oz.viewer.ui.edit.AEditableFrameLayout;

public class AEditableCanvasView
extends AEditableFrameLayout {
    private GestureDetector mGestureDetector;
    private ScaleGestureDetector mScaleDetector;
    private static final float TOUCH_TOLERANCE = 4.0f;
    public final int EDITABLE_MODE_ZOOM = 10003;
    public final int EDITABLE_MODE_DRAG = 10004;
    ACanvasCommentView m_commentCanvas;
    float m_compWidth;
    float m_compHeight;
    public float m_scaleFactor = 1.0f;
    private float m_old_scaleFactor = 1.0f;
    public float m_translateX;
    public float m_translateY;
    private float mX;
    private float mY;
    private float m_oldX;
    private float m_oldY;
    private boolean isFirst = true;
    private float m_trackerIconSize;
    private Paint mTempPaint = new Paint();

    public AEditableCanvasView(Context context, AEditableBaseView aEditableBaseView, float f2, float f3) {
        super(context, aEditableBaseView);
        this.m_compWidth = f2;
        this.m_compHeight = f3;
        try {
            this.m_trackerIconSize = OZStorage.getDrawable(this.getResources().getAssets().open(OZStorage.getImagePath("resource/tracker_rotate@2x.png"))).getIntrinsicHeight();
            this.m_trackerIconSize *= 1.5f;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new AEditableCanvasView$OZGestureListener(this, null), null, false);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new AEditableCanvasView$OZScaleListener(this, null));
        this.setWillNotDraw(false);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n == 4) {
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (4 == keyEvent.getKeyCode()) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    /*
     * Unable to fully structure code
     */
    public void drawEditableCanvasView(Bitmap var1_1) {
        if (this.getBaseView().getICImagePickerWnd().getEditJSON() != null && !this.getBaseView().getICImagePickerWnd().getEditJSON().isEmpty()) {
            if (this.getBaseView().getICImagePickerWnd().getEditType() == 2 && this.getBaseView().getICImagePickerWnd().getCameraType() == 0) {
                try {
                    var2_2 = new JSONObject(this.getBaseView().getICImagePickerWnd().getEditJSON().trim());
                    if (!(var2_2.get("items") instanceof JSONArray)) ** GOTO lbl37
                    var3_4 = (JSONArray)var2_2.get("items");
                    for (var4_5 = 0; var4_5 < var3_4.length(); ++var4_5) {
                        var5_6 = var3_4.get(var4_5);
                        if (!(var5_6 instanceof JSONObject)) continue;
                        var2_2 = (JSONObject)var5_6;
                        var6_7 = var2_2.getString("type");
                        if (var6_7.equalsIgnoreCase("image")) {
                            this.getBaseView().m_ctrlImage = new AControllerImage(this.getContext(), var2_2, this.getBaseView());
                            this.getBaseView().m_ctrlArrayList.add(this.getBaseView().m_ctrlImage);
                            this.getBaseView().m_imageEditor_middle_Layout.addCanvasImageView(this.getBaseView().m_ctrlImage.getImageView());
                            continue;
                        }
                        if (var6_7.equalsIgnoreCase("memo")) {
                            this.getBaseView().m_ctrlMemo = new AControllerMemo(this.getContext(), var2_2, this.getBaseView());
                            this.getBaseView().m_ctrlArrayList.add(this.getBaseView().m_ctrlMemo);
                            this.getBaseView().m_imageEditor_middle_Layout.addCanvasMemoView(this.getBaseView().m_ctrlMemo.getMemoView());
                            continue;
                        }
                        if (!var6_7.equalsIgnoreCase("comment")) continue;
                        if (this.m_commentCanvas == null) {
                            this.m_commentCanvas = this.getCommantView();
                            this.m_commentCanvas.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                            this.addView((View)this.m_commentCanvas);
                        }
                        this.m_commentCanvas.createCommentPath(var2_2);
                    }
                }
                catch (JSONException var2_3) {
                    var2_3.printStackTrace();
                }
            }
        } else if (var1_1 != null) {
            this.addEditableImageView(var1_1);
        }
lbl37:
        // 6 sources

        if (this.m_commentCanvas == null) {
            this.m_commentCanvas = this.getCommantView();
            this.m_commentCanvas.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addView((View)this.m_commentCanvas);
        }
        this.m_commentCanvas.initDrawThread();
        this.m_commentCanvas.startDrawThread();
    }

    public ACanvasCommentView getCommantView() {
        return new ACanvasCommentView(this.getContext(), this.getBaseView());
    }

    public void addEditableImageView(Bitmap bitmap) {
        this.getBaseView().m_ctrlImage = new AControllerImage(this.getContext(), bitmap, this.getBaseView());
        this.getBaseView().m_ctrlArrayList.add(this.getBaseView().m_ctrlImage);
        this.addCanvasImageView(this.getBaseView().m_ctrlImage.getImageView());
    }

    public void addCanvasImageView(ACanvasImageView aCanvasImageView) {
        for (int j = 0; j < this.getChildCount(); ++j) {
            if (!(this.getChildAt(j) instanceof ACanvasTrackerView)) continue;
            this.removeViewAt(j);
        }
        this.addView((View)aCanvasImageView);
        if (this.m_commentCanvas != null) {
            this.m_commentCanvas.bringToFront();
        }
        ACanvasTrackerView aCanvasTrackerView = new ACanvasTrackerView(this.getContext(), aCanvasImageView);
        this.addView((View)aCanvasTrackerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.getBaseView().repaint();
    }

    public void addCanvasMemoView(ACanvasMemoView aCanvasMemoView) {
        int n;
        for (n = 0; n < this.getChildCount(); ++n) {
            if (!(this.getChildAt(n) instanceof ACanvasTrackerView)) continue;
            this.removeViewAt(n);
        }
        n = this.getBaseView().getEditableViewWidth() == 0 ? -1 : this.getBaseView().getEditableViewWidth();
        int n2 = this.getBaseView().getEditableViewHeight() == 0 ? -1 : this.getBaseView().getEditableViewHeight();
        this.addView((View)aCanvasMemoView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
        if (this.m_commentCanvas != null) {
            this.m_commentCanvas.bringToFront();
        }
        ACanvasTrackerView aCanvasTrackerView = new ACanvasTrackerView(this.getContext(), aCanvasMemoView);
        this.addView((View)aCanvasTrackerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
        aCanvasTrackerView.bringToFront();
        this.getBaseView().repaint();
    }

    public Bitmap drawCanvas() {
        Bitmap bitmap = Bitmap.createBitmap((int)((int)this.getBaseView().getDstRect().width()), (int)((int)this.getBaseView().getDstRect().height()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(-this.getBaseView().getDstRect().left, -this.getBaseView().getDstRect().top);
        this.draw(canvas);
        return bitmap;
    }

    protected void onDraw(Canvas canvas) {
        float f2;
        float f3;
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.isFirst) {
            this.getBaseView().setEditableViewHeight(this.getHeight());
            this.getBaseView().setEditableViewWidth(this.getWidth());
            this.isFirst = false;
        }
        float f4 = this.getBaseView().getBottomBar().getHeight();
        float f5 = this.m_trackerIconSize;
        float f6 = this.getBaseView().getEditableViewWidth();
        float f7 = (float)this.getBaseView().getEditableViewHeight() - f4 * 2.0f;
        float f8 = this.m_compWidth;
        float f9 = this.m_compHeight;
        this.getBaseView().createDstRect();
        this.getBaseView().getDstRect().set(0.0f, 0.0f, f6, f7);
        if (f6 * f9 < f7 * f8) {
            this.getBaseView().getDstRect().top = f3 = (f7 - f9 * f6 / f8) / 2.0f;
            this.getBaseView().getDstRect().bottom -= f3;
            f2 = (this.getBaseView().getDstRect().width() - f5 * 2.0f - (float)AEditableConst$Size.EDITABLE_GAP_10) / this.getBaseView().getDstRect().width();
            float f10 = (this.getBaseView().getDstRect().height() - this.getBaseView().getDstRect().height() * f2) / 2.0f;
            this.getBaseView().getDstRect().top += f10;
            this.getBaseView().getDstRect().bottom -= f10;
            this.getBaseView().getDstRect().left += f5 + AEditableConst$Size.EDITABLE_GAP_5;
            this.getBaseView().getDstRect().right -= f5 + AEditableConst$Size.EDITABLE_GAP_5;
        } else {
            this.getBaseView().getDstRect().left = f3 = (f6 - f8 * f7 / f9) / 2.0f;
            this.getBaseView().getDstRect().right -= f3;
            f2 = (this.getBaseView().getDstRect().height() - f5 * 2.0f - (float)AEditableConst$Size.EDITABLE_GAP_10) / this.getBaseView().getDstRect().height();
            float f11 = (this.getBaseView().getDstRect().width() - this.getBaseView().getDstRect().width() * f2) / 2.0f;
            this.getBaseView().getDstRect().left += f11;
            this.getBaseView().getDstRect().right -= f11;
            this.getBaseView().getDstRect().top += f5 + AEditableConst$Size.EDITABLE_GAP_5;
            this.getBaseView().getDstRect().bottom -= f5 + AEditableConst$Size.EDITABLE_GAP_5;
        }
        this.getBaseView().getDstRect().top += f4;
        this.getBaseView().getDstRect().bottom += f4;
        this.getBaseView().m_canvasW = this.getBaseView().getCanvasWidth() / this.getBaseView().getDstRect().width();
        this.m_translateX += (this.getBaseView().getDstRect().right - this.getBaseView().getDstRect().left) * (this.getCanvasScale() - this.getCanvasOldScale()) / 2.0f + this.getBaseView().getDstRect().left * (this.getCanvasScale() - this.getCanvasOldScale());
        this.m_translateY += (this.getBaseView().getDstRect().bottom - this.getBaseView().getDstRect().top) * (this.getCanvasScale() - this.getCanvasOldScale()) / 2.0f + this.getBaseView().getDstRect().top * (this.getCanvasScale() - this.getCanvasOldScale());
        if (this.getCanvasScale() <= 1.0f) {
            this.m_translateX = 0.0f;
            this.m_translateY = 0.0f;
        } else {
            this.m_translateX -= this.mX;
            this.m_translateY -= this.mY;
        }
        if (this.m_translateX <= 0.0f) {
            this.m_translateX = 0.0f;
        } else if (this.m_translateX >= f6 * this.m_scaleFactor - f6) {
            this.m_translateX = f6 * this.m_scaleFactor - f6;
        }
        if (this.m_translateY <= 0.0f) {
            this.m_translateY = 0.0f;
        } else if (this.m_translateY >= f7 * this.m_scaleFactor - f7) {
            this.m_translateY = f7 * this.m_scaleFactor - f7;
        }
        canvas.translate(-this.m_translateX, -this.m_translateY);
        canvas.scale(this.getCanvasScale(), this.getCanvasScale());
        this.setCanvasOldScale(this.getCanvasScale());
        Paint paint = this.mTempPaint;
        paint.reset();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-1);
        canvas.drawRect(this.getBaseView().getDstRect(), paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        paint.setStrokeWidth(AEditableConst$Size.EDITABLE_GAP_1);
        f2 = AEditableConst$Size.EDITABLE_GAP_1 / 2.0f;
        canvas.drawRect(this.getBaseView().getDstRect().left - f2, this.getBaseView().getDstRect().top - f2, this.getBaseView().getDstRect().right + f2, this.getBaseView().getDstRect().bottom + f2, paint);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mScaleDetector.onTouchEvent(motionEvent);
        this.mGestureDetector.onTouchEvent(motionEvent);
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 0: {
                this.m_oldX = f2;
                this.m_oldY = f3;
                break;
            }
            case 5: {
                if (this.getBaseView().getMode() != 10002) break;
                this.m_oldX = f2;
                this.m_oldY = f3;
                break;
            }
            case 261: {
                int n = motionEvent.getPointerCount();
                if (n < 2 || this.getBaseView().getMode() != 10001) break;
                this.m_oldX = f2;
                this.m_oldY = f3;
                break;
            }
            case 2: {
                float f4 = Math.abs(f2 - this.mX);
                float f5 = Math.abs(f3 - this.mY);
                if (!(f4 >= 4.0f) && !(f5 >= 4.0f)) break;
                this.mX = f2 - this.m_oldX;
                this.m_oldX = f2;
                this.mY = f3 - this.m_oldY;
                this.m_oldY = f3;
                this.m_commentCanvas.updateSurface();
                this.invalidate();
                break;
            }
            case 6: {
                this.m_oldX = motionEvent.getX(1);
                this.m_oldY = motionEvent.getY(1);
                break;
            }
            case 262: {
                break;
            }
            case 1: {
                break;
            }
        }
        return true;
    }

    public void setCanvasOldScale(float f2) {
        this.m_old_scaleFactor = f2;
    }

    public void setCanvasScale(float f2) {
        this.m_scaleFactor = f2;
    }

    public float getCanvasOldScale() {
        return this.m_old_scaleFactor;
    }

    public float getCanvasScale() {
        return this.m_scaleFactor;
    }

    public Point getScaledTouch(float f2, float f3) {
        Point point = new Point((int)((f2 + this.m_translateX) / this.getCanvasScale()), (int)((f3 + this.m_translateY) / this.getCanvasScale()));
        return point;
    }
}

