/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.os.Build;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.ATableView;
import oz.viewer.ui.main.overlay.ATableView$ToggleButton$1;

class ATableView$ToggleButton
extends View {
    private static final int TOGGLE_BUTTON_SIZE = 25;
    private static final int TOGGLE_BUTTON_HEIGHT = 180;
    private static final int TOGGLE_LEFTPAD_SIZE = 7;
    private static final int TOGGLE_SHAPE_SIZE = 8;
    private int mSize;
    private int mHeight;
    private Paint mBorderPaint;
    private Paint mFillPaint;
    private Paint mDrawPaint;
    private Path mPath;
    private Path mResizePath;
    private Path mTouchVisiblePath;
    private Path mTouchInvisiblePath;
    private boolean mResizeMode;
    private boolean mTouchDown;
    private GestureDetector mGestureDetector;
    private float mStartX;
    final /* synthetic */ ATableView this$0;

    public ATableView$ToggleButton(ATableView aTableView, Context context) {
        this.this$0 = aTableView;
        super(context);
        this.mResizeMode = false;
        this.mTouchDown = false;
        this.mSize = AOverlayUtil.DpToPx(25);
        this.mHeight = AOverlayUtil.DpToPx(180);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new ATableView$ToggleButton$1(this, aTableView));
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-14277056);
        this.mFillPaint = new Paint(1);
        this.setGradient(this.mFillPaint);
        this.mDrawPaint = new Paint();
        this.mPath = this.makeBorderPath();
        if (Build.VERSION.SDK_INT > 10) {
            this.setLayerType(1, null);
        }
    }

    private void setGradient(Paint paint) {
        paint.setShader((Shader)new LinearGradient((float)this.mSize, 0.0f, 0.0f, 0.0f, new int[]{-1285134733, -849716634, -431141542, -432852160}, new float[]{0.0f, 0.35f, 0.45f, 1.0f}, Shader.TileMode.CLAMP));
    }

    private Path makeBorderPath() {
        float f2 = this.mSize;
        float f3 = f2 / 3.0f * 2.0f;
        float f4 = f3 - f2 / 3.0f / 3.0f;
        float f5 = f3 + f2 / 3.0f / 3.0f;
        float f6 = this.mSize;
        float f7 = f6 / 4.0f * 3.0f;
        float f8 = f7 / 2.0f;
        float f9 = f8 - f8 / 2.0f;
        float f10 = f8 + f8 / 2.0f;
        float f11 = this.mHeight;
        float f12 = f11 / 2.0f;
        Path path = new Path();
        path.reset();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(f9, f4, f8, f3);
        path.cubicTo(f10, f5, f6, f2, f6, f12 - f2);
        path.lineTo(f6, f12 + f2);
        path.cubicTo(f6, f11 - f2, f10, f11 - f5, f8, f11 - f3);
        path.quadTo(f9, f11 - f4, 0.0f, f11);
        path.close();
        return path;
    }

    private Path makeResizePath() {
        Path path = new Path();
        float f2 = AOverlayUtil.DpToPxF(7);
        float f3 = AOverlayUtil.DpToPxF(8);
        float f4 = (float)this.mHeight / 2.0f;
        float f5 = (f3 + 1.0f) / 2.0f;
        float f6 = f2 + f5 + 2.0f;
        path.moveTo(f2 + f5, f4 - f3);
        path.lineTo(f2, f4);
        path.lineTo(f2 + f5, f4 + f3);
        path.lineTo(f2 + f5, f4 - f3);
        path.moveTo(f6, f4 - f3);
        path.lineTo(f6 + f5, f4);
        path.lineTo(f6, f4 + f3);
        path.lineTo(f6, f4 - f3);
        path.close();
        return path;
    }

    private Path makeTouchVisiblePath() {
        Path path = new Path();
        float f2 = AOverlayUtil.DpToPxF(7);
        float f3 = AOverlayUtil.DpToPxF(8);
        float f4 = (float)this.mHeight / 2.0f;
        path.moveTo(f2 + f3, f4 - f3);
        path.lineTo(f2, f4);
        path.lineTo(f2 + f3, f4 + f3);
        path.lineTo(f2 + f3, f4 - f3);
        path.close();
        return path;
    }

    private Path makeTouchInvisiblePath() {
        Path path = new Path();
        float f2 = AOverlayUtil.DpToPxF(7);
        float f3 = AOverlayUtil.DpToPxF(8);
        float f4 = (float)this.mHeight / 2.0f;
        path.moveTo(f2, f4 - f3);
        path.lineTo(f2 + f3, f4);
        path.lineTo(f2, f4 + f3);
        path.lineTo(f2, f4 - f3);
        path.close();
        return path;
    }

    protected void onDraw(Canvas canvas) {
        if (this.this$0.getVisibility() == 0) {
            this.drawRect(canvas);
        }
    }

    private void drawRect(Canvas canvas) {
        Path path;
        if (this.mResizeMode) {
            if (this.mResizePath == null) {
                this.mResizePath = this.makeResizePath();
            }
            path = this.mResizePath;
        } else if (this.this$0.isShowTable()) {
            if (this.mTouchVisiblePath == null) {
                this.mTouchVisiblePath = this.makeTouchVisiblePath();
            }
            path = this.mTouchVisiblePath;
        } else {
            if (this.mTouchInvisiblePath == null) {
                this.mTouchInvisiblePath = this.makeTouchInvisiblePath();
            }
            path = this.mTouchInvisiblePath;
        }
        canvas.save();
        canvas.clipPath(this.mPath);
        canvas.drawPath(this.mPath, this.mFillPaint);
        canvas.restore();
        canvas.drawPath(this.mPath, this.mBorderPaint);
        if (path != null) {
            this.mDrawPaint.reset();
            this.mDrawPaint.setAntiAlias(true);
            if (this.mTouchDown) {
                this.mDrawPaint.setColor(-1);
                this.mDrawPaint.setShadowLayer(5.0f, 0.0f, 0.0f, -256);
            } else {
                this.mDrawPaint.setColor(-1644801);
            }
            canvas.drawPath(path, this.mDrawPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!ATableView.access$400(this.this$0)) {
            boolean bl = this.mGestureDetector.onTouchEvent(motionEvent);
            if (this.mTouchDown) {
                this.this$0.getManager().requestAutoHideTimeReset();
                switch (motionEvent.getAction()) {
                    case 2: {
                        if (!this.mResizeMode) break;
                        if (this.mStartX == -1.0f) {
                            this.mStartX = (float)this.this$0.getRealWidth(false) + motionEvent.getX();
                            break;
                        }
                        if (!(Math.abs((float)this.this$0.getRealWidth(false) + motionEvent.getX() - this.mStartX) > (float)AOverlayUtil.getDP5())) break;
                        this.mStartX = (float)this.this$0.getRealWidth(false) + motionEvent.getX();
                        this.this$0.setRealWidth((int)this.mStartX);
                        this.this$0.updateViewWidth();
                        break;
                    }
                    case 1: {
                        this.mTouchDown = false;
                        this.mResizeMode = false;
                        bl = false;
                        this.invalidate();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
            if (!bl) {
                bl = super.onTouchEvent(motionEvent);
            }
            return bl;
        }
        if (this.mTouchDown) {
            this.mTouchDown = false;
            this.mResizeMode = false;
            this.invalidate();
        }
        return false;
    }

    public int getButtonWidth() {
        return this.mSize;
    }

    public int getButtonHeight() {
        return this.mHeight;
    }

    static /* synthetic */ boolean access$202(ATableView$ToggleButton aTableView$ToggleButton, boolean bl) {
        aTableView$ToggleButton.mResizeMode = bl;
        return aTableView$ToggleButton.mResizeMode;
    }

    static /* synthetic */ boolean access$302(ATableView$ToggleButton aTableView$ToggleButton, boolean bl) {
        aTableView$ToggleButton.mTouchDown = bl;
        return aTableView$ToggleButton.mTouchDown;
    }

    static /* synthetic */ float access$902(ATableView$ToggleButton aTableView$ToggleButton, float f2) {
        aTableView$ToggleButton.mStartX = f2;
        return aTableView$ToggleButton.mStartX;
    }

    static /* synthetic */ boolean access$200(ATableView$ToggleButton aTableView$ToggleButton) {
        return aTableView$ToggleButton.mResizeMode;
    }
}

